/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editors.xpath.rules;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.ui.editors.xpath.rules.ITokenContext;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class WordRule
implements IRule {
    protected static final int UNDEFINED = -1;
    public static final String ANY = "<.:.@>";
    protected IWordDetector fDetector;
    protected IToken fDefaultToken;
    protected int fColumn = -1;
    protected Map<String, IToken> fWords = new HashMap<String, IToken>();
    private StringBuffer fBuffer = new StringBuffer();
    ITokenContext fTokenContext;

    public WordRule(IWordDetector detector) {
        this(detector, Token.UNDEFINED);
    }

    public WordRule(IWordDetector detector, IToken defaultToken) {
        assert (detector != null);
        assert (defaultToken != null);
        this.fDetector = detector;
        this.fDefaultToken = defaultToken;
    }

    public void addWord(String word, IToken token) {
        assert (word != null);
        assert (token != null);
        this.fWords.put(word, token);
    }

    public void setTokenContextCheck(ITokenContext context) {
        this.fTokenContext = context;
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.fTokenContext != null && !this.fTokenContext.check(scanner)) {
            return Token.UNDEFINED;
        }
        int c = scanner.read();
        if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            IToken token = this.get(this.fBuffer.toString());
            if (token != null) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected IToken get(String value) {
        IToken token = this.fWords.get(value);
        if (token == null) {
            return this.fWords.get(ANY);
        }
        return token;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

