/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.decorator.EditPartMarkerDecorator;
import org.eclipse.bpel.common.ui.tray.MainTrayEditPart;
import org.eclipse.bpel.common.ui.tray.TrayEditPart;
import org.eclipse.bpel.common.ui.tray.TrayMarkerDecorator;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.CorrelationSets;
import org.eclipse.bpel.model.MessageExchange;
import org.eclipse.bpel.model.MessageExchanges;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.Variables;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.IHoverHelper;
import org.eclipse.bpel.ui.IHoverHelperSupport;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.editparts.BPELTrayAccessibleEditPart;
import org.eclipse.bpel.ui.editparts.policies.BPELDirectEditPolicy;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.uiextensionmodel.ReferencePartnerLinks;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class ProcessTrayEditPart
extends MainTrayEditPart
implements IHoverHelperSupport {
    protected ISelectionChangedListener selectionListener;
    protected Object lastSelection = null;
    protected MouseMotionListener fMouseMotionListener;

    protected EditPartMarkerDecorator createEditPartMarkerDecorator() {
        return new TrayMarkerDecorator((EObject)this.getModel(), (AbstractLayout)new ToolbarLayout()){

            protected IMarker[] getMarkers() {
                IMarkerHolder holder = BPELUtil.adapt((Object)this.modelObject, IMarkerHolder.class);
                if (holder != null) {
                    return holder.getMarkers(this.modelObject);
                }
                return super.getMarkers();
            }
        };
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new BPELDirectEditPolicy());
    }

    @Override
    public void refreshHoverHelp() {
        IHoverHelper helper = null;
        try {
            helper = BPELUIRegistry.getInstance().getHoverHelper();
            if (helper == null) {
                return;
            }
        }
        catch (CoreException e) {
            this.getFigure().setToolTip(null);
            BPELUIPlugin.log(e);
            return;
        }
        IFigure text = helper.getHoverFigure((EObject)this.getModel());
        this.getFigure().setToolTip(text);
    }

    protected MouseMotionListener getMouseMotionListener() {
        if (this.fMouseMotionListener == null) {
            this.fMouseMotionListener = new MouseMotionListener(){

                public void mouseDragged(MouseEvent me) {
                }

                public void mouseEntered(MouseEvent me) {
                }

                public void mouseExited(MouseEvent me) {
                }

                public void mouseHover(MouseEvent me) {
                }

                public void mouseMoved(MouseEvent me) {
                    ProcessTrayEditPart.this.refreshHoverHelp();
                }
            };
        }
        return this.fMouseMotionListener;
    }

    protected IFigure createFigure() {
        IFigure fig = super.createFigure();
        fig.addMouseMotionListener(this.getMouseMotionListener());
        return fig;
    }

    protected List<?> getModelChildren() {
        MessageExchanges exchanges;
        CorrelationSets sets;
        Variables variables;
        ArrayList<Object> list = new ArrayList<Object>();
        PartnerLinks links = this.getPartnerLinks();
        if (links != null) {
            list.add(links);
        }
        if ((variables = this.getVariables()) != null) {
            list.add(variables);
        }
        if ((sets = this.getCorrelationSets()) != null) {
            list.add(sets);
        }
        if ((exchanges = this.getMessageExchanges()) != null) {
            list.add(exchanges);
        }
        return list;
    }

    protected PartnerLinks getPartnerLinks() {
        if (this.lastSelection instanceof Scope) {
            Scope scope = (Scope)this.lastSelection;
            if (scope.getPartnerLinks() == null) {
                scope.setPartnerLinks(BPELFactory.eINSTANCE.createPartnerLinks());
            }
            return scope.getPartnerLinks();
        }
        Process process = this.getProcess();
        if (process.getPartnerLinks() == null) {
            process.setPartnerLinks(BPELFactory.eINSTANCE.createPartnerLinks());
        }
        return process.getPartnerLinks();
    }

    protected Variables getVariables() {
        if (this.lastSelection instanceof Scope) {
            Scope scope = (Scope)this.lastSelection;
            if (scope.getVariables() == null) {
                scope.setVariables(BPELFactory.eINSTANCE.createVariables());
            }
            return scope.getVariables();
        }
        Process process = this.getProcess();
        if (process.getVariables() == null) {
            process.setVariables(BPELFactory.eINSTANCE.createVariables());
        }
        return process.getVariables();
    }

    protected CorrelationSets getCorrelationSets() {
        if (this.lastSelection instanceof Scope) {
            Scope scope = (Scope)this.lastSelection;
            if (scope.getCorrelationSets() == null) {
                scope.setCorrelationSets(BPELFactory.eINSTANCE.createCorrelationSets());
            }
            return scope.getCorrelationSets();
        }
        Process process = this.getProcess();
        if (process.getCorrelationSets() == null) {
            process.setCorrelationSets(BPELFactory.eINSTANCE.createCorrelationSets());
        }
        return process.getCorrelationSets();
    }

    protected MessageExchanges getMessageExchanges() {
        if (this.lastSelection instanceof Scope) {
            Scope scope = (Scope)this.lastSelection;
            if (scope.getMessageExchanges() == null) {
                scope.setMessageExchanges(BPELFactory.eINSTANCE.createMessageExchanges());
            }
            return scope.getMessageExchanges();
        }
        Process process = this.getProcess();
        if (process.getMessageExchanges() == null) {
            process.setMessageExchanges(BPELFactory.eINSTANCE.createMessageExchanges());
        }
        return process.getMessageExchanges();
    }

    protected Process getProcess() {
        return (Process)this.getModel();
    }

    public void activate() {
        super.activate();
        BPELEditor editor = ModelHelper.getBPELEditor(this.getProcess());
        editor.getGraphicalViewer().addSelectionChangedListener(this.getSelectionChangedListener());
    }

    public void deactivate() {
        super.deactivate();
        try {
            BPELEditor editor = ModelHelper.getBPELEditor(this.getProcess());
            editor.getGraphicalViewer().removeSelectionChangedListener(this.getSelectionChangedListener());
        }
        catch (Exception exception) {}
    }

    public ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object currentSelection = ProcessTrayEditPart.this.getModelObjectFromSelection(event.getSelection());
                    if (this.shouldRefresh(currentSelection)) {
                        ProcessTrayEditPart.this.lastSelection = currentSelection;
                        ProcessTrayEditPart.this.refreshChildren();
                    }
                }

                protected boolean shouldRefresh(Object currentSelection) {
                    if (currentSelection == null) {
                        return false;
                    }
                    if (currentSelection instanceof Variables || currentSelection instanceof Variable) {
                        return false;
                    }
                    if (currentSelection instanceof PartnerLinks || currentSelection instanceof PartnerLink) {
                        return false;
                    }
                    if (currentSelection instanceof CorrelationSets || currentSelection instanceof CorrelationSet) {
                        return false;
                    }
                    if (currentSelection instanceof MessageExchanges || currentSelection instanceof MessageExchange) {
                        return false;
                    }
                    if (currentSelection instanceof ReferencePartnerLinks) {
                        return false;
                    }
                    return ProcessTrayEditPart.this.lastSelection != currentSelection && (ProcessTrayEditPart.this.lastSelection instanceof Scope || currentSelection instanceof Scope);
                }
            };
        }
        return this.selectionListener;
    }

    protected AccessibleEditPart createAccessible() {
        return new BPELTrayAccessibleEditPart((TrayEditPart)this);
    }
}

