/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.tray.TrayComposite;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TraySash
extends Composite {
    protected static final Image ARROW_LEFT = CommonUIPlugin.getDefault().getImageRegistry().get("expandTray");
    protected static final Image ARROW_RIGHT = CommonUIPlugin.getDefault().getImageRegistry().get("collapseTray");
    protected static final Point TEXTURE_SIZE = new Point(15, 50);
    protected static final int TEXTURE_SPACING = 4;
    protected TrayComposite trayComposite;

    public TraySash(TrayComposite composite, Composite parent, int style) {
        super(parent, 0);
        this.trayComposite = composite;
        this.setBackground(CommonUIPlugin.getDefault().getColorRegistry().get("trayBackground"));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 3;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        TrayTextureCanvas topTexture = new TrayTextureCanvas(this, 128);
        TrayButtonCanvas button = new TrayButtonCanvas(this);
        TrayTextureCanvas bottomTexture = new TrayTextureCanvas(this, 1024);
        topTexture.setLayoutData(new GridData(1809));
        button.setLayoutData(new GridData(770));
        bottomTexture.setLayoutData(new GridData(1811));
        MouseTrackAdapter listener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (TraySash.this.trayComposite.isInState(1)) {
                    TraySash.this.setCursor(Cursors.SIZEWE);
                }
            }

            public void mouseExit(MouseEvent e) {
                if (TraySash.this.trayComposite.isInState(1)) {
                    TraySash.this.setCursor(Cursors.ARROW);
                }
            }
        };
        this.addMouseTrackListener((MouseTrackListener)listener);
        topTexture.addMouseTrackListener((MouseTrackListener)listener);
        bottomTexture.addMouseTrackListener((MouseTrackListener)listener);
        TrayComposite.ResizeListener resizeListener = new TrayComposite.ResizeListener(this.trayComposite);
        this.addMouseListener((MouseListener)resizeListener);
        this.addMouseMoveListener(resizeListener);
        topTexture.addMouseListener((MouseListener)resizeListener);
        topTexture.addMouseMoveListener(resizeListener);
        bottomTexture.addMouseListener((MouseListener)resizeListener);
        bottomTexture.addMouseMoveListener(resizeListener);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(CommonUIPlugin.getDefault().getColorRegistry().get("dark_shadow"));
                e.gc.drawLine(0, 0, 0, TraySash.this.getBounds().height);
            }
        });
    }

    protected class TrayButtonCanvas
    extends Canvas {
        protected LightweightSystem lws;

        public TrayButtonCanvas(Composite parent) {
            super(parent, 0x100000);
            this.setCursor(Cursors.ARROW);
            this.lws = new LightweightSystem();
            this.lws.setControl((Canvas)this);
            this.lws.setContents((IFigure)new TrayArrowButton());
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Dimension size = this.lws.getRootFigure().getPreferredSize(wHint, hHint);
            size.union(new Dimension(wHint, hHint));
            return new Point(size.width, size.height * 2);
        }

        private Image getButtonImage() {
            return TraySash.this.trayComposite.isInState(2) ? ARROW_LEFT : ARROW_RIGHT;
        }

        protected class TrayArrowButton
        extends Button {
            public TrayArrowButton() {
                super(TrayButtonCanvas.this.getButtonImage());
                this.setBorder(null);
                this.setRolloverEnabled(true);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        if (((TrayButtonCanvas)((TrayArrowButton)TrayArrowButton.this).TrayButtonCanvas.this).TraySash.this.trayComposite.isInState(2)) {
                            ((TrayButtonCanvas)((TrayArrowButton)TrayArrowButton.this).TrayButtonCanvas.this).TraySash.this.trayComposite.setState(1);
                        } else {
                            ((TrayButtonCanvas)((TrayArrowButton)TrayArrowButton.this).TrayButtonCanvas.this).TraySash.this.trayComposite.setState(2);
                        }
                    }
                });
                ((TrayButtonCanvas)TrayButtonCanvas.this).TraySash.this.trayComposite.addListener(9999999, new Listener(){

                    public void handleEvent(Event event) {
                        TrayArrowButton.this.setContents((IFigure)new ImageFigure(TrayButtonCanvas.this.getButtonImage()));
                    }
                });
            }

            protected void paintBorder(Graphics graphics) {
                if (this.hasFocus()) {
                    graphics.setForegroundColor(ColorConstants.black);
                    graphics.setBackgroundColor(ColorConstants.white);
                    Rectangle area = this.getClientArea();
                    graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
                }
            }
        }
    }

    protected class TrayTextureCanvas
    extends Canvas {
        protected final int MAX_ROWS;
        protected final int MAX_COLUMNS = 2;

        public TrayTextureCanvas(Composite parent, int style) {
            super(parent, 0x100000 | style);
            this.MAX_ROWS = TraySash.TEXTURE_SIZE.y / 4;
            this.MAX_COLUMNS = 2;
            this.setBackground(CommonUIPlugin.getDefault().getColorRegistry().get("light_background"));
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    int height = TrayTextureCanvas.this.getBounds().height;
                    int textureHeight = TrayTextureCanvas.this.MAX_ROWS * 4;
                    int availableHeight = height - textureHeight;
                    int imageHeight = 66;
                    int y = this.isTop() ? Math.min(0, availableHeight - imageHeight) : Math.max(textureHeight, height - imageHeight);
                    e.gc.setBackground(CommonUIPlugin.getDefault().getColorRegistry().get("light_background"));
                    if (this.isTop()) {
                        e.gc.fillRectangle(0, y + imageHeight, TrayTextureCanvas.this.getBounds().width, TrayTextureCanvas.this.getBounds().height);
                    } else {
                        e.gc.fillRectangle(0, 0, TrayTextureCanvas.this.getBounds().width, y);
                    }
                    y = 0;
                    if (this.isTop()) {
                        y = TrayTextureCanvas.this.getBounds().height;
                    }
                    int i = 0;
                    while (i < TrayTextureCanvas.this.MAX_ROWS) {
                        int x = (TraySash.TEXTURE_SIZE.x - 6) / 2;
                        int j = 0;
                        while (j < 2) {
                            e.gc.setForeground(CommonUIPlugin.getDefault().getColorRegistry().get("dark_shadow"));
                            e.gc.drawLine(x, y, x, y + 1);
                            e.gc.setForeground(CommonUIPlugin.getDefault().getColorRegistry().get("canvas"));
                            e.gc.drawLine(x + 1, y, x + 1, y + 1);
                            x += 4;
                            ++j;
                        }
                        y = this.isTop() ? (y -= 4) : (y += 4);
                        ++i;
                    }
                }

                protected boolean isTop() {
                    return (TrayTextureCanvas.this.getStyle() & 0x80) != 0;
                }
            });
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return TEXTURE_SIZE;
        }
    }
}

