/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.wsdl.Input;
import javax.wsdl.Output;
import javax.xml.namespace.QName;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.common.extension.model.ExtensionmodelFactory;
import org.eclipse.bpel.common.extension.model.adapters.ExtendedObjectUserAdapter;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Assign;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.CatchAll;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.Correlations;
import org.eclipse.bpel.model.Else;
import org.eclipse.bpel.model.ElseIf;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.ForEach;
import org.eclipse.bpel.model.FromParts;
import org.eclipse.bpel.model.If;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.MessageExchange;
import org.eclipse.bpel.model.OnAlarm;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.PartnerActivity;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Pick;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Receive;
import org.eclipse.bpel.model.RepeatUntil;
import org.eclipse.bpel.model.Reply;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.model.Throw;
import org.eclipse.bpel.model.ToParts;
import org.eclipse.bpel.model.Validate;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.Variables;
import org.eclipse.bpel.model.While;
import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.model.messageproperties.PropertyAlias;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.PartnerlinktypeFactory;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.model.util.ImportResolver;
import org.eclipse.bpel.model.util.ImportResolverRegistry;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Policy;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.adapters.IExtensionFactory;
import org.eclipse.bpel.ui.adapters.INamedElement;
import org.eclipse.bpel.ui.commands.AddRoleCommand;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.CreatePartnerLinkTypeCommand;
import org.eclipse.bpel.ui.commands.SetPartnerLinkTypeCommand;
import org.eclipse.bpel.ui.commands.SetRoleCommand;
import org.eclipse.bpel.ui.commands.SetUniqueNameCommand;
import org.eclipse.bpel.ui.uiextensionmodel.ActivityExtension;
import org.eclipse.bpel.ui.uiextensionmodel.CaseExtension;
import org.eclipse.bpel.ui.uiextensionmodel.OnAlarmExtension;
import org.eclipse.bpel.ui.uiextensionmodel.OnEventExtension;
import org.eclipse.bpel.ui.uiextensionmodel.OnMessageExtension;
import org.eclipse.bpel.ui.uiextensionmodel.ProcessExtension;
import org.eclipse.bpel.ui.uiextensionmodel.StartNode;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ListMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;

public class ModelHelper {
    public static Object[] EMPTY_ARRAY = new Object[0];
    public static final int OUTGOING = 0;
    public static final int INCOMING = 1;
    public static final int NOT_SPECIFIED = 4;
    public static final int MY_ROLE = 0;
    public static final int PARTNER_ROLE = 1;
    static final Variable[] EMPTY_VARIABLE_LIST = new Variable[0];

    public static String getDisplayName(Object context) {
        if (context instanceof ElseIf) {
            CaseExtension extension = (CaseExtension)ModelHelper.getExtension((EObject)((ElseIf)context));
            return extension == null ? null : extension.getDisplayName();
        }
        if (context instanceof OnMessage) {
            OnMessageExtension extension = (OnMessageExtension)ModelHelper.getExtension((EObject)((OnMessage)context));
            return extension == null ? null : extension.getDisplayName();
        }
        if (context instanceof OnEvent) {
            OnEventExtension extension = (OnEventExtension)ModelHelper.getExtension((EObject)((OnEvent)context));
            return extension == null ? null : extension.getDisplayName();
        }
        if (context instanceof OnAlarm) {
            OnAlarmExtension extension = (OnAlarmExtension)ModelHelper.getExtension((EObject)((OnAlarm)context));
            return extension == null ? null : extension.getDisplayName();
        }
        return null;
    }

    public static boolean supportsJoinFailure(Object context) {
        if (context instanceof Activity) {
            return true;
        }
        return context instanceof Process;
    }

    public static boolean isSetSuppressJoinFailure(Object context) {
        if (context instanceof Activity) {
            return ((Activity)context).isSetSuppressJoinFailure();
        }
        if (context instanceof Process) {
            return ((Process)context).isSetSuppressJoinFailure();
        }
        throw new IllegalArgumentException();
    }

    public static Boolean getSuppressJoinFailure2(Object context) {
        if (context instanceof Activity) {
            return ((Activity)context).getSuppressJoinFailure();
        }
        if (context instanceof Process) {
            return ((Process)context).getSuppressJoinFailure();
        }
        throw new IllegalArgumentException();
    }

    public static Boolean getSuppressJoinFailure(Object context) {
        return ModelHelper.isSetSuppressJoinFailure(context) ? ModelHelper.getSuppressJoinFailure2(context) : null;
    }

    public static void setSuppressJoinFailure(Object context, Boolean value) {
        if (context instanceof Activity) {
            if (value == null) {
                ((Activity)context).unsetSuppressJoinFailure();
                return;
            }
            ((Activity)context).setSuppressJoinFailure(value);
            return;
        }
        if (context instanceof Process) {
            if (value == null) {
                ((Process)context).unsetSuppressJoinFailure();
                return;
            }
            ((Process)context).setSuppressJoinFailure(value);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isSuppressJoinFailureAffected(Object context, Notification n) {
        if (context instanceof Activity) {
            return n.getFeatureID(Activity.class) == 5;
        }
        if (context instanceof Process) {
            return n.getFeatureID(Process.class) == 8;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isMessageActivity(Object context, int direction) {
        switch (direction) {
            case 0: {
                if (context instanceof Reply) {
                    return true;
                }
                if (!(context instanceof Invoke)) break;
                return true;
            }
            case 1: {
                if (context instanceof Receive) {
                    return true;
                }
                if (context instanceof OnMessage) {
                    return true;
                }
                if (context instanceof OnEvent) {
                    return true;
                }
                if (!(context instanceof Invoke)) break;
                Operation op = ModelHelper.getOperation(context);
                return op == null || op.getOutput() != null;
            }
        }
        return false;
    }

    public static Variable getVariable(Object context, int direction) {
        if (context instanceof Invoke) {
            if (direction == 1) {
                return ((Invoke)context).getOutputVariable();
            }
            return ((Invoke)context).getInputVariable();
        }
        if (context instanceof Reply) {
            return ((Reply)context).getVariable();
        }
        if (context instanceof Throw) {
            return ((Throw)context).getFaultVariable();
        }
        if (context instanceof Reply) {
            return ((Reply)context).getVariable();
        }
        if (context instanceof Throw) {
            return ((Throw)context).getFaultVariable();
        }
        if (context instanceof Receive) {
            return ((Receive)context).getVariable();
        }
        if (context instanceof OnMessage) {
            return ((OnMessage)context).getVariable();
        }
        if (context instanceof OnEvent) {
            return ((OnEvent)context).getVariable();
        }
        if (context instanceof Catch) {
            return ((Catch)context).getFaultVariable();
        }
        if (context instanceof ForEach) {
            return ((ForEach)context).getCounterName();
        }
        throw new IllegalArgumentException("This model object has no variable to get");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setVariable(Object context, Variable v, int direction) {
        if (context instanceof Invoke) {
            if (direction == 1) {
                ((Invoke)context).setOutputVariable(v);
                return;
            }
            ((Invoke)context).setInputVariable(v);
            return;
        }
        if (context instanceof Reply) {
            ((Reply)context).setVariable(v);
            return;
        }
        if (context instanceof Invoke) {
            ((Invoke)context).setInputVariable(v);
            return;
        }
        if (context instanceof Throw) {
            ((Throw)context).setFaultVariable(v);
            return;
        }
        if (context instanceof Receive) {
            ((Receive)context).setVariable(v);
            return;
        }
        if (context instanceof OnMessage) {
            ((OnMessage)context).setVariable(v);
            return;
        }
        if (context instanceof OnEvent) {
            ((OnEvent)context).setVariable(v);
            return;
        }
        if (context instanceof Invoke) {
            ((Invoke)context).setOutputVariable(v);
            return;
        }
        if (context instanceof Catch) {
            ((Catch)context).setFaultVariable(v);
            return;
        }
        if (!(context instanceof ForEach)) throw new IllegalArgumentException("This model object has no variable to set");
        ((ForEach)context).setCounterName(v);
    }

    public static boolean isVariableAffected(Object context, Notification n, int direction) {
        if (context instanceof Invoke) {
            if (direction == 1) {
                return n.getFeatureID(Invoke.class) == 12;
            }
            return n.getFeatureID(Invoke.class) == 13;
        }
        if (context instanceof Reply) {
            return n.getFeatureID(Reply.class) == 13;
        }
        if (context instanceof Throw) {
            return n.getFeatureID(Throw.class) == 9;
        }
        if (context instanceof Receive) {
            return n.getFeatureID(Receive.class) == 13;
        }
        if (context instanceof OnMessage) {
            return n.getFeatureID(OnMessage.class) == 4;
        }
        if (context instanceof OnEvent) {
            return n.getFeatureID(OnEvent.class) == 5;
        }
        if (context instanceof Catch) {
            return n.getFeatureID(Catch.class) == 5;
        }
        return false;
    }

    public static MessageExchange getMessageExchange(Object context) {
        if (context instanceof Receive) {
            return ((Receive)context).getMessageExchange();
        }
        if (context instanceof OnMessage) {
            return ((OnMessage)context).getMessageExchange();
        }
        if (context instanceof OnEvent) {
            return ((OnEvent)context).getMessageExchange();
        }
        if (context instanceof Reply) {
            return ((Reply)context).getMessageExchange();
        }
        throw new IllegalArgumentException("Object has no message exchange.");
    }

    public static void setMessageExchange(Object context, MessageExchange messageExchange) {
        if (context instanceof Receive) {
            ((Receive)context).setMessageExchange(messageExchange);
            return;
        }
        if (context instanceof OnMessage) {
            ((OnMessage)context).setMessageExchange(messageExchange);
            return;
        }
        if (context instanceof OnEvent) {
            ((OnEvent)context).setMessageExchange(messageExchange);
            return;
        }
        if (context instanceof Reply) {
            ((Reply)context).setMessageExchange(messageExchange);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static PartnerLink getPartnerLink(Object context) {
        if (context instanceof Invoke) {
            return ((Invoke)context).getPartnerLink();
        }
        if (context instanceof Receive) {
            return ((Receive)context).getPartnerLink();
        }
        if (context instanceof OnMessage) {
            return ((OnMessage)context).getPartnerLink();
        }
        if (context instanceof OnEvent) {
            return ((OnEvent)context).getPartnerLink();
        }
        if (context instanceof Reply) {
            return ((Reply)context).getPartnerLink();
        }
        throw new IllegalArgumentException("Object has no partner link.");
    }

    public static void setPartnerLink(Object context, PartnerLink partner) {
        if (context instanceof Invoke) {
            ((Invoke)context).setPartnerLink(partner);
            return;
        }
        if (context instanceof Receive) {
            ((Receive)context).setPartnerLink(partner);
            return;
        }
        if (context instanceof OnMessage) {
            ((OnMessage)context).setPartnerLink(partner);
            return;
        }
        if (context instanceof OnEvent) {
            ((OnEvent)context).setPartnerLink(partner);
            return;
        }
        if (context instanceof Reply) {
            ((Reply)context).setPartnerLink(partner);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isPartnerAffected(Object context, Notification n) {
        if (context instanceof Invoke) {
            return n.getFeatureID(Invoke.class) == 8;
        }
        if (context instanceof Receive) {
            return n.getFeatureID(Receive.class) == 8;
        }
        if (context instanceof OnMessage) {
            return n.getFeatureID(OnMessage.class) == 7;
        }
        if (context instanceof OnEvent) {
            return n.getFeatureID(OnEvent.class) == 6;
        }
        if (context instanceof Reply) {
            return n.getFeatureID(Reply.class) == 8;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isMessageExchangeAffected(Object context, Notification n) {
        if (context instanceof Receive) {
            return n.getFeatureID(Receive.class) == 15;
        }
        if (context instanceof OnMessage) {
            return n.getFeatureID(OnMessage.class) == 11;
        }
        if (context instanceof OnEvent) {
            return n.getFeatureID(OnEvent.class) == 14;
        }
        if (context instanceof Reply) {
            return n.getFeatureID(Reply.class) == 15;
        }
        throw new IllegalArgumentException();
    }

    public static PortType getPortType(Object context) {
        if (context instanceof Invoke) {
            return ((Invoke)context).getPortType();
        }
        if (context instanceof Receive) {
            return ((Receive)context).getPortType();
        }
        if (context instanceof OnMessage) {
            return ((OnMessage)context).getPortType();
        }
        if (context instanceof OnEvent) {
            return ((OnEvent)context).getPortType();
        }
        if (context instanceof Reply) {
            return ((Reply)context).getPortType();
        }
        if (context instanceof Role) {
            return (PortType)((Role)context).getPortType();
        }
        throw new IllegalArgumentException();
    }

    public static void setPortType(Object context, PortType portType) {
        if (context instanceof Invoke) {
            ((Invoke)context).setPortType(portType);
            return;
        }
        if (context instanceof Receive) {
            ((Receive)context).setPortType(portType);
            return;
        }
        if (context instanceof OnMessage) {
            ((OnMessage)context).setPortType(portType);
            return;
        }
        if (context instanceof OnEvent) {
            ((OnEvent)context).setPortType(portType);
            return;
        }
        if (context instanceof Reply) {
            ((Reply)context).setPortType(portType);
            return;
        }
        if (context instanceof Role) {
            ((Role)context).setPortType((Object)portType);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isPortTypeAffected(Object context, Notification n) {
        if (context instanceof Invoke) {
            return n.getFeatureID(Invoke.class) == 10;
        }
        if (context instanceof Receive) {
            return n.getFeatureID(Receive.class) == 10;
        }
        if (context instanceof OnMessage) {
            return n.getFeatureID(OnMessage.class) == 6;
        }
        if (context instanceof OnEvent) {
            return n.getFeatureID(OnEvent.class) == 9;
        }
        if (context instanceof Reply) {
            return n.getFeatureID(Reply.class) == 10;
        }
        if (context instanceof Role) {
            return n.getFeatureID(Role.class) == 6;
        }
        throw new IllegalArgumentException();
    }

    public static Operation getOperation(Object context) {
        if (context instanceof Invoke) {
            return ((Invoke)context).getOperation();
        }
        if (context instanceof Receive) {
            return ((Receive)context).getOperation();
        }
        if (context instanceof OnMessage) {
            return ((OnMessage)context).getOperation();
        }
        if (context instanceof OnEvent) {
            return ((OnEvent)context).getOperation();
        }
        if (context instanceof Reply) {
            return ((Reply)context).getOperation();
        }
        throw new IllegalArgumentException();
    }

    public static void setOperation(Object context, Operation operation) {
        if (context instanceof Invoke) {
            ((Invoke)context).setOperation(operation);
            return;
        }
        if (context instanceof Receive) {
            ((Receive)context).setOperation(operation);
            return;
        }
        if (context instanceof OnMessage) {
            ((OnMessage)context).setOperation(operation);
            return;
        }
        if (context instanceof OnEvent) {
            ((OnEvent)context).setOperation(operation);
            return;
        }
        if (context instanceof Reply) {
            ((Reply)context).setOperation(operation);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isOperationAffected(Object context, Notification n) {
        if (context instanceof Invoke) {
            return n.getFeatureID(Invoke.class) == 11;
        }
        if (context instanceof Receive) {
            return n.getFeatureID(Receive.class) == 11;
        }
        if (context instanceof OnMessage) {
            return n.getFeatureID(OnMessage.class) == 9;
        }
        if (context instanceof OnEvent) {
            return n.getFeatureID(OnEvent.class) == 8;
        }
        if (context instanceof Reply) {
            return n.getFeatureID(Reply.class) == 11;
        }
        throw new IllegalArgumentException();
    }

    public static Boolean getCreateInstance(Object context) {
        if (context instanceof Receive) {
            return ((Receive)context).getCreateInstance();
        }
        if (context instanceof Pick) {
            return ((Pick)context).getCreateInstance();
        }
        throw new IllegalArgumentException();
    }

    public static Boolean getValidate(Object context) {
        if (context instanceof Assign) {
            return ((Assign)context).getValidate();
        }
        throw new IllegalArgumentException();
    }

    public static void setCreateInstance(Object context, Boolean createInstance) {
        if (context instanceof Receive) {
            ((Receive)context).setCreateInstance(createInstance);
            return;
        }
        if (context instanceof Pick) {
            ((Pick)context).setCreateInstance(createInstance);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setValidate(Object context, Boolean validateXML) {
        if (context instanceof Assign) {
            ((Assign)context).setValidate(validateXML);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isCreateInstanceAffected(Object context, Notification n) {
        if (context instanceof Receive) {
            return n.getFeatureID(Receive.class) == 12;
        }
        if (context instanceof Pick) {
            return n.getFeatureID(Pick.class) == 8;
        }
        throw new IllegalArgumentException();
    }

    public static String getFaultName(Object context) {
        QName qname = ModelHelper.getFaultQName(context);
        return qname == null ? null : qname.getLocalPart();
    }

    public static QName getFaultQName(Object context) {
        if (context instanceof Throw) {
            return ((Throw)context).getFaultName();
        }
        if (context instanceof Catch) {
            return ((Catch)context).getFaultName();
        }
        if (context instanceof Reply) {
            return ((Reply)context).getFaultName();
        }
        throw new IllegalArgumentException();
    }

    public static void setFaultName(Object context, String faultName) {
        if (context instanceof Throw) {
            String oldNS = ModelHelper.getFaultNamespace(context);
            QName newQName = null;
            newQName = new QName(oldNS, faultName == null || faultName.equals("") ? String.valueOf(((Throw)context).getName()) + "DefaultFaultName" : faultName);
            ((Throw)context).setFaultName(newQName);
            return;
        }
        if (context instanceof Catch) {
            String oldNS = ModelHelper.getFaultNamespace(context);
            QName newQName = null;
            if (faultName != null) {
                newQName = new QName(oldNS, faultName);
            }
            ((Catch)context).setFaultName(newQName);
            return;
        }
        if (context instanceof Reply) {
            String oldNS = ModelHelper.getFaultNamespace(context);
            QName newQName = null;
            if (faultName != null) {
                newQName = new QName(oldNS, faultName);
            }
            ((Reply)context).setFaultName(newQName);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isFaultNameAffected(Object context, Notification n) {
        if (context instanceof Throw) {
            return n.getFeatureID(Throw.class) == 8;
        }
        if (context instanceof Catch) {
            return n.getFeatureID(Catch.class) == 4;
        }
        if (context instanceof Reply) {
            return n.getFeatureID(Reply.class) == 12;
        }
        throw new IllegalArgumentException();
    }

    public static String getFaultNamespace(Object context) {
        if (context instanceof Throw) {
            QName qname = ((Throw)context).getFaultName();
            return qname == null ? null : qname.getNamespaceURI();
        }
        if (context instanceof Catch) {
            QName qname = ((Catch)context).getFaultName();
            return qname == null ? null : qname.getNamespaceURI();
        }
        if (context instanceof Reply) {
            QName qname = ((Reply)context).getFaultName();
            return qname == null ? null : qname.getNamespaceURI();
        }
        throw new IllegalArgumentException();
    }

    public static void setFaultNamespace(Object context, String faultNS) {
        if (context instanceof Throw) {
            String oldName = ModelHelper.getFaultName(context);
            QName newQName = null;
            newQName = new QName(faultNS, oldName == null || oldName.equals("") ? String.valueOf(((Throw)context).getName()) + "DefaultFaultName" : oldName);
            ((Throw)context).setFaultName(newQName);
            return;
        }
        if (context instanceof Catch) {
            String oldName = ModelHelper.getFaultName(context);
            QName newQName = null;
            if (oldName != null) {
                newQName = new QName(faultNS, oldName);
            }
            ((Catch)context).setFaultName(newQName);
            return;
        }
        if (context instanceof Reply) {
            String oldName = ModelHelper.getFaultName(context);
            QName newQName = null;
            if (oldName != null) {
                newQName = new QName(faultNS, oldName);
            }
            ((Reply)context).setFaultName(newQName);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isFaultNamespaceAffected(Object context, Notification n) {
        return ModelHelper.isFaultNameAffected(context, n);
    }

    public static boolean isSingleActivityContainer(Object context) {
        if (context instanceof ElseIf) {
            return true;
        }
        if (context instanceof Else) {
            return true;
        }
        if (context instanceof Catch) {
            return true;
        }
        if (context instanceof CatchAll) {
            return true;
        }
        if (context instanceof OnAlarm) {
            return true;
        }
        if (context instanceof OnMessage) {
            return true;
        }
        if (context instanceof OnEvent) {
            return true;
        }
        if (context instanceof Process) {
            return true;
        }
        if (context instanceof While) {
            return true;
        }
        return context instanceof RepeatUntil;
    }

    public static Activity getActivity(Object context) {
        if (context instanceof ElseIf) {
            return ((ElseIf)context).getActivity();
        }
        if (context instanceof Else) {
            return ((Else)context).getActivity();
        }
        if (context instanceof Catch) {
            return ((Catch)context).getActivity();
        }
        if (context instanceof CatchAll) {
            return ((CatchAll)context).getActivity();
        }
        if (context instanceof OnAlarm) {
            return ((OnAlarm)context).getActivity();
        }
        if (context instanceof OnMessage) {
            return ((OnMessage)context).getActivity();
        }
        if (context instanceof OnEvent) {
            return ((OnEvent)context).getActivity();
        }
        if (context instanceof Process) {
            return ((Process)context).getActivity();
        }
        if (context instanceof While) {
            return ((While)context).getActivity();
        }
        if (context instanceof RepeatUntil) {
            return ((RepeatUntil)context).getActivity();
        }
        if (context instanceof Scope) {
            return ((Scope)context).getActivity();
        }
        if (context instanceof FaultHandler) {
            return ModelHelper.getCatchAll((FaultHandler)context);
        }
        if (context instanceof CompensationHandler) {
            return ((CompensationHandler)context).getActivity();
        }
        if (context instanceof TerminationHandler) {
            return ((TerminationHandler)context).getActivity();
        }
        if (context instanceof If) {
            return ((If)context).getActivity();
        }
        if (context instanceof ForEach) {
            return ((ForEach)context).getActivity();
        }
        throw new IllegalArgumentException("ModelHelper.getActivity() - no activity for this context");
    }

    public static void setActivity(Object context, Activity activity) {
        if (context instanceof ElseIf) {
            ((ElseIf)context).setActivity(activity);
            return;
        }
        if (context instanceof Else) {
            ((Else)context).setActivity(activity);
            return;
        }
        if (context instanceof Catch) {
            ((Catch)context).setActivity(activity);
            return;
        }
        if (context instanceof CatchAll) {
            ((CatchAll)context).setActivity(activity);
            return;
        }
        if (context instanceof OnAlarm) {
            ((OnAlarm)context).setActivity(activity);
            return;
        }
        if (context instanceof OnMessage) {
            ((OnMessage)context).setActivity(activity);
            return;
        }
        if (context instanceof OnEvent) {
            ((OnEvent)context).setActivity(activity);
            return;
        }
        if (context instanceof Process) {
            ((Process)context).setActivity(activity);
            return;
        }
        if (context instanceof While) {
            ((While)context).setActivity(activity);
            return;
        }
        if (context instanceof RepeatUntil) {
            ((RepeatUntil)context).setActivity(activity);
            return;
        }
        if (context instanceof Scope) {
            ((Scope)context).setActivity(activity);
            return;
        }
        if (context instanceof FaultHandler) {
            ModelHelper.setCatchAll((FaultHandler)context, activity);
            return;
        }
        if (context instanceof CompensationHandler) {
            ((CompensationHandler)context).setActivity(activity);
            return;
        }
        if (context instanceof TerminationHandler) {
            ((TerminationHandler)context).setActivity(activity);
            return;
        }
        if (context instanceof If) {
            ModelHelper.setElse((If)context, activity);
            return;
        }
        if (context instanceof ForEach) {
            ((ForEach)context).setActivity(activity);
            return;
        }
        throw new IllegalArgumentException("ModelHelper.setActivity() - cannot set activity in this context");
    }

    public static boolean isActivityAffected(Object context, Notification n) {
        if (context instanceof ElseIf) {
            return n.getFeatureID(ElseIf.class) == 5;
        }
        if (context instanceof Catch) {
            return n.getFeatureID(Catch.class) == 6;
        }
        if (context instanceof OnAlarm) {
            return n.getFeatureID(OnAlarm.class) == 4;
        }
        if (context instanceof OnMessage) {
            return n.getFeatureID(OnMessage.class) == 5;
        }
        if (context instanceof OnEvent) {
            return n.getFeatureID(OnEvent.class) == 4;
        }
        if (context instanceof Process) {
            return n.getFeatureID(Process.class) == 12;
        }
        if (context instanceof While) {
            return n.getFeatureID(While.class) == 8;
        }
        if (context instanceof RepeatUntil) {
            return n.getFeatureID(RepeatUntil.class) == 8;
        }
        if (context instanceof Scope) {
            return n.getFeatureID(Scope.class) == 11;
        }
        if (context instanceof CompensationHandler) {
            return n.getFeatureID(CompensationHandler.class) == 4;
        }
        if (context instanceof TerminationHandler) {
            return n.getFeatureID(TerminationHandler.class) == 4;
        }
        if (context instanceof FaultHandler) {
            return ModelHelper.isCatchAllAffected((FaultHandler)context, n);
        }
        if (context instanceof If) {
            return ModelHelper.isElseAffected((If)context, n);
        }
        throw new IllegalArgumentException();
    }

    public static Activity getCatchAll(FaultHandler faultHandler) {
        CatchAll catchAll = faultHandler.getCatchAll();
        return catchAll == null ? null : catchAll.getActivity();
    }

    public static void setCatchAll(FaultHandler faultHandler, Activity activity) {
        if (activity == null) {
            faultHandler.setCatchAll(null);
        } else if (faultHandler.getCatchAll() == null) {
            CatchAll catchAll = BPELFactory.eINSTANCE.createCatchAll();
            faultHandler.setCatchAll(catchAll);
            catchAll.setActivity(activity);
        } else {
            faultHandler.getCatchAll().setActivity(activity);
        }
    }

    public static boolean isCatchAllAffected(FaultHandler faultHandler, Notification n) {
        if (n.getNewValue() instanceof FaultHandler || n.getOldValue() instanceof FaultHandler) {
            return n.getFeatureID(FaultHandler.class) == 5;
        }
        return n.getFeatureID(CatchAll.class) == 4;
    }

    public static Activity getElse(If _if) {
        Else _else = _if.getElse();
        return _else == null ? null : _else.getActivity();
    }

    public static void setElse(If _if, Activity activity) {
        if (activity == null) {
            _if.setElse(null);
        } else if (_if.getElse() == null) {
            Else _else = BPELFactory.eINSTANCE.createElse();
            _if.setElse(_else);
            _else.setActivity(activity);
        } else {
            _if.getElse().setActivity(activity);
        }
    }

    public static boolean isElseAffected(If _if, Notification n) {
        if (n.getNewValue() instanceof If || n.getOldValue() instanceof If) {
            return n.getFeatureID(If.class) == 10;
        }
        return n.getFeatureID(Else.class) == 4;
    }

    public static boolean isRoleAffected(Object context, Notification n, int who) {
        if (context instanceof PartnerLink) {
            switch (who) {
                case 0: {
                    return n.getFeatureID(PartnerLink.class) == 5;
                }
                case 1: {
                    return n.getFeatureID(PartnerLink.class) == 6;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static Message getMessageType(Object context) {
        if (context instanceof Variable) {
            return ((Variable)context).getMessageType();
        }
        if (context instanceof PropertyAlias) {
            return (Message)((PropertyAlias)context).getMessageType();
        }
        if (context instanceof OnEvent) {
            return ((OnEvent)context).getMessageType();
        }
        if (context instanceof org.eclipse.wst.wsdl.Input) {
            return (Message)((org.eclipse.wst.wsdl.Input)context).getMessage();
        }
        throw new IllegalArgumentException();
    }

    public static void setMessageType(Object context, Message messageType) {
        if (context instanceof Variable) {
            ((Variable)context).setMessageType(messageType);
            return;
        }
        if (context instanceof PropertyAlias) {
            ((PropertyAlias)context).setMessageType((Object)messageType);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static Correlations getCorrelations(Object context) {
        if (context instanceof Receive) {
            return ((Receive)context).getCorrelations();
        }
        if (context instanceof Invoke) {
            return ((Invoke)context).getCorrelations();
        }
        if (context instanceof Reply) {
            return ((Reply)context).getCorrelations();
        }
        if (context instanceof OnMessage) {
            return ((OnMessage)context).getCorrelations();
        }
        if (context instanceof OnEvent) {
            return ((OnEvent)context).getCorrelations();
        }
        throw new IllegalArgumentException();
    }

    public static Variable[] getVariablesOfType(EObject context, final Message msg) {
        return (Variable[])ListMap.Map(ModelHelper.getVisibleVariables(context), new ListMap.Visitor(){

            @Override
            public Object visit(Object obj) {
                Variable v = (Variable)obj;
                return v.getMessageType() == msg ? v : ListMap.IGNORE;
            }
        }, (Object[])EMPTY_VARIABLE_LIST);
    }

    public static Variable[] getVariablesOfType(EObject context, final XSDElementDeclaration decl) {
        return (Variable[])ListMap.Map(ModelHelper.getVisibleVariables(context), new ListMap.Visitor(){

            @Override
            public Object visit(Object obj) {
                Variable v = (Variable)obj;
                return v.getXSDElement() == decl ? v : ListMap.IGNORE;
            }
        }, (Object[])EMPTY_VARIABLE_LIST);
    }

    public static Variable[] getVisibleVariables(EObject context) {
        LinkedList<Variable> list = new LinkedList<Variable>();
        EObject refObj = context;
        while (refObj != null) {
            Variables variables;
            List refList = null;
            if (refObj instanceof Process) {
                Process process = (Process)refObj;
                variables = process.getVariables();
                refList = variables == null ? null : variables.getChildren();
            } else if (refObj instanceof Scope) {
                Scope scope = (Scope)refObj;
                variables = scope.getVariables();
                Object object = refList = variables == null ? null : variables.getChildren();
            }
            if (refList != null) {
                for (Variable next : refList) {
                    Object elm = ListMap.findElement(list, next, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            Variable v1 = (Variable)o1;
                            Variable v2 = (Variable)o2;
                            return v1.getName().compareTo(v2.getName());
                        }
                    });
                    if (elm != null) continue;
                    list.add(next);
                }
            }
            refObj = refObj.eContainer();
        }
        return list.toArray(EMPTY_VARIABLE_LIST);
    }

    public static Variables getVariables(Object context) {
        if (context instanceof Process) {
            return ((Process)context).getVariables();
        }
        if (context instanceof Scope) {
            return ((Scope)context).getVariables();
        }
        throw new IllegalArgumentException();
    }

    public static EList<Variable> getValidateVariables(Object context) {
        if (context instanceof Validate) {
            return ((Validate)context).getVariables();
        }
        throw new IllegalArgumentException();
    }

    public static void setCorrelations(Object context, Correlations correlations) {
        if (context instanceof Receive) {
            ((Receive)context).setCorrelations(correlations);
            return;
        }
        if (context instanceof Invoke) {
            ((Invoke)context).setCorrelations(correlations);
            return;
        }
        if (context instanceof Reply) {
            ((Reply)context).setCorrelations(correlations);
            return;
        }
        if (context instanceof OnMessage) {
            ((OnMessage)context).setCorrelations(correlations);
            return;
        }
        if (context instanceof OnEvent) {
            ((OnEvent)context).setCorrelations(correlations);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static PortType getRolePortType(Role role) {
        if (role == null) {
            return null;
        }
        return (PortType)role.getPortType();
    }

    public static PortType getPartnerPortType(PartnerLink partner, int direction) {
        if (partner != null) {
            if (direction == 1) {
                return ModelHelper.getRolePortType(partner.getMyRole());
            }
            if (direction == 0) {
                return ModelHelper.getRolePortType(partner.getPartnerRole());
            }
        }
        return null;
    }

    public static Fault getWSDLFault(Object context) {
        String operationNS;
        Operation operation = ModelHelper.getOperation(context);
        if (operation == null) {
            return null;
        }
        String string = operationNS = operation.getEnclosingDefinition() != null ? operation.getEnclosingDefinition().getTargetNamespace() : null;
        if (operationNS == null) {
            return null;
        }
        if (!operationNS.equals(ModelHelper.getFaultNamespace(context))) {
            return null;
        }
        String faultName = ModelHelper.getFaultName(context);
        if (faultName == null || "".equals(faultName)) {
            return null;
        }
        for (Fault fault : operation.getEFaults()) {
            if (!faultName.equals(fault.getName())) continue;
            return fault;
        }
        return null;
    }

    public static void setWSDLFault(Object context, Fault fault) {
        QName newQName;
        QName qName = newQName = fault == null ? null : new QName(fault.getEnclosingDefinition().getTargetNamespace(), fault.getName());
        if (context instanceof Throw) {
            ((Throw)context).setFaultName(newQName);
            return;
        }
        if (context instanceof Catch) {
            ((Catch)context).setFaultName(newQName);
            return;
        }
        if (context instanceof Reply) {
            ((Reply)context).setFaultName(newQName);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static ExtensibilityElement getExtensibilityElement(Object input, Class clazz) {
        if (!(input instanceof ExtensibleElement)) {
            throw new IllegalArgumentException();
        }
        ExtensibleElement element = (ExtensibleElement)input;
        for (ExtensibilityElement extension : element.getExtensibilityElements()) {
            if (!clazz.isInstance(extension)) continue;
            return extension;
        }
        return null;
    }

    public static ExtensibilityElement getExtensibilityElement(Object input, EClass clazz) {
        if (!(input instanceof ExtensibleElement)) {
            throw new IllegalArgumentException();
        }
        ExtensibleElement element = (ExtensibleElement)input;
        for (ExtensibilityElement extension : element.getExtensibilityElements()) {
            if (!clazz.isSuperTypeOf(extension.eClass())) continue;
            return extension;
        }
        return null;
    }

    public static boolean isExtensionListAffected(Notification n) {
        return n.getFeatureID(ExtensibleElement.class) == 2;
    }

    public static void createExtensionIfNecessary(ExtensionMap extensionMap, EObject input) {
        if (extensionMap == null || input == null || input.eIsProxy()) {
            return;
        }
        try {
            if (extensionMap.get((Object)input) != null) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {}
        extensionMap.remove((Object)input);
        IExtensionFactory extensionFactory = BPELUtil.adapt((Object)input, IExtensionFactory.class);
        if (extensionFactory != null) {
            EObject extension;
            if (Policy.DEBUG) {
                System.out.println("creating extension for: " + input);
            }
            if ((extension = extensionFactory.createExtension(input)) != null) {
                extensionMap.put((Object)input, (Object)extension);
            }
        }
    }

    public static EObject getExtension(EObject input) {
        ExtendedObjectUserAdapter adapter = (ExtendedObjectUserAdapter)ExtensionmodelFactory.eINSTANCE.getExtensionAdapter(input, "http://org.eclipse.bpel.ui/");
        return adapter == null ? null : (EObject)adapter.get((Object)input);
    }

    public static FaultHandler getContainingFaultHandler(Object object) {
        if (object instanceof Process) {
            return null;
        }
        if (object instanceof FaultHandler) {
            return (FaultHandler)object;
        }
        if (object instanceof EObject) {
            return ModelHelper.getContainingFaultHandler(((EObject)object).eContainer());
        }
        return null;
    }

    public static CompensationHandler getContainingCompensationHandler(Object object) {
        if (object instanceof Process) {
            return null;
        }
        if (object instanceof CompensationHandler) {
            return (CompensationHandler)object;
        }
        if (object instanceof EObject) {
            return ModelHelper.getContainingCompensationHandler(((EObject)object).eContainer());
        }
        return null;
    }

    public static EventHandler getContainingEventHandler(Object object) {
        if (object instanceof Process) {
            return null;
        }
        if (object instanceof EventHandler) {
            return (EventHandler)object;
        }
        if (object instanceof EObject) {
            return ModelHelper.getContainingEventHandler(((EObject)object).eContainer());
        }
        return null;
    }

    public static EObject getContainingScope(Object object) {
        if (object instanceof Process) {
            return (EObject)object;
        }
        if (object instanceof Scope) {
            return (EObject)object;
        }
        if (object instanceof EObject) {
            return ModelHelper.getContainingScope(((EObject)object).eContainer());
        }
        return null;
    }

    public static boolean isChildContainedBy(Object modelParent, Object object) {
        EObject cont = ((EObject)object).eContainer();
        while (cont != null) {
            if (modelParent == cont) {
                return true;
            }
            cont = cont.eContainer();
        }
        return false;
    }

    public static void addSubtreeToCollection(Object modelObject, Collection<Object> collection) {
        collection.add(modelObject);
        IContainer container = BPELUtil.adapt(modelObject, IContainer.class);
        if (container != null) {
            Iterator<Object> it = container.getChildren(modelObject).iterator();
            while (it.hasNext()) {
                ModelHelper.addSubtreeToCollection(it.next(), collection);
            }
        }
    }

    public static void setLocation(Activity activity, Point pos) {
        ActivityExtension extension = (ActivityExtension)ModelHelper.getExtension((EObject)activity);
        if (extension != null) {
            extension.setX(pos.x);
            extension.setY(pos.y);
        }
    }

    public static Point getLocation(Activity activity) {
        ActivityExtension extension = (ActivityExtension)ModelHelper.getExtension((EObject)activity);
        if (extension == null) {
            return new Point(0, 0);
        }
        return new Point(extension.getX(), extension.getY());
    }

    public static void setSize(Activity activity, Dimension size) {
        ActivityExtension extension = (ActivityExtension)ModelHelper.getExtension((EObject)activity);
        extension.setWidth(size.width);
        extension.setHeight(size.height);
    }

    public static Dimension getSize(Activity activity) {
        ActivityExtension extension = (ActivityExtension)ModelHelper.getExtension((EObject)activity);
        if (extension == null) {
            return new Dimension(1, 1);
        }
        return new Dimension(extension.getWidth(), extension.getHeight());
    }

    public static BPELEditor getBPELEditor(Object modelObject) {
        if (modelObject instanceof StartNode) {
            modelObject = ((StartNode)modelObject).getProcess();
        }
        if (modelObject instanceof EObject) {
            Resource r = ((EObject)modelObject).eResource();
            if (r != null) {
                return BPELEditor.getBPELEditor(r.getResourceSet());
            }
            throw new IllegalArgumentException("EObject does not have an eResource()");
        }
        if (modelObject instanceof Resource) {
            return BPELEditor.getBPELEditor(((Resource)modelObject).getResourceSet());
        }
        if (modelObject instanceof ResourceSet) {
            return BPELEditor.getBPELEditor((ResourceSet)modelObject);
        }
        throw new IllegalArgumentException("Not an EObject/Resource/ResourceSet");
    }

    public static boolean isHorizontalLayout(Object modelObject) {
        BPELEditor bpelEditor = ModelHelper.getBPELEditor(modelObject);
        if (bpelEditor != null) {
            return bpelEditor.isHorizontalLayout();
        }
        return false;
    }

    public static TreeIterator getAllContents(Object modelObject) {
        if (modelObject instanceof EObject) {
            return ((EObject)modelObject).eAllContents();
        }
        if (modelObject instanceof Resource) {
            return ((Resource)modelObject).getAllContents();
        }
        if (modelObject instanceof ResourceSet) {
            return ((ResourceSet)modelObject).getAllContents();
        }
        throw new IllegalArgumentException();
    }

    public static Object findElementByName(EObject modelObject, String name, Class type) {
        EObject result = null;
        if (modelObject != null && name != null) {
            TreeIterator i = modelObject.eAllContents();
            while (result == null && i.hasNext()) {
                INamedElement namedElement;
                EObject model = (EObject)i.next();
                if (type != null && !type.isInstance(model) || (namedElement = BPELUtil.adapt((Object)model, INamedElement.class)) == null || !name.equals(namedElement.getName(model))) continue;
                result = model;
            }
        }
        return result;
    }

    public static EObject getVariableType(EObject container, int direction) {
        if (container instanceof Invoke) {
            Operation operation = ModelHelper.getOperation(container);
            if (operation == null) {
                return null;
            }
            if (direction == 1) {
                Output output = operation.getOutput();
                return output != null ? (EObject)output.getMessage() : null;
            }
            if (direction == 0) {
                Input input = operation.getInput();
                return input != null ? (EObject)input.getMessage() : null;
            }
            return null;
        }
        if (container instanceof PartnerActivity || container instanceof OnMessage || container instanceof OnEvent) {
            Operation operation = ModelHelper.getOperation(container);
            if (operation == null) {
                return null;
            }
            if (direction == 1) {
                Input input = operation.getInput();
                return input != null ? (EObject)input.getMessage() : null;
            }
            if (direction == 0) {
                Output output = operation.getOutput();
                return output != null ? (EObject)output.getMessage() : null;
            }
            return null;
        }
        return null;
    }

    public static Object getVariableTypeFrom(Object target) {
        if (target instanceof Part) {
            Part part = (Part)target;
            if (part.getElementDeclaration() != null) {
                return part.getElementDeclaration();
            }
            if (part.getTypeDefinition() != null) {
                return part.getTypeDefinition();
            }
        } else if (target instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)BPELUtil.resolveXSDObject(target);
            XSDTypeDefinition type = element.getTypeDefinition();
            if (ModelHelper.isAnonymousType(type)) {
                return element;
            }
            return element.getTypeDefinition();
        }
        return null;
    }

    public static boolean isAnonymousType(XSDTypeDefinition type) {
        return type.getName() == null || "".equals(type.getName());
    }

    public static boolean isSpecCompliant(EObject model) {
        return ((ProcessExtension)ModelHelper.getExtension((EObject)BPELUtils.getProcess((Object)model))).isSpecCompliant();
    }

    public static boolean isReferencePartnerLink(PartnerLink partner) {
        return partner.getPartnerRole() != null;
    }

    public static boolean isInterfacePartnerLink(PartnerLink partner) {
        return partner.getMyRole() != null;
    }

    public static CompoundCommand getCreatePartnerLinkTypeCommand(Process process, PartnerLink partner, PartnerLinkType plt, Definition artifactsDefinition, int whichRole) {
        CompoundCommand compound = new CompoundCommand();
        compound.add((Command)new SetUniqueNameCommand(process, partner));
        compound.add((Command)new CreatePartnerLinkTypeCommand(artifactsDefinition, plt, partner));
        compound.add((Command)new SetPartnerLinkTypeCommand(partner, plt));
        compound.add(ModelHelper.createSetRoleCommand(partner, plt, whichRole));
        return compound;
    }

    public static Command createSetRoleCommand(PartnerLink partnerLink, PartnerLinkType plt, int whichRole) {
        CompoundCommand cmd = new CompoundCommand();
        Role role = PartnerlinktypeFactory.eINSTANCE.createRole();
        role.setName(whichRole == 0 ? "myRole" : "partnerRole");
        cmd.add((Command)new AddRoleCommand(plt, role));
        cmd.add((Command)new SetRoleCommand(partnerLink, role, whichRole));
        return cmd;
    }

    public static Set<Property> getAvailableProperties(Process process) {
        HashSet<Property> properties = new HashSet<Property>();
        EList sets = process.getCorrelationSets().getChildren();
        for (CorrelationSet set : sets) {
            Iterator iterator = set.getProperties().iterator();
            while (iterator.hasNext()) {
                properties.add((Property)iterator.next());
            }
        }
        BPELEditor bpelEditor = ModelHelper.getBPELEditor(process);
        TreeIterator iter = bpelEditor.getArtifactsDefinition().eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!(element instanceof Property)) continue;
            properties.add((Property)element);
        }
        return properties;
    }

    public static EObject getImportedDocument(Import imp) {
        ImportResolver[] resolvers = ImportResolverRegistry.INSTANCE.getResolvers(imp.getImportType());
        int i = 0;
        while (i < resolvers.length) {
            EObject result = resolvers[i].resolve(imp, null, null, null);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static List getSchemas(Object context, boolean bIncludeXSD) {
        ArrayList<XSDSchema> al = new ArrayList<XSDSchema>(8);
        Process process = BPELUtils.getProcess((Object)context);
        if (process == null) {
            return al;
        }
        for (Import imp : process.getImports()) {
            if (imp.getLocation() == null) continue;
            ImportResolver[] resolvers = ImportResolverRegistry.INSTANCE.getResolvers(imp.getImportType());
            int i = 0;
            while (i < resolvers.length) {
                al.addAll(resolvers[i].resolve(imp, 1));
                ++i;
            }
        }
        if (bIncludeXSD) {
            al.add(XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema"));
        }
        return al;
    }

    public static List<Definition> getDefinitions(Object context) {
        ArrayList<Definition> al = new ArrayList<Definition>(8);
        Process process = BPELUtils.getProcess((Object)context);
        if (process == null) {
            return al;
        }
        for (Import imp : process.getImports()) {
            if (imp.getLocation() == null) continue;
            ImportResolver[] resolvers = ImportResolverRegistry.INSTANCE.getResolvers(imp.getImportType());
            int i = 0;
            while (i < resolvers.length) {
                al.addAll(resolvers[i].resolve(imp, 2));
                ++i;
            }
        }
        Definition artifacts = ModelHelper.getBPELEditor(process).getArtifactsDefinition();
        if (!al.contains(artifacts)) {
            al.add(artifacts);
        }
        return al;
    }

    public static boolean containsImport(Object modelObject, Import imp) {
        Process process = BPELUtils.getProcess((Object)modelObject);
        if (process == null) {
            return false;
        }
        EList imports = process.getImports();
        if (imports.contains((Object)imp)) {
            return true;
        }
        Iterator i = imports.iterator();
        boolean bExists = false;
        while (i.hasNext() && !bExists) {
            Import n = (Import)i.next();
            boolean bl = bExists = ModelHelper.isEqual(n.getImportType(), imp.getImportType()) && ModelHelper.isEqual(n.getLocation(), imp.getLocation()) && ModelHelper.isEqual(n.getNamespace(), imp.getNamespace());
        }
        return bExists;
    }

    public static boolean isEqual(String s1, String s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public static ToParts getToParts(EObject model) {
        if (model instanceof Invoke) {
            return ((Invoke)model).getToParts();
        }
        if (model instanceof Reply) {
            return ((Reply)model).getToParts();
        }
        throw new IllegalArgumentException("This model object has no toParts to get");
    }

    public static void setToParts(EObject context, ToParts toParts) {
        if (context instanceof Reply) {
            ((Reply)context).setToParts(toParts);
            return;
        }
        if (context instanceof Invoke) {
            ((Invoke)context).setToParts(toParts);
            return;
        }
        throw new IllegalArgumentException("toParts cannot be set to this model object");
    }

    public static FromParts getFromParts(EObject model) {
        if (model instanceof Invoke) {
            return ((Invoke)model).getFromParts();
        }
        if (model instanceof Receive) {
            return ((Receive)model).getFromParts();
        }
        if (model instanceof OnMessage) {
            return ((OnMessage)model).getFromParts();
        }
        if (model instanceof OnEvent) {
            return ((OnEvent)model).getFromParts();
        }
        throw new IllegalArgumentException("This model object has no fromParts to get");
    }

    public static void setFromParts(EObject context, FromParts fromParts) {
        if (context instanceof Receive) {
            ((Receive)context).setFromParts(fromParts);
            return;
        }
        if (context instanceof Invoke) {
            ((Invoke)context).setFromParts(fromParts);
            return;
        }
        if (context instanceof OnMessage) {
            ((OnMessage)context).setFromParts(fromParts);
            return;
        }
        if (context instanceof OnEvent) {
            ((OnEvent)context).setFromParts(fromParts);
            return;
        }
        throw new IllegalArgumentException("fromParts cannot be set to this model object");
    }
}

