/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator;

import java.io.File;
import java.net.URL;
import org.eclipse.bpel.fnmeta.ClasspathFunctionRegistryLoader;
import org.eclipse.bpel.fnmeta.FunctionLibrary;
import org.eclipse.bpel.fnmeta.IFunctionRegistryLoader;
import org.eclipse.bpel.fnmeta.model.util.FMResourceFactoryImpl;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.adapters.AdapterRegistry;
import org.eclipse.bpel.model.adapters.BasicBPELAdapterFactory;
import org.eclipse.bpel.model.resource.BPELResourceFactoryImpl;
import org.eclipse.bpel.model.resource.BPELResourceSetImpl;
import org.eclipse.bpel.validator.BPELReader;
import org.eclipse.bpel.validator.ModelQuery;
import org.eclipse.bpel.validator.factory.AdapterFactory;
import org.eclipse.bpel.validator.helpers.CmdValidator;
import org.eclipse.bpel.validator.helpers.GetOpt;
import org.eclipse.bpel.validator.helpers.ModelQueryImpl;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.Runner;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.w3c.dom.Element;

public class Main
extends CmdValidator {
    ResourceSet fResourceSet;

    public Main() {
        AdapterRegistry.INSTANCE.registerAdapterFactory((IAdapterFactory)new AdapterFactory());
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)BPELPackage.eINSTANCE, (org.eclipse.emf.common.notify.AdapterFactory)BasicBPELAdapterFactory.INSTANCE);
        this.fResourceSet = new BPELResourceSetImpl();
        this.fResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpel", new BPELResourceFactoryImpl());
        this.fResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        this.fResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        this.fResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("fnmeta", new FMResourceFactoryImpl());
        ModelQueryImpl.register(new ModelQuery());
        FunctionLibrary.INSTANCE.registerLoader((IFunctionRegistryLoader)new ClasspathFunctionRegistryLoader(this.fResourceSet));
    }

    @Override
    public IProblem[] validate(File file) {
        BPELReader reader = new BPELReader();
        reader.read(file, this.fResourceSet);
        Process process = reader.getProcess();
        if (process == null) {
            return super.validate(file);
        }
        this.linkModels((EObject)process);
        INode node = (INode)AdapterRegistry.INSTANCE.adapt((Object)process.getElement(), INode.class);
        this.fRunner = new Runner(new ModelQuery(), node);
        return this.fRunner.run();
    }

    @Override
    public IProblem[] validate(URL source) {
        BPELReader reader = new BPELReader();
        reader.read(source, this.fResourceSet);
        Process process = reader.getProcess();
        if (process == null) {
            return super.validate(source);
        }
        this.linkModels((EObject)process);
        INode node = (INode)AdapterRegistry.INSTANCE.adapt((Object)process.getElement(), INode.class);
        this.fRunner = new Runner(new ModelQuery(), node);
        return this.fRunner.run();
    }

    void linkModels(EObject process) {
        TreeIterator emfIterator = process.eAllContents();
        while (emfIterator.hasNext()) {
            WSDLElement wsdle;
            Element el;
            Object obj = emfIterator.next();
            if (!(obj instanceof WSDLElement) || (el = (wsdle = (WSDLElement)obj).getElement()) == null) continue;
            el.setUserData("emf.model", obj, null);
        }
    }

    public static void main(String[] argv) throws Exception {
        Main builder = new Main();
        GetOpt opt = new GetOpt("-h", argv);
        builder.run(opt);
    }
}

