/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.CollapsableEditPart;
import org.eclipse.bpel.ui.editparts.InvokeEditPart;
import org.eclipse.bpel.ui.editparts.ScopeEditPart;
import org.eclipse.bpel.ui.editparts.StartNodeEditPart;
import org.eclipse.bpel.ui.editparts.policies.BPELOrderedLayoutEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.ContainerHighlightEditPolicy;
import org.eclipse.bpel.ui.util.ImplicitLinkHandlerConnectionRouter;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPolicy;

public class SequenceEditPart
extends CollapsableEditPart {
    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ContainerHighlightEditPolicy(false, true){

            @Override
            protected int getDrawerInset() {
                return 16;
            }

            @Override
            protected int getNorthInset() {
                if (SequenceEditPart.this.isCollapsed()) {
                    return 0;
                }
                return 10;
            }

            @Override
            protected int getSouthInset() {
                return SequenceEditPart.this.isCollapsed() ? 8 : 2;
            }

            @Override
            protected int getEastInset() {
                return 16;
            }

            @Override
            protected int getWestInset() {
                return 16;
            }
        });
        BPELOrderedLayoutEditPolicy policy = null;
        policy = ModelHelper.isHorizontalLayout(this.getModel()) ? new SequenceHorizontalBPELOrderedLayoutPolicy() : new BPELOrderedLayoutEditPolicy();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)policy);
    }

    @Override
    protected void configureExpandedFigure(IFigure aFigure) {
        FlowLayout layout = new FlowLayout();
        layout.setMinorAlignment(0);
        layout.setHorizontal(ModelHelper.isHorizontalLayout(this.getModel()));
        layout.setMajorSpacing(14);
        layout.setMinorSpacing(14);
        aFigure.setLayoutManager((LayoutManager)layout);
    }

    @Override
    public void switchLayout(boolean horizontal) {
        this.removeEditPolicy("LayoutEditPolicy");
        BPELOrderedLayoutEditPolicy newPolicy = null;
        newPolicy = horizontal ? new SequenceHorizontalBPELOrderedLayoutPolicy() : new BPELOrderedLayoutEditPolicy();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)newPolicy);
        ((FlowLayout)this.contentFigure.getLayoutManager()).setHorizontal(horizontal);
    }

    private class SequenceHorizontalBPELOrderedLayoutPolicy
    extends BPELOrderedLayoutEditPolicy {
        private SequenceHorizontalBPELOrderedLayoutPolicy() {
        }

        @Override
        protected ArrayList<PolylineConnection> createHorizontalConnections(BPELEditPart parent) {
            ArrayList<PolylineConnection> connections = new ArrayList<PolylineConnection>();
            List<BPELEditPart> children = this.getConnectionChildren(parent);
            ConnectionAnchor sourceAnchor = null;
            ConnectionAnchor targetAnchor = null;
            BPELEditPart sourcePart = parent;
            sourceAnchor = sourcePart.getConnectionAnchor(2);
            if (children != null) {
                int i = 0;
                while (i < children.size()) {
                    BPELEditPart targetPart;
                    if (i == 0) {
                        targetPart = children.get(i);
                        targetAnchor = targetPart.getConnectionAnchor(2);
                        if (sourceAnchor != null && targetAnchor != null) {
                            connections.add(this.createConnection(sourceAnchor, targetAnchor, this.arrowColor));
                        }
                    }
                    if (i < children.size() - 1) {
                        sourcePart = children.get(i);
                        sourceAnchor = sourcePart.getConnectionAnchor(3);
                        targetPart = children.get(i + 1);
                        targetAnchor = targetPart.getConnectionAnchor(2);
                    } else {
                        sourcePart = children.get(i);
                        sourceAnchor = sourcePart.getConnectionAnchor(3);
                        targetAnchor = parent.getConnectionAnchor(3);
                    }
                    if (sourceAnchor != null && targetAnchor != null) {
                        PolylineConnection connection = this.createConnection(sourceAnchor, targetAnchor, this.arrowColor);
                        if (sourcePart instanceof StartNodeEditPart || sourcePart instanceof ScopeEditPart || sourcePart instanceof InvokeEditPart) {
                            boolean horizontal = ModelHelper.getBPELEditor(this.getHost().getModel()).isHorizontalLayout();
                            connection.setConnectionRouter((ConnectionRouter)new ImplicitLinkHandlerConnectionRouter(horizontal));
                        }
                        connections.add(connection);
                    }
                    ++i;
                }
            }
            return connections;
        }
    }
}

