/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.messageproperties.MessagepropertiesPackage;
import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.PartnerlinktypePackage;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLPackage;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.internal.impl.ImportImpl;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;

public class WSDLUtil {
    public static final String WSDL_MESSAGE = WSDLPackage.eINSTANCE.getMessage().getName();
    public static final String WSDL_PORT_TYPE = WSDLPackage.eINSTANCE.getPortType().getName();
    public static final String WSDL_OPERATION = WSDLPackage.eINSTANCE.getOperation().getName();
    public static final String WSDL_PART = WSDLPackage.eINSTANCE.getPart().getName();
    public static final String WSDL_SERVICE = WSDLPackage.eINSTANCE.getService().getName();
    public static final String XSD_TYPE_DEFINITION = XSDPackage.eINSTANCE.getXSDTypeDefinition().getName();
    public static final String XSD_ELEMENT_DECLARATION = XSDPackage.eINSTANCE.getXSDElementDeclaration().getName();
    public static final String BPEL_PARTNER_LINK_TYPE = PartnerlinktypePackage.eINSTANCE.getPartnerLinkType().getName();
    public static final String BPEL_ROLE = PartnerlinktypePackage.eINSTANCE.getRole().getName();
    public static final String BPEL_PROPERTY = MessagepropertiesPackage.eINSTANCE.getProperty().getName();
    private static boolean RESOLVING_DEEPLY = true;
    static final Finder<Definition, PortType> PORT_TYPE_FINDER = new Finder<Definition, PortType>(){

        @Override
        public PortType find(Definition defn, QName qname) {
            return (PortType)defn.getPortType(qname);
        }
    };
    static final Finder<Definition, Message> MESSAGE_FINDER = new Finder<Definition, Message>(){

        @Override
        public Message find(Definition defn, QName qname) {
            return (Message)defn.getMessage(qname);
        }
    };
    static final Finder<Definition, PartnerLinkType> PARTNER_LINK_TYPE_FINDER = new Finder<Definition, PartnerLinkType>(){

        @Override
        public PartnerLinkType find(Definition defn, QName qname) {
            if (defn.getTargetNamespace() == null) {
                return null;
            }
            if (!defn.getTargetNamespace().equals(qname.getNamespaceURI())) {
                return null;
            }
            for (Object e : defn.getExtensibilityElements()) {
                PartnerLinkType plt;
                if (!(e instanceof PartnerLinkType) || !(plt = (PartnerLinkType)e).getName().equals(qname.getLocalPart())) continue;
                return plt;
            }
            return null;
        }
    };
    static final Finder<Definition, Property> PROPERTY_FINDER = new Finder<Definition, Property>(){

        @Override
        public Property find(Definition defn, QName qname) {
            if (!defn.getTargetNamespace().equals(qname.getNamespaceURI())) {
                return null;
            }
            for (Object e : defn.getExtensibilityElements()) {
                Property property;
                if (!(e instanceof Property) || !(property = (Property)e).getName().equals(qname.getLocalPart())) continue;
                return property;
            }
            return null;
        }
    };
    private static final Finder<XSDSchema, XSDTypeDefinition> TYPE_DEFINITION_FINDER = new Finder<XSDSchema, XSDTypeDefinition>(){

        @Override
        public XSDTypeDefinition find(XSDSchema schema, QName typeName) {
            XSDTypeDefinition typeDef = schema.resolveTypeDefinition(typeName.getNamespaceURI(), typeName.getLocalPart());
            if (typeDef.getContainer() == null) {
                return null;
            }
            return typeDef;
        }
    };
    private static final Finder<XSDSchema, XSDElementDeclaration> ELEMENT_DECLARATION_FINDER = new Finder<XSDSchema, XSDElementDeclaration>(){

        @Override
        public XSDElementDeclaration find(XSDSchema schema, QName qn) {
            XSDElementDeclaration decl = schema.resolveElementDeclaration(qn.getNamespaceURI(), qn.getLocalPart());
            if (decl.getContainer() == null) {
                return null;
            }
            return decl;
        }
    };

    public static boolean isWSDLType(String typeName) {
        return typeName == null ? false : WSDL_MESSAGE.equals(typeName) || WSDL_PORT_TYPE.equals(typeName) || WSDL_OPERATION.equals(typeName) || WSDL_PART.equals(typeName) || WSDL_SERVICE.equals(typeName) || XSD_TYPE_DEFINITION.equals(typeName) || XSD_ELEMENT_DECLARATION.equals(typeName) || BPEL_PARTNER_LINK_TYPE.equals(typeName) || BPEL_ROLE.equals(typeName) || BPEL_PROPERTY.equals(typeName);
    }

    public static void setResolveDeeply(boolean resolveDeeply) {
        RESOLVING_DEEPLY = resolveDeeply;
    }

    public static boolean isResolvingDeeply() {
        return RESOLVING_DEEPLY;
    }

    public static EObject resolveWSDLReference(Definition definition, QName qname, String name, String refType) {
        Object resolvedObject = null;
        if (WSDL_PORT_TYPE.equals(refType)) {
            resolvedObject = WSDLUtil.resolvePortType(definition, qname);
        } else if (WSDL_MESSAGE.equals(refType)) {
            resolvedObject = WSDLUtil.resolveMessage(definition, qname);
        } else if (WSDL_OPERATION.equals(refType)) {
            resolvedObject = WSDLUtil.resolveOperation(definition, qname, name);
        } else if (WSDL_PART.equals(refType)) {
            resolvedObject = WSDLUtil.resolvePart(definition, qname, name);
        } else if (WSDL_SERVICE.equals(refType)) {
            resolvedObject = WSDLUtil.resolveService(definition, qname);
        } else if (XSD_TYPE_DEFINITION.equals(refType)) {
            resolvedObject = WSDLUtil.resolveXSDTypeDefinition(definition, qname);
        } else if (XSD_ELEMENT_DECLARATION.equals(refType)) {
            resolvedObject = WSDLUtil.resolveXSDElementDeclaration(definition, qname);
        } else if (BPEL_PARTNER_LINK_TYPE.equals(refType)) {
            resolvedObject = WSDLUtil.resolveBPELPartnerLinkType(definition, qname);
        } else if (BPEL_ROLE.equals(refType)) {
            resolvedObject = WSDLUtil.resolveBPELRole(definition, qname, name);
        } else if (BPEL_PROPERTY.equals(refType)) {
            resolvedObject = WSDLUtil.resolveBPELProperty(definition, qname);
        } else {
            System.err.println(String.valueOf(WSDLUtil.class.getName()) + ": unrecognized refType: " + refType);
        }
        return resolvedObject;
    }

    public static PortType resolvePortType(Definition definition, QName qname) {
        return WSDLUtil.resolveUsingFinder(definition, qname, PORT_TYPE_FINDER, new HashSet<Definition>());
    }

    static <T extends EObject> T resolveUsingFinder(Definition defn, QName qname, Finder<Definition, T> finder, Set<Definition> seen) {
        if (seen.contains(defn)) {
            return null;
        }
        seen.add(defn);
        Object result = (EObject)finder.find(defn, qname);
        if (result != null || !RESOLVING_DEEPLY) {
            return (T)result;
        }
        Iterator it = defn.getImports(qname.getNamespaceURI()).iterator();
        while (it.hasNext() && result == null) {
            ImportImpl imp = (ImportImpl)it.next();
            imp.importDefinitionOrSchema();
            Definition importedDefinition = (Definition)imp.getDefinition();
            if (importedDefinition == null) continue;
            result = WSDLUtil.resolveUsingFinder(importedDefinition, qname, finder, seen);
        }
        return (T)result;
    }

    public static Message resolveMessage(Definition definition, QName qname) {
        return WSDLUtil.resolveUsingFinder(definition, qname, MESSAGE_FINDER, new HashSet<Definition>());
    }

    public static Operation resolveOperation(Definition definition, QName portTypeQName, String operationName) {
        PortType portType = WSDLUtil.resolvePortType(definition, portTypeQName);
        return WSDLUtil.findOperation(portType, operationName);
    }

    public static Part resolvePart(Definition definition, QName qname, String name) {
        return WSDLUtil.findPart(WSDLUtil.resolveMessage(definition, qname), name);
    }

    public static PartnerLinkType resolveBPELPartnerLinkType(Definition defn, QName qname) {
        return WSDLUtil.resolveUsingFinder(defn, qname, PARTNER_LINK_TYPE_FINDER, new HashSet<Definition>());
    }

    public static EObject resolveBPELRole(Definition definition, QName qname, String name) {
        return WSDLUtil.findRole(WSDLUtil.resolveBPELPartnerLinkType(definition, qname), name);
    }

    public static Property resolveBPELProperty(Definition defn, QName qname) {
        return WSDLUtil.resolveUsingFinder(defn, qname, PROPERTY_FINDER, new HashSet<Definition>());
    }

    private static Service resolveService(Definition definition, QName qname) {
        return (Service)definition.getService(qname);
    }

    static <T> T resolveXSD(Definition definition, QName qname, Finder<XSDSchema, T> finder, Set<Definition> seen) {
        T result = null;
        if (seen.contains(definition)) {
            return result;
        }
        seen.add(definition);
        XSDSchema schema = null;
        String namespace = qname.getNamespaceURI();
        if ("".equals(namespace)) {
            namespace = null;
        }
        if (XSDConstants.isSchemaForSchemaNamespace((String)namespace)) {
            schema = XSDSchemaImpl.getSchemaForSchema((String)namespace);
        } else if (XSDConstants.isSchemaInstanceNamespace((String)namespace)) {
            schema = XSDSchemaImpl.getSchemaInstance((String)namespace);
        }
        if (schema != null && (result = (T)finder.find(schema, qname)) != null) {
            return result;
        }
        Types types = definition.getETypes();
        if (types != null) {
            for (Object e : types.getExtensibilityElements()) {
                XSDSchemaExtensibilityElement schemaEE;
                if (!(e instanceof XSDSchemaExtensibilityElement) || (schema = (schemaEE = (XSDSchemaExtensibilityElement)e).getSchema()) == null || (result = (T)finder.find(schema, qname)) == null) continue;
                return result;
            }
        }
        for (ImportImpl imp : definition.getImports(qname.getNamespaceURI())) {
            imp.importDefinitionOrSchema();
            schema = imp.getESchema();
            if (schema != null && (result = (T)finder.find(schema, qname)) != null) {
                return result;
            }
            Definition importedDefinition = imp.getEDefinition();
            if (importedDefinition == null || (result = (T)WSDLUtil.resolveXSD(importedDefinition, qname, finder, seen)) == null) continue;
            return result;
        }
        return result;
    }

    public static XSDTypeDefinition resolveXSDTypeDefinition(Definition definition, QName qname) {
        return WSDLUtil.resolveXSD(definition, qname, TYPE_DEFINITION_FINDER, new HashSet<Definition>());
    }

    public static XSDElementDeclaration resolveXSDElementDeclaration(Definition definition, QName qname) {
        return WSDLUtil.resolveXSD(definition, qname, ELEMENT_DECLARATION_FINDER, new HashSet<Definition>());
    }

    public static Role findRole(PartnerLinkType plt, String name) {
        if (plt != null) {
            for (Role role : plt.getRole()) {
                if (!name.equals(role.getName())) continue;
                return role;
            }
        }
        return null;
    }

    public static Operation findOperation(PortType portType, String operationName) {
        if (portType != null) {
            for (Operation operation : portType.getOperations()) {
                if (!operation.getName().equals(operationName)) continue;
                return operation;
            }
        }
        return null;
    }

    public static Part findPart(Message message, String name) {
        Part result = null;
        if (message != null) {
            result = (Part)message.getPart(name);
        }
        return result;
    }

    static interface Finder<S, T> {
        public T find(S var1, QName var2);
    }
}

