/*******************************************************************************
 * Copyright (c) 2005, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.bpel.ui.adapters;

import org.eclipse.bpel.model.adapters.AbstractAdapter;
import org.eclipse.bpel.model.adapters.IStatefullAdapter;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.WSDLPackage;
import org.w3c.dom.Element;

public class OperationAdapter extends AbstractAdapter 
	implements ILabeledElement, INamedElement, IContentProposal, IStatefullAdapter {
		
	
	/* ILabeledElement */
	
	public Image getSmallImage(Object object) {
		return BPELUIPlugin.INSTANCE.getImage(IBPELUIConstants.ICON_OPERATION_16);
	}
	
	public Image getLargeImage(Object object) {
		return null;
	}
	
	public String getTypeLabel(Object object) {
		return Messages.OperationAdapter_Operation_1; 
	}
	public String getLabel(Object object) {
		Operation op = getTarget( object ,Operation.class );
		String name = op.getName();
		if (name != null)  {
			return name;
		}
		return getTypeLabel (op) ;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.fieldassist.IContentProposal#getContent()
	 */
	public String getContent() {
		return getLabel ( getTarget() );		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.fieldassist.IContentProposal#getCursorPosition()
	 */
	public int getCursorPosition() {
		// TODO Auto-generated method stub
		return -1;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.fieldassist.IContentProposal#getDescription()
	 */
	public String getDescription() {
		Operation op = getTarget(null, Operation.class );
		Element elm = op.getDocumentationElement();
		return (elm != null ? elm.getNodeValue() : null);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.fieldassist.IContentProposal#getLabel()
	 */

	public String getLabel() {
		return NLS.bind(Messages.OperationAdapter_0, 
				getLabel( getTarget() ),
				getLabel ( getTarget() ) );
	}
	
	/* INamedElement */

	public String getName(Object modelObject) {
		Operation op = getTarget( modelObject ,Operation.class );
		return op.getName();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.bpel.ui.adapters.INamedElement#isNameAffected(java.lang.Object, org.eclipse.emf.common.notify.Notification)
	 */
	public boolean isNameAffected (Object modelObject, Notification n) {
		return (n.getFeatureID(Operation.class) == WSDLPackage.OPERATION__NAME);
	}
	

	/* (non-Javadoc)
	 * @see org.eclipse.bpel.ui.adapters.INamedElement#setName(java.lang.Object, java.lang.String)
	 */
	public void setName(Object modelObject, String name) {
		Operation op = getTarget( modelObject ,Operation.class );
		op.setName( name );		
	}
}
