/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeAttributeValueFilter;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class ToPartValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_TO_PARTS);
    protected String fPartName;
    protected String fVariableName;
    protected INode fVariableNode;
    private INode fPartNode;
    protected INode fActivityNode;

    @Override
    protected void start() {
        super.start();
        this.fActivityNode = this.fParentNode.parentNode();
    }

    @ARule(desc="Check the toVariable on the toPart.", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckVariable_1() {
        this.fPartName = this.getAttribute(this.mNode, AT_PART, 0, Filters.NC_NAME, true);
        this.fVariableName = this.getAttribute(this.mNode, AT_FROM_VARIABLE, 0, Filters.NC_NAME, true);
    }

    @ARule(sa=0, desc="Check to see if part='' fromVariable='' is a duplicate entry.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC_PART__DUPLICATE")
    public void rule_CheckDuplicatePartFromVariable_1() {
        if (this.fPartName == null) {
            return;
        }
        String key = "part." + this.fPartName;
        if (this.containsValueKey(this.fParentNode, key)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PART__DUPLICATE", this.toString(this.mNode.nodeName()), this.fPartName, this.fVariableName);
            return;
        }
        this.setValue(this.fParentNode, key, Boolean.TRUE);
    }

    @ARule(sa=0, desc="Checks to see if the fromVariable is defined.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckVariableDefined_4() {
        if (this.fVariableName == null) {
            return;
        }
        this.fVariableNode = this.mModelQuery.lookup(this.mNode, 1, this.fVariableName);
        if (!this.checkAttributeNode(this.mNode, this.fVariableNode, AT_FROM_VARIABLE, 0)) {
            this.fVariableNode = null;
        }
        if (!this.checkValidator(this.mNode, this.fVariableNode, AT_FROM_VARIABLE, 0)) {
            this.fVariableNode = null;
            return;
        }
    }

    @ARule(sa=54, desc="Check to see if the fromVariable type matches the part name specified", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__PA_NO_PART")
    public void rule_CheckMessageParts_5() {
        if (this.fPartName == null) {
            return;
        }
        INode inputMessageType = this.getValue(this.fActivityNode, "input.message.type", null);
        if (this.isUndefined(inputMessageType)) {
            return;
        }
        this.fPartNode = mSelector.selectNode(inputMessageType, WSDL_ND_PART, new NodeAttributeValueFilter(AT_NAME, this.fPartName));
        if (this.isUndefined(this.fPartNode)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__PA_NO_PART", this.toString(this.mNode.nodeName()), this.fPartName, inputMessageType);
            return;
        }
    }

    @ARule(sa=0, desc="Check toPart and variable type compatibility", author="michal.chmielewski@oracle.com", date="03/10/2007", errors="BPELC_XSD__INCOMPATIBLE_TYPE")
    public void rule_CheckToPartTypeCompatibility_20() {
        if (this.isUndefined(this.fPartNode) || this.isUndefined(this.fVariableNode)) {
            return;
        }
        INode varTypeNode = this.getValue(this.fVariableNode, "type", null);
        if (this.isUndefined(varTypeNode)) {
            return;
        }
        INode partTypeNode = this.mModelQuery.lookup(this.fPartNode, 16, this.fPartName);
        if (this.isUndefined(partTypeNode)) {
            return;
        }
        if (!this.mModelQuery.check(2, partTypeNode, varTypeNode)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_XSD__INCOMPATIBLE_TYPE", this.toString(this.mNode.nodeName()), "text.term.variable", this.fVariableName, varTypeNode, "text.term.messagePart", this.fPartName, partTypeNode);
        }
    }
}

