/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GeneratorBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.GeneratorAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.MissingAttributeException;
import org.eclipse.buckminster.core.cspec.model.MissingDependencyException;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpecBuilder
implements ICSpecData {
    private HashMap<String, AttributeBuilder> attributes;
    private String componentType;
    private List<ComponentRequestBuilder> dependencies;
    private Documentation documentation;
    private HashMap<IComponentIdentifier, GeneratorBuilder> generators;
    private String name;
    private URL projectInfo;
    private String shortDesc;
    private Version version;
    private org.eclipse.buckminster.osgi.filter.Filter filter;

    public CSpecBuilder() {
    }

    @Deprecated
    public CSpecBuilder(IMetadataRepository mdr, IInstallableUnit iu) throws CoreException {
        this(RMContext.getGlobalPropertyAdditions(), mdr, iu);
    }

    public CSpecBuilder(Map<String, ? extends Object> properties, IMetadataRepository mdr, IInstallableUnit iu) throws CoreException {
        String id = iu.getId();
        boolean isFeature = id.endsWith(".feature.group");
        if (isFeature) {
            id = id.substring(0, id.length() - ".feature.group".length());
            this.setComponentTypeID("eclipse.feature");
        } else {
            this.setComponentTypeID("osgi.bundle");
        }
        this.setName(id);
        this.setVersion(iu.getVersion());
        IMatchExpression filterExpr = iu.getFilter();
        if (filterExpr != null) {
            Object param;
            boolean filterOK = false;
            Object[] parameters = filterExpr.getParameters();
            if (parameters.length == 1 && (param = parameters[0]) instanceof Filter) {
                try {
                    org.eclipse.buckminster.osgi.filter.Filter flt = FilterFactory.newInstance((String)param.toString());
                    flt = FilterUtils.replaceAttributeNames((Filter)flt, "osgi", "target");
                    this.setFilter(flt);
                    filterOK = true;
                }
                catch (InvalidSyntaxException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            if (!filterOK) {
                throw BuckminsterException.fromMessage((String)"Unable to convert requirement filter %s into an LDAP filter", (Object[])new Object[]{filterExpr});
            }
        }
        boolean hasBogusFragments = false;
        if (isFeature) {
            Object tmp = properties.get("buckminster.handle.incomplete.platform.features");
            hasBogusFragments = tmp instanceof String && "true".equalsIgnoreCase((String)tmp) ? "org.eclipse.platform".equals(id) || "org.eclipse.equinox.executable".equals(id) || "org.eclipse.rcp".equals(id) : "org.eclipse.equinox.executable".equals(id);
        }
        for (IRequirement cap : iu.getRequirements()) {
            IQuery query;
            IQueryResult result;
            String ctype;
            IMatchExpression matches = cap.getMatches();
            String namespace = RequiredCapability.extractNamespace((IMatchExpression)matches);
            if (namespace == null || (id = RequiredCapability.extractName((IMatchExpression)matches)) == null || id.endsWith("_root") || id.contains("_root.")) continue;
            if ("org.eclipse.equinox.p2.iu".equals(namespace)) {
                if (id.endsWith(".feature.group")) {
                    id = id.substring(0, id.length() - ".feature.group".length());
                    ctype = "eclipse.feature";
                } else {
                    if (!isFeature) continue;
                    ctype = "osgi.bundle";
                }
            } else {
                if (!"osgi.bundle".equals(namespace)) continue;
                ctype = namespace;
            }
            filterExpr = cap.getFilter();
            String filterStr = null;
            if (filterExpr != null) {
                Object param;
                boolean filterOK = false;
                Object[] parameters = filterExpr.getParameters();
                if (parameters.length == 1 && (param = parameters[0]) instanceof Filter) {
                    filterStr = param.toString();
                    filterOK = true;
                }
                if (!filterOK) {
                    throw BuckminsterException.fromMessage((String)"Unable to convert requirement filter %s into an LDAP filter", (Object[])new Object[]{filterExpr});
                }
            }
            if (cap.getMin() == 0) {
                filterStr = filterStr == null ? "(!(eclipse.p2.optional=false))" : "(&(!(eclipse.p2.optional=false))" + filterStr + ')';
            } else if (hasBogusFragments && ctype == "osgi.bundle" && filterStr != null && (result = mdr.query(query = QueryUtil.createMatchQuery((IExpression)matches, (Object[])new Object[0]), null)).isEmpty()) continue;
            ComponentRequestBuilder crb = new ComponentRequestBuilder();
            crb.setName(id);
            crb.setComponentTypeID(ctype);
            crb.setVersionRange(RequiredCapability.extractRange((IMatchExpression)matches));
            if (filterStr != null) {
                try {
                    org.eclipse.buckminster.osgi.filter.Filter flt = FilterFactory.newInstance((String)filterStr);
                    flt = FilterUtils.replaceAttributeNames((Filter)flt, "osgi", "target");
                    crb.setFilter(flt);
                }
                catch (InvalidSyntaxException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            this.addDependency(crb);
        }
        this.addSourceDependency();
    }

    public ActionBuilder addAction(String actionName, boolean publ, String actorName, boolean always) throws AttributeAlreadyDefinedException {
        ActionBuilder bld = this.createActionBuilder();
        bld.setName(actionName);
        bld.setPublic(publ);
        bld.setActorName(actorName);
        bld.setAlways(always);
        this.addAttribute(bld);
        return bld;
    }

    public ArtifactBuilder addArtifact(String n, boolean publ, IPath base) throws AttributeAlreadyDefinedException {
        ArtifactBuilder bld = this.createArtifactBuilder();
        bld.setName(n);
        bld.setPublic(publ);
        bld.setBase(base);
        this.addAttribute(bld);
        return bld;
    }

    public void addAttribute(IAttribute attribute) throws AttributeAlreadyDefinedException {
        String attrName = attribute.getName();
        if (this.attributes == null) {
            this.attributes = new HashMap();
        } else if (this.attributes.containsKey(attrName)) {
            throw new AttributeAlreadyDefinedException(this.name, attrName);
        }
        this.attributes.put(attrName, attribute.getAttributeBuilder(this));
    }

    public boolean addDependency(IComponentRequest dependency) throws CoreException {
        ComponentRequestBuilder bld;
        if (dependency instanceof ComponentRequestBuilder) {
            bld = (ComponentRequestBuilder)dependency;
        } else {
            bld = this.createDependencyBuilder();
            bld.initFrom(dependency);
        }
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<ComponentRequestBuilder>();
            this.dependencies.add(bld);
            return true;
        }
        String depName = dependency.getName();
        String depType = dependency.getComponentTypeID();
        VersionRange depRange = dependency.getVersionRange();
        org.eclipse.buckminster.osgi.filter.Filter depFilter = dependency.getFilter();
        int idx = this.dependencies.size();
        while (--idx >= 0) {
            VersionRange oldRange;
            String oldType;
            ComponentRequestBuilder old = this.dependencies.get(idx);
            if (!old.getName().equals(depName) || (oldType = old.getComponentTypeID()) != null && depType != null && !oldType.equals(depType) || (oldRange = old.getVersionRange()) != null && depRange != null && oldRange.intersect(depRange) == null) continue;
            boolean change = false;
            if (depType == null && oldType != null) {
                depType = oldType;
                change = true;
            }
            if (depRange == null) {
                if (oldRange != null) {
                    depRange = oldRange;
                    change = true;
                }
            } else if (oldRange != null && !depRange.equals((Object)oldRange)) {
                change = true;
                depRange = oldRange.intersect(depRange);
            }
            org.eclipse.buckminster.osgi.filter.Filter oldFilter = old.getFilter();
            if (depFilter == null) {
                if (oldFilter != null) {
                    depFilter = oldFilter;
                    change = true;
                }
            } else if (oldFilter != null && !depFilter.equals((Object)oldFilter)) {
                try {
                    depFilter = FilterFactory.newInstance((String)("(|" + depFilter + oldFilter + ')'));
                    change = true;
                }
                catch (InvalidSyntaxException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            if (!change) {
                return false;
            }
            bld.setComponentTypeID(depType);
            bld.setFilter(depFilter);
            bld.setName(depName);
            bld.setVersionRange(depRange);
            this.dependencies.remove(idx);
            this.dependencies.add(bld);
            return false;
        }
        this.dependencies.add(bld);
        return true;
    }

    public void addGenerator(IGenerator generator) throws GeneratorAlreadyDefinedException {
        IComponentIdentifier ci = generator.getGeneratedIdentifier();
        if (this.generators == null) {
            this.generators = new HashMap();
        } else if (this.generators.containsKey(ci)) {
            throw new GeneratorAlreadyDefinedException(this.name, ci);
        }
        GeneratorBuilder bld = this.createGeneratorBuilder();
        bld.initFrom(generator);
        this.generators.put(ci, bld);
    }

    public GroupBuilder addGroup(String groupName, boolean publ) throws AttributeAlreadyDefinedException {
        GroupBuilder bld = this.createGroupBuilder();
        bld.setName(groupName);
        bld.setPublic(publ);
        this.addAttribute(bld);
        return bld;
    }

    public ActionBuilder addInternalAction(String actionName, boolean publ) throws AttributeAlreadyDefinedException {
        return this.addAction(actionName, publ, null, true);
    }

    public void addSourceDependency() throws CoreException {
        if (this.componentType != null && this.name != null && this.version != null && this.componentType.equals("osgi.bundle") && !this.name.endsWith(".source")) {
            ComponentRequestBuilder srcDep = this.createDependencyBuilder();
            srcDep.setName(String.valueOf(this.name) + ".source");
            srcDep.setComponentTypeID("osgi.bundle");
            srcDep.setVersionRange(VersionHelper.exactRange(this.version));
            try {
                srcDep.setFilter(FilterFactory.newInstance((String)"(&(!(eclipse.p2.optional=false))(buckminster.download.source=true))"));
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            this.addDependency(srcDep);
        }
    }

    public void clear() {
        this.name = null;
        this.componentType = null;
        this.version = null;
        this.filter = null;
        this.projectInfo = null;
        this.documentation = null;
        this.shortDesc = null;
        this.dependencies = null;
        this.attributes = null;
        this.generators = null;
    }

    public ActionArtifactBuilder createActionArtifactBuilder() {
        return new ActionArtifactBuilder(this);
    }

    public ActionBuilder createActionBuilder() {
        return new ActionBuilder(this);
    }

    public ArtifactBuilder createArtifactBuilder() {
        return new ArtifactBuilder(this);
    }

    public AttributeBuilder createAttributeBuilder() {
        return new AttributeBuilder(this);
    }

    public CSpec createCSpec() {
        return new CSpec(this);
    }

    public ComponentRequestBuilder createDependencyBuilder() {
        return new ComponentRequestBuilder();
    }

    public GeneratorBuilder createGeneratorBuilder() {
        return new GeneratorBuilder(this);
    }

    public GroupBuilder createGroupBuilder() {
        return new GroupBuilder(this);
    }

    public void finalWrapUp() {
        if (this.attributes != null && this.dependencies != null) {
            for (AttributeBuilder attr : this.attributes.values()) {
                if (attr instanceof GroupBuilder) {
                    ((GroupBuilder)attr).finalWrapUp(this.dependencies);
                    continue;
                }
                if (!(attr instanceof ActionBuilder)) continue;
                ((ActionBuilder)attr).getPrerequisitesBuilder().finalWrapUp(this.dependencies);
            }
        }
    }

    public ActionBuilder getActionBuilder(String actionName) {
        AttributeBuilder attr;
        if (this.attributes != null && (attr = this.attributes.get(actionName)) instanceof ActionBuilder) {
            return (ActionBuilder)attr;
        }
        return null;
    }

    public Object getAdapter(Class adapterType) {
        if (CSpecBuilder.class.isAssignableFrom(adapterType)) {
            return this;
        }
        if (CSpec.class.isAssignableFrom(adapterType)) {
            return this.createCSpec();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public ArtifactBuilder getArtifactBuilder(String artifactName) {
        AttributeBuilder attr = this.attributes.get(artifactName);
        return attr instanceof ArtifactBuilder ? (ArtifactBuilder)attr : null;
    }

    @Override
    public AttributeBuilder getAttribute(String attrName) {
        return this.attributes == null ? null : this.attributes.get(attrName);
    }

    public Map<String, AttributeBuilder> getAttributes() {
        return this.attributes;
    }

    @Override
    public ComponentIdentifier getComponentIdentifier() {
        return new ComponentIdentifier(this.name, this.componentType, this.version);
    }

    @Override
    public String getComponentTypeID() {
        return this.componentType;
    }

    public Collection<ComponentRequestBuilder> getDependencies() {
        return this.dependencies == null ? Collections.emptyList() : this.dependencies;
    }

    @Override
    @Deprecated
    public ComponentRequestBuilder getDependency(String depName, String depType) throws MissingDependencyException {
        return this.getDependency(depName, depType, null);
    }

    @Override
    public ComponentRequestBuilder getDependency(String depName, String depType, VersionRange depRange) throws MissingDependencyException {
        if (this.dependencies != null) {
            int idx = this.dependencies.size();
            while (--idx >= 0) {
                ComponentRequestBuilder dependency = this.dependencies.get(idx);
                if (!depName.equals(dependency.getName()) || depType != null && dependency.getComponentTypeID() != null && !depType.equals(dependency.getComponentTypeID()) || depRange != null && dependency.getVersionRange() != null && dependency.getVersionRange().intersect(depRange) == null) continue;
                return dependency;
            }
        }
        return null;
    }

    public List<ComponentRequestBuilder> getDependencyBuilders() {
        return this.dependencies;
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public org.eclipse.buckminster.osgi.filter.Filter getFilter() {
        return this.filter;
    }

    public Collection<GeneratorBuilder> getGeneratorList() {
        return this.generators == null ? Collections.emptySet() : this.generators.values();
    }

    public GroupBuilder getGroup(String groupName) {
        AttributeBuilder attr = this.attributes.get(groupName);
        return attr instanceof GroupBuilder ? (GroupBuilder)attr : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getProjectInfo() {
        return this.projectInfo;
    }

    public ActionBuilder getRequiredAction(String actionName) throws MissingAttributeException {
        AttributeBuilder attr = this.attributes.get(actionName);
        if (attr instanceof ActionBuilder) {
            return (ActionBuilder)attr;
        }
        throw new MissingAttributeException(this.name, actionName);
    }

    public ArtifactBuilder getRequiredArtifact(String artifactName) throws MissingAttributeException {
        AttributeBuilder attr;
        if (this.attributes != null && (attr = this.attributes.get(artifactName)) instanceof ArtifactBuilder) {
            return (ArtifactBuilder)attr;
        }
        throw new MissingAttributeException(this.name, artifactName);
    }

    public AttributeBuilder getRequiredAttribute(String attrName) throws MissingAttributeException {
        AttributeBuilder attr;
        if (this.attributes != null && (attr = this.attributes.get(attrName)) != null) {
            return attr;
        }
        throw new MissingAttributeException(this.name, attrName);
    }

    public ComponentRequestBuilder getRequiredDependency(IComponentRequest dep) throws MissingDependencyException {
        ComponentRequestBuilder dependency = this.getDependency(dep.getName(), dep.getComponentTypeID(), dep.getVersionRange());
        if (dependency == null) {
            throw new MissingDependencyException(this.name, dep.toString());
        }
        return dependency;
    }

    @Deprecated
    public ComponentRequestBuilder getRequiredDependency(String dependencyName, String componentTypeID) throws MissingDependencyException {
        ComponentRequestBuilder dependency = this.getDependency(dependencyName, componentTypeID, null);
        if (dependency == null) {
            throw new MissingDependencyException(this.name, dependencyName);
        }
        return dependency;
    }

    public GroupBuilder getRequiredGroup(String groupName) throws MissingAttributeException {
        AttributeBuilder attr = this.attributes.get(groupName);
        if (attr instanceof GroupBuilder) {
            return (GroupBuilder)attr;
        }
        throw new MissingAttributeException(this.name, groupName);
    }

    @Override
    public String getShortDesc() {
        return this.shortDesc;
    }

    public String getTagInfo(String parentInfo) {
        return CSpec.getTagInfo(this.getComponentIdentifier(), this.projectInfo, parentInfo);
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public void initFrom(ICSpecData cspec) throws CoreException {
        this.name = cspec.getName();
        this.componentType = cspec.getComponentTypeID();
        this.version = cspec.getVersion();
        this.filter = cspec.getFilter();
        this.projectInfo = cspec.getProjectInfo();
        this.documentation = cspec.getDocumentation();
        this.shortDesc = cspec.getShortDesc();
        Map<String, ? extends IAttribute> attrs = cspec.getAttributes();
        if (attrs.size() > 0) {
            this.attributes = new HashMap(attrs.size());
            for (IAttribute iAttribute : attrs.values()) {
                this.attributes.put(iAttribute.getName(), iAttribute.getAttributeBuilder(this));
            }
        } else {
            this.attributes = null;
        }
        Collection<? extends IComponentRequest> collection = cspec.getDependencies();
        if (collection.size() > 0) {
            this.dependencies = new ArrayList<ComponentRequestBuilder>(collection.size());
            for (IComponentRequest iComponentRequest : collection) {
                this.addDependency(iComponentRequest);
            }
        } else {
            this.dependencies = null;
        }
        Collection<? extends IGenerator> collection2 = cspec.getGeneratorList();
        if (collection2.size() > 0) {
            this.generators = new HashMap(collection2.size());
            for (IGenerator iGenerator : collection2) {
                GeneratorBuilder gb = this.createGeneratorBuilder();
                gb.initFrom(iGenerator);
                this.generators.put(iGenerator.getGeneratedIdentifier(), gb);
            }
        } else {
            this.generators = null;
        }
    }

    public void removeAttribute(String attributeName) {
        if (this.attributes != null) {
            this.attributes.remove(attributeName);
        }
    }

    public void removeDependency(String dependencyName) {
        if (this.dependencies != null) {
            this.dependencies.remove(dependencyName);
        }
    }

    public void removeGenerator(String generatorName) {
        if (this.generators != null) {
            this.generators.remove(generatorName);
        }
    }

    public void setComponentTypeID(String componentType) {
        this.componentType = componentType;
    }

    public void setDocumentation(Documentation documentation) {
        this.documentation = documentation;
    }

    public void setFilter(org.eclipse.buckminster.osgi.filter.Filter filter) {
        this.filter = filter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProjectInfo(URL projectInfo) {
        this.projectInfo = projectInfo;
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    public void setVersion(Version version) {
        this.version = version;
    }
}

