/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.model;

import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.builder.MissingPathException;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.NamedElement;
import org.eclipse.buckminster.core.cspec.model.PathAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.PropertyAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.cspecext.model.MissingPropertyException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlterAttribute<T extends TopLevelAttribute> {
    public static final String ELEM_ALTER_INSTALLER_HINTS = "alterInstallerHints";
    private final T base;

    static void alterPaths(String compName, String attrName, Set<IPath> original, Set<IPath> added, Set<IPath> removed) throws CoreException {
        if (!added.isEmpty() || !removed.isEmpty()) {
            for (IPath path : removed) {
                if (original.contains(path)) continue;
                throw new MissingPathException(compName, attrName, path);
            }
            for (IPath path : added) {
                if (!original.contains(path)) continue;
                throw new PathAlreadyDefinedException(compName, attrName, path);
            }
            original.addAll(original);
            original.removeAll(removed);
            original.addAll(added);
        }
    }

    static void performPropertyAlterations(String compName, String attrName, String propertyCategory, Map<String, String> original, Map<String, String> altered, Map<String, String> added, Set<String> removed) throws CoreException {
        if (removed.isEmpty() && altered.isEmpty() && added.isEmpty()) {
            return;
        }
        for (String key : removed) {
            if (original.containsKey(key)) continue;
            throw new MissingPropertyException(compName, attrName, propertyCategory, key);
        }
        for (String key : altered.keySet()) {
            if (original.containsKey(key)) continue;
            throw new MissingPropertyException(compName, attrName, propertyCategory, key);
        }
        for (String key : added.keySet()) {
            if (!original.containsKey(key)) continue;
            throw new PropertyAlreadyDefinedException(compName, attrName, propertyCategory, key);
        }
        for (String key : removed) {
            original.remove(key);
        }
        original.putAll(added);
        original.putAll(altered);
    }

    protected AlterAttribute(T base, Set<String> removedHints, Map<String, String> alteredHints) {
        this.base = base;
    }

    public abstract void alterAttribute(TopLevelAttributeBuilder var1) throws CoreException;

    public void alterDocumentation(TopLevelAttributeBuilder original) {
        Documentation origDoc = original.getDocumentation();
        Documentation baseDoc = ((Attribute)this.base).getDocumentation();
        original.setDocumentation(origDoc == null ? baseDoc : origDoc.merge(baseDoc));
    }

    public String getName() {
        return ((NamedElement)((Object)this.base)).getName();
    }

    public boolean isTypeConformant(TopLevelAttribute origAttr) {
        return origAttr.getClass().equals(this.base.getClass());
    }

    protected final T getBase() {
        return this.base;
    }
}

