/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.actor;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.IAttributeFilter;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.ActionArtifact;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.Group;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.internal.actor.GlobalContext;
import org.eclipse.buckminster.core.internal.actor.PerformManager;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformContext
implements IActionContext {
    static final String PRODUCT_PREFIX = "buckminster.product.";
    static final String REQUIREMENT_PREFIX = "buckminster.requirement.";
    private final IProgressMonitor cancellationMonitor;
    private final Action action;
    private final PrintStream errorStream;
    private final GlobalContext globalCtx;
    private final PrintStream outputStream;
    private final Map<String, ? extends Object> properties;

    private static PathGroup[] normalizePathGroups(PathGroup[] pathGroups) throws CoreException {
        if (pathGroups.length == 0) {
            return pathGroups;
        }
        HashMap newPathGroups = new HashMap();
        PathGroup[] pathGroupArray = pathGroups;
        int n = pathGroups.length;
        int n2 = 0;
        while (n2 < n) {
            PathGroup pathGroup = pathGroupArray[n2];
            IPath base = pathGroup.getBase();
            ArrayList<IPath> currentGroup = (ArrayList<IPath>)newPathGroups.get(base);
            if (currentGroup == null) {
                currentGroup = new ArrayList<IPath>();
                newPathGroups.put(base, currentGroup);
            }
            IPath[] iPathArray = pathGroup.getPaths();
            int n3 = iPathArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath path = iPathArray[n4];
                currentGroup.add(path);
                ++n4;
            }
            ++n2;
        }
        ArrayList<PathGroup> normalized = new ArrayList<PathGroup>();
        for (Map.Entry entry : newPathGroups.entrySet()) {
            ArrayList paths = (ArrayList)entry.getValue();
            PerformContext.normalizePaths(paths);
            normalized.add(new PathGroup((IPath)entry.getKey(), paths.toArray(new IPath[paths.size()])));
        }
        return normalized.toArray(new PathGroup[normalized.size()]);
    }

    private static void normalizePaths(ArrayList<IPath> paths) {
        int topDown = paths.size();
        block0: while (--topDown >= 0) {
            IPath path = paths.get(topDown);
            if (path.segmentCount() == 1 && ".".equals(path.lastSegment())) {
                paths.clear();
                return;
            }
            int top = paths.size();
            int idx = 0;
            while (idx < top) {
                if (idx != topDown && paths.get(idx).isPrefixOf(path)) {
                    paths.remove(topDown);
                    continue block0;
                }
                ++idx;
            }
        }
    }

    private static PathGroup[] trimNonExistentBases(PathGroup[] pathGroups) throws CoreException {
        if (pathGroups.length == 0) {
            return pathGroups;
        }
        ArrayList<PathGroup> existentBases = new ArrayList<PathGroup>();
        PathGroup[] pathGroupArray = pathGroups;
        int n = pathGroups.length;
        int n2 = 0;
        while (n2 < n) {
            PathGroup pathGroup = pathGroupArray[n2];
            File file = pathGroup.getBase().toFile().getAbsoluteFile();
            if (file.exists()) {
                existentBases.add(pathGroup);
            } else {
                CorePlugin.getLogger().debug("Base: %s: No such file or directory", new Object[]{file});
            }
            ++n2;
        }
        return existentBases.toArray(new PathGroup[existentBases.size()]);
    }

    public PerformContext(GlobalContext globalCtx, Action action, PrintStream out, PrintStream err, IProgressMonitor cancellationMonitor) throws CoreException {
        this.globalCtx = globalCtx;
        this.action = action;
        this.properties = globalCtx.getExecutionProperties(action);
        this.outputStream = out;
        this.errorStream = err;
        this.cancellationMonitor = cancellationMonitor;
    }

    @Override
    public void addPrerequisitePathGroups(Map<String, PathGroup[]> pgas) throws CoreException {
        List<Prerequisite> prereqs = this.action.getPrerequisites();
        if (prereqs.size() == 0) {
            return;
        }
        CSpec cspec = this.action.getCSpec();
        IPath prereqRebase = this.action.getPrerequisiteRebase();
        if (prereqRebase != null) {
            if ((prereqRebase = PerformManager.expandPath(this.properties, prereqRebase)).isAbsolute()) {
                throw BuckminsterException.fromMessage((String)Messages.Action_prerequisite_base_can_not_be_absolute, (Object[])new Object[0]);
            }
            prereqRebase = cspec.getComponentLocation().append(prereqRebase);
        }
        String mainRQ = REQUIREMENT_PREFIX + this.action.getName();
        String prefix = String.valueOf(mainRQ) + '.';
        ArrayList<PathGroup> allRequiredPaths = new ArrayList<PathGroup>();
        Stack<IAttributeFilter> filters = null;
        for (Prerequisite prereq : prereqs) {
            PathGroup[] paths;
            Attribute ag = prereq.getReferencedAttribute(cspec, this);
            if (ag == null) {
                paths = new PathGroup[]{};
            } else {
                if (prereq.isPatternFilter()) {
                    if (filters == null) {
                        filters = new Stack<IAttributeFilter>();
                    }
                    filters.push(prereq);
                    paths = ag.getPathGroups(this, filters);
                    filters.pop();
                } else {
                    paths = ag.getPathGroups(this, filters);
                }
                paths = PerformContext.normalizePathGroups(paths);
                paths = PerformContext.trimNonExistentBases(paths);
                if (!prereq.isExternal() && prereqRebase != null) {
                    paths = Group.rebase(prereqRebase, paths);
                }
            }
            String alias = prereq.getAlias();
            if (alias != null) {
                pgas.put(alias, paths);
            } else {
                pgas.put(String.valueOf(prefix) + prereq, paths);
            }
            PathGroup[] pathGroupArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                PathGroup path = pathGroupArray[n2];
                allRequiredPaths.add(path);
                ++n2;
            }
        }
        if (allRequiredPaths.size() > 0) {
            PathGroup[] pathGroups = PerformContext.normalizePathGroups(allRequiredPaths.toArray(new PathGroup[allRequiredPaths.size()]));
            String alias = this.action.getPrerequisitesAlias();
            if (alias != null) {
                pgas.put(alias, pathGroups);
            } else {
                pgas.put(mainRQ, pathGroups);
            }
        }
    }

    public void addProductPathGroup(Map<String, PathGroup[]> pgas) throws CoreException {
        List<ActionArtifact> productArtifacts = this.action.getProductArtifacts();
        if (productArtifacts.size() == 0) {
            PathGroup[] product = this.action.getPathGroups(this, null);
            if (product.length > 0) {
                PathGroup[] pathGroups = PerformContext.normalizePathGroups(product);
                String alias = this.action.getProductAlias();
                if (alias != null) {
                    pgas.put(alias, pathGroups);
                } else {
                    pgas.put(PRODUCT_PREFIX + this.action.getName(), pathGroups);
                }
            }
        } else {
            for (ActionArtifact productArtifact : productArtifacts) {
                PathGroup[] pathGroups = PerformContext.normalizePathGroups(productArtifact.getPathGroups(this, null));
                String alias = productArtifact.getAlias();
                if (alias != null) {
                    pgas.put(alias, pathGroups);
                    continue;
                }
                pgas.put(PRODUCT_PREFIX + productArtifact.getName(), pathGroups);
            }
        }
    }

    @Override
    public CSpec findCSpec(ICSpecData ownerCSpec, ComponentRequest request) throws CoreException {
        return this.globalCtx.findCSpec(ownerCSpec, request);
    }

    @Override
    public final Action getAction() {
        return this.action;
    }

    @Override
    public Collection<CSpec> getAllFoundCSpecs() {
        return this.globalCtx.getAllFoundCSpecs();
    }

    @Override
    public IProgressMonitor getCancellationMonitor() {
        return new SubProgressMonitor(this.cancellationMonitor, 1);
    }

    @Override
    public IPath getComponentLocation() throws CoreException {
        return this.getCSpec().getComponentLocation();
    }

    @Override
    public CSpec getCSpec() throws CoreException {
        return this.action.getCSpec();
    }

    @Override
    public final PrintStream getErrorStream() {
        return this.errorStream;
    }

    @Override
    public final GlobalContext getGlobalContext() {
        return this.globalCtx;
    }

    @Override
    public Map<String, PathGroup[]> getNamedPathGroupArrays() throws CoreException {
        HashMap<String, PathGroup[]> pgas = new HashMap<String, PathGroup[]>();
        this.addPrerequisitePathGroups(pgas);
        this.addProductPathGroup(pgas);
        return pgas;
    }

    @Override
    public final PrintStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public Map<String, PathGroup[]> getPathGroupsCache() {
        return this.globalCtx.getPathGroupsCache();
    }

    @Override
    public final Map<String, ? extends Object> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isForced() {
        return this.globalCtx.isForcedExecution() || this.action.isAlways();
    }

    @Override
    public boolean isQuiet() {
        return this.globalCtx.isQuietExecution();
    }

    @Override
    public File makeAbsolute(File file) throws CoreException {
        if (!file.isAbsolute()) {
            file = this.getComponentLocation().append(file.toString()).toFile();
        }
        return file;
    }

    @Override
    public IPath makeAbsolute(IPath path) throws CoreException {
        if (!path.isAbsolute()) {
            path = this.getComponentLocation().append(path);
        }
        return path;
    }
}

