/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.common.parser.PropertyManagerHandler;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.model.WorkspaceBinding;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.metadata.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceBindingHandler
extends PropertyManagerHandler {
    public static final String TAG = "workspaceBinding";
    private ComponentIdentifier cid;
    private UUID resolutionId;
    private IPath location;
    private IPath wsRoot;
    private IPath wsRelativePath;
    private Map<String, String> properties;
    private long timestamp;

    public WorkspaceBindingHandler(AbstractHandler parent) {
        super(parent, TAG);
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        Version version;
        super.handleAttributes(attrs);
        String name = this.getStringValue(attrs, "name");
        String ctype = WorkspaceBindingHandler.getOptionalStringValue((Attributes)attrs, (String)"componentType");
        try {
            version = VersionHelper.parseVersionAttributes(attrs);
        }
        catch (CoreException e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
        }
        this.properties = null;
        this.cid = new ComponentIdentifier(name, ctype, version);
        this.location = Path.fromPortableString((String)this.getStringValue(attrs, "location"));
        this.wsRoot = Path.fromPortableString((String)this.getStringValue(attrs, "workspaceLocation"));
        this.wsRelativePath = Path.fromPortableString((String)this.getStringValue(attrs, "workspaceRelativePath"));
        this.timestamp = this.getLongValue(attrs, "timestamp");
        this.resolutionId = UUID.fromString(this.getStringValue(attrs, "resolutionId"));
    }

    WorkspaceBinding getWorkspaceBinding() throws SAXException {
        return new WorkspaceBinding(this.location, this.cid, this.resolutionId, this.wsRoot, this.wsRelativePath, this.properties, this.timestamp);
    }
}

