/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jarprocessor;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.jarprocessor.JarInfo;
import org.eclipse.buckminster.jarprocessor.ProducerThread;
import org.eclipse.buckminster.jarprocessor.RecursivePack200;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveConditioner
extends RecursivePack200 {
    private static void emitEclipseInf(ZipOutputStream jarOut, JarInfo jarInfo, ZipEntry entry) throws IOException {
        jarOut.putNextEntry(entry);
        Map<String, String> eclipseInf = jarInfo.getEclipseInf();
        eclipseInf.put("pack200.conditioned", "true");
        BMProperties.store(eclipseInf, (OutputStream)jarOut, (String)"Processed using Jarprocessor");
    }

    public RecursiveConditioner(File tempDir, List<String> defaultArgs) {
        super(tempDir, defaultArgs);
    }

    public boolean condition(File jarFile, File conditionedJarFile) throws CoreException {
        boolean bl;
        Logger log = Buckminster.getLogger();
        InputStream input = null;
        FileOutputStream output = null;
        String fileName = jarFile.getAbsolutePath();
        try {
            input = new ZipInputStream(new FileInputStream(jarFile));
            JarInfo jarInfo = JarInfo.getJarInfo(null, fileName, input);
            IOUtils.close((Closeable)input);
            boolean condition = true;
            if (jarInfo.isConditioned()) {
                log.debug("Conditioner: skipping %s, it is already conditioned", new Object[]{fileName});
                condition = false;
            } else if (jarInfo.isSigned()) {
                log.debug("Conditioner: skipping %s, it is already signed", new Object[]{fileName});
                condition = false;
            } else if (jarInfo.isExcludeSign()) {
                log.debug("Conditioner: skipping %s, it is excluded from signing", new Object[]{fileName});
                condition = false;
            } else if (!(jarInfo.hasClasses() || jarInfo.isNested() && !jarInfo.isExcludeChildrenSign())) {
                log.debug("Conditioner: skipping %s, it has no classes and has no nested jars eligable for signing", new Object[]{fileName});
                condition = false;
            }
            input = new FileInputStream(jarFile);
            output = new FileOutputStream(conditionedJarFile);
            if (condition) {
                this.nestedConditioning(input, jarInfo, output);
            } else {
                IOUtils.copy((InputStream)input, (OutputStream)output, null);
            }
            bl = condition;
        }
        catch (IOException e) {
            try {
                throw BuckminsterException.fromMessage((Throwable)e, (String)"Unable to condition %s", (Object[])new Object[]{fileName});
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                IOUtils.close(output);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)input);
        IOUtils.close((Closeable)output);
        return bl;
    }

    private void nestedConditioning(final InputStream input, final JarInfo jarInfo, OutputStream conditioned) throws CoreException {
        final ProducerThread jarPumper = new ProducerThread("Pack200 jarPumper"){

            protected void internalRun(OutputStream writer) throws Exception {
                ZipEntry entry;
                ZipOutputStream jarOut = new ZipOutputStream(writer);
                ZipInputStream jarIn = new ZipInputStream(input);
                boolean metaAddingDone = false;
                boolean hasEclipseInf = false;
                while ((entry = jarIn.getNextEntry()) != null) {
                    JarInfo nested;
                    String name = entry.getName();
                    entry = RecursiveConditioner.createEntry(entry);
                    if (name.equals("META-INF/eclipse.inf")) {
                        if (hasEclipseInf) continue;
                        RecursiveConditioner.emitEclipseInf(jarOut, jarInfo, entry);
                        hasEclipseInf = true;
                        continue;
                    }
                    if (entry.isDirectory()) {
                        jarOut.putNextEntry(entry);
                        continue;
                    }
                    if (!(!name.endsWith(".jar") || jarInfo.isExcludeChildrenSign() || (nested = jarInfo.getNestedInfo(name)) == null || nested.isConditioned() || nested.isSigned() || nested.isExcludeSign())) {
                        Buckminster.getLogger().debug("Conditioner: Recursive conditioning of %s", new Object[]{name});
                        jarOut.putNextEntry(entry);
                        RecursiveConditioner.this.nestedConditioning(jarIn, nested, jarOut);
                        continue;
                    }
                    jarOut.putNextEntry(entry);
                    IOUtils.copy((InputStream)jarIn, (OutputStream)jarOut, null);
                    if (metaAddingDone || !name.equals("META-INF/MANIFEST.MF")) continue;
                    metaAddingDone = true;
                    if (jarInfo.hasEclipseInf()) continue;
                    Buckminster.getLogger().debug("Conditioner: Adding META-INF/eclipse.inf", new Object[0]);
                    RecursiveConditioner.emitEclipseInf(jarOut, jarInfo, new ZipEntry("META-INF/eclipse.inf"));
                    hasEclipseInf = true;
                }
                jarOut.finish();
            }
        };
        jarPumper.start();
        ProducerThread packPumper = new ProducerThread("Pack200 packPumper"){

            protected void internalRun(OutputStream writer) throws Exception {
                try {
                    RecursiveConditioner.this.pack(jarInfo, jarPumper.getReaderStream(), writer);
                }
                catch (IOException e) {
                    jarPumper.drain(jarInfo, e);
                }
                jarPumper.drain(jarInfo, null);
            }
        };
        packPumper.start();
        try {
            this.unpack(new RecursivePack200.NonClosingInputStream(packPumper.getReaderStream()), conditioned);
        }
        catch (IOException e) {
            packPumper.drain(jarInfo, e);
        }
        packPumper.drain(jarInfo, null);
    }
}

