/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.Repository;

public class CompareCoreUtils {
    public static String getResourceEncoding(Repository db, String repoPath) {
        IPath absolutePath;
        if (db.isBare()) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile resource = root.getFileForLocation(absolutePath = new Path(db.getWorkTree().getAbsolutePath()).append(repoPath));
        if (resource == null) {
            return null;
        }
        return CompareCoreUtils.getResourceEncoding((IResource)resource);
    }

    public static String getResourceEncoding(IResource resource) {
        String charset;
        IEncodedStorage encodedStorage = (IEncodedStorage)resource;
        try {
            charset = encodedStorage.getCharset();
            if (charset == null) {
                charset = resource.getParent().getDefaultCharset();
            }
        }
        catch (CoreException e) {
            charset = "UTF-8";
        }
        return charset;
    }
}

