/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.GitTag;
import org.eclipse.egit.core.internal.storage.CommitBlobStorage;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.ITag;

class CommitFileRevision
extends GitFileRevision {
    private final Repository db;
    private final RevCommit commit;
    private final PersonIdent author;
    private final String path;
    private ObjectId blobId;

    CommitFileRevision(Repository repo, RevCommit rc, String fileName) {
        this(repo, rc, fileName, null);
    }

    CommitFileRevision(Repository repo, RevCommit rc, String fileName, ObjectId blob) {
        super(fileName);
        this.db = repo;
        this.commit = rc;
        this.author = rc.getAuthorIdent();
        this.path = fileName;
        this.blobId = blob;
    }

    String getGitPath() {
        return this.path;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.blobId == null) {
            this.blobId = this.locateBlobObjectId();
        }
        return new CommitBlobStorage(this.db, this.path, this.blobId, this.commit);
    }

    public long getTimestamp() {
        return this.author != null ? this.author.getWhen().getTime() : 0L;
    }

    public String getContentIdentifier() {
        return this.commit.getId().name();
    }

    public String getAuthor() {
        return this.author != null ? this.author.getName() : null;
    }

    public String getComment() {
        return this.commit.getShortMessage();
    }

    public String toString() {
        return this.commit.getId() + ":" + this.path;
    }

    public ITag[] getTags() {
        ArrayList<GitTag> ret = new ArrayList<GitTag>();
        for (Map.Entry tag : this.db.getTags().entrySet()) {
            Ref ref = this.db.peel((Ref)tag.getValue());
            ObjectId refId = ref.getPeeledObjectId();
            if (refId == null) {
                refId = ref.getObjectId();
            }
            if (!AnyObjectId.equals((AnyObjectId)refId, (AnyObjectId)this.commit)) continue;
            ret.add(new GitTag((String)tag.getKey()));
        }
        return ret.toArray(new ITag[ret.size()]);
    }

    public RevCommit getRevCommit() {
        return this.commit;
    }

    private ObjectId locateBlobObjectId() throws CoreException {
        try {
            TreeWalk w = TreeWalk.forPath((Repository)this.db, (String)this.path, (RevTree)this.commit.getTree());
            if (w == null) {
                throw new CoreException(Activator.error(NLS.bind((String)CoreText.CommitFileRevision_pathNotIn, (Object)this.commit.getId().name(), (Object)this.path), null));
            }
            return w.getObjectId(0);
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.CommitFileRevision_errorLookingUpPath, (Object)this.commit.getId().name(), (Object)this.path), e));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.blobId == null ? 0 : this.blobId.hashCode());
        result = 31 * result + (this.commit == null ? 0 : this.commit.hashCode());
        result = 31 * result + (this.db == null ? 0 : this.db.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CommitFileRevision other = (CommitFileRevision)((Object)obj);
        if (this.author == null ? other.author != null : !this.author.equals((Object)other.author)) {
            return false;
        }
        if (this.blobId == null ? other.blobId != null : !this.blobId.equals((AnyObjectId)other.blobId)) {
            return false;
        }
        if (this.commit == null ? other.commit != null : !this.commit.equals((AnyObjectId)other.commit)) {
            return false;
        }
        if (this.db == null ? other.db != null : !this.db.equals(other.db)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

