/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;

public class CreatePatchOperation
implements IEGitOperation {
    public static final int DEFAULT_CONTEXT_LINES = 3;
    private final RevCommit commit;
    private final Repository repository;
    private DiffHeaderFormat headerFormat = DiffHeaderFormat.EMAIL;
    private String currentEncoding = null;
    private String patchContent;
    private int contextLines = 3;

    public CreatePatchOperation(Repository repository, RevCommit commit) {
        if (repository == null) {
            throw new IllegalArgumentException(CoreText.CreatePatchOperation_repoRequired);
        }
        this.repository = repository;
        this.commit = commit;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        EclipseGitProgressTransformer gitMonitor = monitor == null ? new EclipseGitProgressTransformer((IProgressMonitor)new NullProgressMonitor()) : new EclipseGitProgressTransformer(monitor);
        final StringBuilder sb = new StringBuilder();
        DiffFormatter diffFmt = new DiffFormatter((OutputStream)new ByteArrayOutputStream(){

            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                if (CreatePatchOperation.this.currentEncoding == null) {
                    sb.append(this.toString());
                } else {
                    try {
                        sb.append(this.toString(CreatePatchOperation.this.currentEncoding));
                    }
                    catch (UnsupportedEncodingException e) {
                        sb.append(this.toString());
                    }
                }
                this.reset();
            }
        });
        diffFmt.setProgressMonitor((ProgressMonitor)gitMonitor);
        diffFmt.setContext(this.contextLines);
        if (this.headerFormat != null && this.headerFormat != DiffHeaderFormat.NONE) {
            this.writeGitPatchHeader(sb);
        }
        diffFmt.setRepository(this.repository);
        try {
            if (this.commit != null) {
                RevCommit[] parents = this.commit.getParents();
                if (parents.length > 1) {
                    throw new IllegalStateException(CoreText.CreatePatchOperation_cannotCreatePatchForMergeCommit);
                }
                if (parents.length == 0) {
                    throw new IllegalStateException(CoreText.CreatePatchOperation_cannotCreatePatchForFirstCommit);
                }
                List diffs = diffFmt.scan((AnyObjectId)parents[0].getId(), (AnyObjectId)this.commit.getId());
                for (DiffEntry ent : diffs) {
                    String path = DiffEntry.ChangeType.DELETE.equals((Object)ent.getChangeType()) ? ent.getOldPath() : ent.getNewPath();
                    this.currentEncoding = CompareCoreUtils.getResourceEncoding(this.repository, path);
                    diffFmt.format(ent);
                }
            } else {
                diffFmt.format((AbstractTreeIterator)new DirCacheIterator(this.repository.readDirCache()), (AbstractTreeIterator)new FileTreeIterator(this.repository));
            }
        }
        catch (IOException e) {
            Activator.logError(CoreText.CreatePatchOperation_patchFileCouldNotBeWritten, e);
        }
        this.patchContent = sb.toString();
        if (this.patchContent.endsWith("\n")) {
            this.patchContent = this.patchContent.substring(0, this.patchContent.length() - 1);
        }
    }

    public String getPatchContent() {
        if (this.patchContent == null) {
            throw new IllegalStateException("#execute needs to be called before this method.");
        }
        return this.patchContent;
    }

    private void writeGitPatchHeader(StringBuilder sb) {
        String template = this.headerFormat.getTemplate();
        String[] segments = template.split("\\$\\{");
        Stack<String> evaluated = new Stack<String>();
        evaluated.add(segments[0]);
        int i = 1;
        while (i < segments.length) {
            String segment = segments[i];
            String value = null;
            int brace = segment.indexOf(125);
            if (brace > 0) {
                String keyword = segment.substring(0, brace);
                keyword = keyword.toUpperCase().replaceAll(" ", "_");
                value = CreatePatchOperation.processKeyword(this.commit, DiffHeaderKeyword.valueOf(keyword));
            }
            String trailingCharacters = segment.substring(brace + 1);
            if (value != null) {
                evaluated.add(value);
                evaluated.add(trailingCharacters);
            } else if (!evaluated.isEmpty()) {
                evaluated.add(trailingCharacters);
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        for (String string : evaluated) {
            buffer.append(string);
        }
        sb.append(buffer);
    }

    private static String processKeyword(RevCommit commit, DiffHeaderKeyword keyword) {
        SimpleDateFormat dtfmt = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
        switch (keyword) {
            case SHA1: {
                return commit.getId().getName();
            }
            case AUTHOR: {
                return String.valueOf(commit.getAuthorIdent().getName()) + " <" + commit.getAuthorIdent().getEmailAddress() + ">";
            }
            case AUTHOR_DATE: {
                dtfmt.setTimeZone(commit.getAuthorIdent().getTimeZone());
                return dtfmt.format(commit.getAuthorIdent().getWhen());
            }
            case DATE: {
                return dtfmt.format(System.currentTimeMillis());
            }
            case TITLE_LINE: {
                return commit.getShortMessage();
            }
            case FULL_COMMIT_MESSAGE: {
                return commit.getFullMessage().substring(commit.getShortMessage().length());
            }
        }
        return null;
    }

    public void setHeaderFormat(DiffHeaderFormat format) {
        this.headerFormat = format;
    }

    public void setContextLines(int contextLines) {
        this.contextLines = contextLines;
    }

    public static String suggestFileName(RevCommit commit) {
        char[] charArray;
        String name = commit.getShortMessage();
        name = name.trim();
        StringBuilder filteredBuilder = new StringBuilder();
        char[] cArray = charArray = name.toCharArray();
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetter(c) || Character.isDigit(c)) {
                filteredBuilder.append(c);
            }
            if (Character.isWhitespace(c) || c == '/') {
                filteredBuilder.append("-");
            }
            ++n2;
        }
        name = filteredBuilder.toString();
        if (name.length() > 52) {
            name = name.substring(0, 52);
        }
        while (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        name = name.concat(".patch");
        return name;
    }

    public ISchedulingRule getSchedulingRule() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffHeaderFormat {
        NONE(CoreText.DiffHeaderFormat_None, false, null),
        EMAIL(CoreText.DiffHeaderFormat_Email, true, "From ${sha1} ${date}\nFrom: ${author}\nDate: ${author date}\nSubject: [PATCH] ${title line}\n${full commit message}\n"),
        ONELINE(CoreText.DiffHeaderFormat_Oneline, true, "${sha1} ${title line}\n");

        private final String description;
        private final boolean commitRequired;
        private final String template;

        private DiffHeaderFormat(String d, boolean c, String t) {
            this.description = d;
            this.commitRequired = c;
            this.template = t;
        }

        public boolean isCommitRequired() {
            return this.commitRequired;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getDescription() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DiffHeaderKeyword {
        SHA1,
        AUTHOR_DATE,
        AUTHOR,
        DATE,
        TITLE_LINE,
        FULL_COMMIT_MESSAGE;

    }
}

