/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.project.RepositoryChangeListener;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.WindowCache;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitProjectData {
    private static final Map<IProject, GitProjectData> projectDataCache = new HashMap<IProject, GitProjectData>();
    private static Set<RepositoryChangeListener> repositoryChangeListeners = new HashSet<RepositoryChangeListener>();
    private static final IResourceChangeListener rcl = new RCL();
    private static QualifiedName MAPPING_KEY = new QualifiedName(GitProjectData.class.getName(), "RepositoryMapping");
    private final IProject project;
    private final Collection<RepositoryMapping> mappings = new ArrayList<RepositoryMapping>();
    private final Set<IResource> protectedResources = new HashSet<IResource>();

    public static void attachToWorkspace(boolean includeChange) {
        GitProjectData.trace("attachToWorkspace - addResourceChangeListener");
        ResourcesPlugin.getWorkspace().addResourceChangeListener(rcl, (includeChange ? 1 : 0) | 2 | 4);
    }

    public static void detachFromWorkspace() {
        GitProjectData.trace("detachFromWorkspace - removeResourceChangeListener");
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(rcl);
    }

    public static synchronized void addRepositoryChangeListener(RepositoryChangeListener objectThatCares) {
        if (objectThatCares == null) {
            throw new NullPointerException();
        }
        repositoryChangeListeners.add(objectThatCares);
    }

    public static synchronized void removeRepositoryChangeListener(RepositoryChangeListener objectThatCares) {
        repositoryChangeListeners.remove(objectThatCares);
    }

    static void fireRepositoryChanged(final RepositoryMapping which) {
        Job job = new Job(CoreText.GitProjectData_repositoryChangedJobName){

            protected IStatus run(IProgressMonitor monitor) {
                RepositoryChangeListener[] listeners = GitProjectData.getRepositoryChangeListeners();
                monitor.beginTask(CoreText.GitProjectData_repositoryChangedTaskName, listeners.length);
                RepositoryChangeListener[] repositoryChangeListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    RepositoryChangeListener listener = repositoryChangeListenerArray[n2];
                    listener.repositoryChanged(which);
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.REPOSITORY_CHANGED.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.schedule();
    }

    private static synchronized RepositoryChangeListener[] getRepositoryChangeListeners() {
        return repositoryChangeListeners.toArray(new RepositoryChangeListener[repositoryChangeListeners.size()]);
    }

    public static synchronized GitProjectData get(IProject p) {
        try {
            GitProjectData d = GitProjectData.lookup(p);
            if (d == null && RepositoryProvider.getProvider((IProject)p) instanceof GitProvider) {
                d = new GitProjectData(p).load();
                GitProjectData.cache(p, d);
            }
            return d;
        }
        catch (IOException err) {
            Activator.logError(CoreText.GitProjectData_missing, err);
            return null;
        }
    }

    public static void delete(IProject p) throws IOException {
        GitProjectData.trace("delete(" + p.getName() + ")");
        GitProjectData d = GitProjectData.lookup(p);
        if (d == null) {
            GitProjectData.deletePropertyFiles(p);
        } else {
            d.deletePropertyFilesAndUncache();
        }
    }

    public static void add(IProject p, GitProjectData d) {
        GitProjectData.trace("add(" + p.getName() + ")");
        GitProjectData.cache(p, d);
    }

    static void trace(String m) {
        if (GitTraceLocation.CORE.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "(GitProjectData) " + m);
        }
    }

    private static synchronized void cache(IProject p, GitProjectData d) {
        projectDataCache.put(p, d);
    }

    private static synchronized void uncache(IProject p) {
        if (projectDataCache.remove(p) != null) {
            GitProjectData.trace("uncacheDataFor(" + p.getName() + ")");
        }
    }

    private static synchronized GitProjectData lookup(IProject p) {
        return projectDataCache.get(p);
    }

    public static void reconfigureWindowCache() {
        WindowCacheConfig c = new WindowCacheConfig();
        IEclipsePreferences d = new DefaultScope().getNode(Activator.getPluginId());
        IEclipsePreferences p = new InstanceScope().getNode(Activator.getPluginId());
        c.setPackedGitLimit((long)p.getInt("core_packedGitLimit", d.getInt("core_packedGitLimit", 0)));
        c.setPackedGitWindowSize(p.getInt("core_packedGitWindowSize", d.getInt("core_packedGitWindowSize", 0)));
        c.setPackedGitMMAP(p.getBoolean("core_packedGitMMAP", d.getBoolean("core_packedGitMMAP", false)));
        c.setDeltaBaseCacheLimit(p.getInt("core_deltaBaseCacheLimit", d.getInt("core_deltaBaseCacheLimit", 0)));
        WindowCache.reconfigure((WindowCacheConfig)c);
    }

    public GitProjectData(IProject p) {
        this.project = p;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setRepositoryMappings(Collection<RepositoryMapping> newMappings) {
        this.mappings.clear();
        this.mappings.addAll(newMappings);
        this.remapAll();
    }

    public void markTeamPrivateResources() throws CoreException {
        for (RepositoryMapping rmObj : this.mappings) {
            IResource dotGit;
            RepositoryMapping rm = rmObj;
            IContainer c = rm.getContainer();
            if (c == null || (dotGit = c.findMember(".git")) == null) continue;
            try {
                Repository r = rm.getRepository();
                File dotGitDir = dotGit.getLocation().toFile().getCanonicalFile();
                if (!dotGitDir.equals(r.getDirectory())) continue;
                GitProjectData.trace("teamPrivate " + dotGit);
                dotGit.setTeamPrivateMember(true);
            }
            catch (IOException err) {
                throw new CoreException(Activator.error(CoreText.Error_CanonicalFile, err));
            }
        }
    }

    public boolean isProtected(IResource f) {
        return this.protectedResources.contains(f);
    }

    public RepositoryMapping getRepositoryMapping(IResource resource) {
        IResource r = resource;
        try {
            while (r != null) {
                RepositoryMapping m;
                if (r.isAccessible() && (m = (RepositoryMapping)r.getSessionProperty(MAPPING_KEY)) != null) {
                    return m;
                }
                r = r.getParent();
            }
        }
        catch (CoreException err) {
            Activator.logError(CoreText.GitProjectData_failedFindingRepoMapping, err);
        }
        return null;
    }

    private void deletePropertyFilesAndUncache() throws IOException {
        GitProjectData.deletePropertyFiles(this.getProject());
        GitProjectData.uncache(this.getProject());
    }

    private static void deletePropertyFiles(IProject project) throws IOException {
        File dir = GitProjectData.propertyFile(project).getParentFile();
        FileUtils.delete((File)dir, (int)1);
        GitProjectData.trace("deleteDataFor(" + project.getName() + ")");
    }

    public void store() throws CoreException {
        File dat = this.propertyFile();
        boolean ok = false;
        try {
            GitProjectData.trace("save " + dat);
            File tmp = File.createTempFile("gpd_", ".prop", dat.getParentFile());
            FileOutputStream o = new FileOutputStream(tmp);
            try {
                Properties p = new Properties();
                for (RepositoryMapping repoMapping : this.mappings) {
                    repoMapping.store(p);
                }
                p.store(o, "GitProjectData");
                ok = true;
            }
            finally {
                o.close();
                if (!ok && tmp.exists()) {
                    FileUtils.delete((File)tmp);
                }
            }
            if (dat.exists()) {
                FileUtils.delete((File)dat);
            }
            if (!tmp.renameTo(dat)) {
                if (tmp.exists()) {
                    FileUtils.delete((File)tmp);
                }
                throw new CoreException(Activator.error(NLS.bind((String)CoreText.GitProjectData_saveFailed, (Object)dat), null));
            }
        }
        catch (IOException ioe) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.GitProjectData_saveFailed, (Object)dat), ioe));
        }
    }

    private File propertyFile() {
        return GitProjectData.propertyFile(this.getProject());
    }

    private static File propertyFile(IProject project) {
        return new File(project.getWorkingLocation(Activator.getPluginId()).toFile(), "GitProjectData.properties");
    }

    private GitProjectData load() throws IOException {
        File dat = this.propertyFile();
        GitProjectData.trace("load " + dat);
        FileInputStream o = new FileInputStream(dat);
        try {
            Properties p = new Properties();
            p.load(o);
            this.mappings.clear();
            for (Object keyObj : p.keySet()) {
                String key = keyObj.toString();
                if (!RepositoryMapping.isInitialKey(key)) continue;
                this.mappings.add(new RepositoryMapping(p, key));
            }
        }
        finally {
            o.close();
        }
        this.remapAll();
        return this;
    }

    private void remapAll() {
        this.protectedResources.clear();
        for (RepositoryMapping repoMapping : this.mappings) {
            this.map(repoMapping);
        }
    }

    private void map(RepositoryMapping m) {
        IContainer c = null;
        m.clear();
        IResource r = this.getProject().findMember(m.getContainerPath());
        if (r instanceof IContainer) {
            c = (IContainer)r;
        } else if (r != null) {
            c = (IContainer)r.getAdapter(IContainer.class);
        }
        if (c == null) {
            Activator.logError(CoreText.GitProjectData_mappedResourceGone, new FileNotFoundException(m.getContainerPath().toString()));
            m.clear();
            return;
        }
        m.setContainer(c);
        File git = c.getLocation().append(m.getGitDirPath()).toFile();
        if (!git.isDirectory() || !new File(git, "config").isFile()) {
            Activator.logError(CoreText.GitProjectData_mappedResourceGone, new FileNotFoundException(m.getContainerPath().toString()));
            m.clear();
            return;
        }
        try {
            m.setRepository(Activator.getDefault().getRepositoryCache().lookupRepository(git));
        }
        catch (IOException ioe) {
            Activator.logError(CoreText.GitProjectData_mappedResourceGone, new FileNotFoundException(m.getContainerPath().toString()));
            m.clear();
            return;
        }
        m.fireRepositoryChanged();
        GitProjectData.trace("map " + c + " -> " + m.getRepository());
        try {
            c.setSessionProperty(MAPPING_KEY, (Object)m);
        }
        catch (CoreException err) {
            Activator.logError(CoreText.GitProjectData_failedToCacheRepoMapping, err);
        }
        IResource dotGit = c.findMember(".git");
        if (dotGit != null && dotGit.getLocation().toFile().equals(git)) {
            this.protect(dotGit);
        }
    }

    private void protect(IResource resource) {
        IResource c = resource;
        while (c != null && !c.equals((Object)this.getProject())) {
            GitProjectData.trace("protect " + c);
            this.protectedResources.add(c);
            c = c.getParent();
        }
    }

    private static class RCL
    implements IResourceChangeListener {
        private RCL() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: {
                    GitProjectData.uncache((IProject)event.getResource());
                    break;
                }
                case 4: {
                    try {
                        GitProjectData.delete((IProject)event.getResource());
                    }
                    catch (IOException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                    break;
                }
            }
        }
    }
}

