/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.util.SystemReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryFinder {
    private final IProject proj;
    private final Collection<RepositoryMapping> results = new ArrayList<RepositoryMapping>();
    private final Set<File> gitdirs = new HashSet<File>();
    private Set<String> ceilingDirectories = new HashSet<String>();

    public RepositoryFinder(IProject p) {
        this.proj = p;
        String ceilingDirectoriesVar = SystemReader.getInstance().getenv("GIT_CEILING_DIRECTORIES");
        if (ceilingDirectoriesVar != null) {
            this.ceilingDirectories.addAll(Arrays.asList(ceilingDirectoriesVar.split(File.pathSeparator)));
        }
    }

    public Collection<RepositoryMapping> find(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        this.find((IProgressMonitor)monitor, (IContainer)this.proj);
        return this.results;
    }

    private void find(IProgressMonitor m, IContainer c) throws CoreException {
        IPath loc = c.getLocation();
        m.beginTask("", 101);
        m.subTask(CoreText.RepositoryFinder_finding);
        try {
            if (loc != null) {
                File fsLoc = loc.toFile();
                assert (fsLoc.isAbsolute());
                File ownCfg = this.configFor(fsLoc);
                if (ownCfg.isFile()) {
                    this.register(c, ownCfg.getParentFile());
                }
                if (c.isLinked() || c instanceof IProject) {
                    File p = fsLoc.getParentFile();
                    while (p != null) {
                        File pCfg;
                        if (GitTraceLocation.CORE.isActive()) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "Looking at candidate dir: " + p);
                        }
                        if ((pCfg = this.configFor(p)).isFile()) {
                            this.register(c, pCfg.getParentFile());
                        }
                        if (this.ceilingDirectories.contains(p.getPath())) break;
                        p = p.getParentFile();
                    }
                }
                m.worked(1);
                IResource[] children = c.members();
                if (children != null && children.length > 0) {
                    int scale = 100 / children.length;
                    int k = 0;
                    while (k < children.length) {
                        IResource o = children[k];
                        if (o instanceof IContainer && !o.getName().equals(".git")) {
                            this.find((IProgressMonitor)new SubProgressMonitor(m, scale), (IContainer)o);
                        } else {
                            m.worked(scale);
                        }
                        ++k;
                    }
                }
            }
        }
        finally {
            m.done();
        }
    }

    private File configFor(File fsLoc) {
        return new File(new File(fsLoc, ".git"), "config");
    }

    private void register(IContainer c, File gitdir) {
        File f;
        try {
            f = gitdir.getCanonicalFile();
        }
        catch (IOException ioe) {
            f = gitdir.getAbsoluteFile();
        }
        if (this.gitdirs.contains(f)) {
            return;
        }
        this.gitdirs.add(f);
        this.results.add(new RepositoryMapping(c, f));
    }
}

