/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.core.synchronize.GitCommitsModelDirectionException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitCommitsModelCache {
    public static final int ADDITION = 1;
    public static final int DELETION = 2;
    public static final int CHANGE = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    static final AbbreviatedObjectId ZERO_ID = AbbreviatedObjectId.fromObjectId((AnyObjectId)ObjectId.zeroId());

    public static List<Commit> build(Repository repo, ObjectId srcId, ObjectId dstId) throws IOException {
        if (dstId.equals((AnyObjectId)srcId)) {
            return new ArrayList<Commit>(0);
        }
        RevWalk rw = new RevWalk(repo);
        RevFlag localFlag = rw.newFlag("local");
        RevFlag remoteFlag = rw.newFlag("remote");
        RevFlagSet allFlags = new RevFlagSet();
        allFlags.add(localFlag);
        allFlags.add(remoteFlag);
        rw.carry((Collection)allFlags);
        RevCommit srcCommit = rw.parseCommit((AnyObjectId)srcId);
        srcCommit.add(localFlag);
        rw.markStart(srcCommit);
        srcCommit = null;
        RevCommit dstCommit = rw.parseCommit((AnyObjectId)dstId);
        dstCommit.add(remoteFlag);
        rw.markStart(dstCommit);
        dstCommit = null;
        ArrayList<Commit> result = new ArrayList<Commit>();
        for (RevCommit revCommit : rw) {
            if (revCommit.hasAll(allFlags)) break;
            Commit commit = new Commit();
            commit.shortMessage = revCommit.getShortMessage();
            commit.commitId = AbbreviatedObjectId.fromObjectId((AnyObjectId)revCommit);
            commit.authorName = revCommit.getAuthorIdent().getName();
            commit.committerName = revCommit.getCommitterIdent().getName();
            commit.commitDate = revCommit.getAuthorIdent().getWhen();
            if (revCommit.has(localFlag)) {
                commit.direction = 8;
            } else if (revCommit.has(remoteFlag)) {
                commit.direction = 4;
            } else {
                throw new GitCommitsModelDirectionException();
            }
            RevCommit[] parents = revCommit.getParents();
            if (parents.length == 1) {
                commit.children = GitCommitsModelCache.getChangedObjects(repo, revCommit, parents[0], commit.direction);
            }
            result.add(commit);
        }
        rw.dispose();
        return result;
    }

    private static Map<String, Change> getChangedObjects(Repository repo, RevCommit parentCommit, RevCommit remoteCommit, int direction) throws IOException {
        TreeWalk tw = new TreeWalk(repo);
        tw.addTree((AnyObjectId)parentCommit.getTree());
        tw.addTree((AnyObjectId)remoteCommit.getTree());
        tw.setFilter(TreeFilter.ANY_DIFF);
        tw.setRecursive(true);
        int localTreeId = direction == 4 ? 1 : 0;
        int remoteTreeId = direction == 4 ? 0 : 1;
        HashMap<String, Change> result = new HashMap<String, Change>();
        AbbreviatedObjectId actualCommit = AbbreviatedObjectId.fromObjectId((AnyObjectId)parentCommit);
        AbbreviatedObjectId remoteCommitAbb = AbbreviatedObjectId.fromObjectId((AnyObjectId)remoteCommit);
        MutableObjectId idBuf = new MutableObjectId();
        while (tw.next()) {
            Change change = new Change();
            change.commitId = actualCommit;
            change.remoteCommitId = remoteCommitAbb;
            change.name = tw.getNameString();
            tw.getObjectId(idBuf, localTreeId);
            change.objectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
            tw.getObjectId(idBuf, remoteTreeId);
            change.remoteObjectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
            GitCommitsModelCache.calculateAndSetChangeKind(direction, change);
            result.put(tw.getPathString(), change);
        }
        tw.release();
        return result.size() > 0 ? result : null;
    }

    static void calculateAndSetChangeKind(int direction, Change change) {
        if (ZERO_ID.equals((Object)change.objectId)) {
            change.objectId = null;
            change.kind = direction | 2;
        } else if (ZERO_ID.equals((Object)change.remoteObjectId)) {
            change.remoteObjectId = null;
            change.kind = direction | 1;
        } else {
            change.kind = direction | 3;
        }
    }

    public static class Change {
        int kind;
        String name;
        AbbreviatedObjectId objectId;
        AbbreviatedObjectId commitId;
        AbbreviatedObjectId remoteCommitId;
        AbbreviatedObjectId remoteObjectId;

        Change() {
        }

        public int getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public AbbreviatedObjectId getCommitId() {
            return this.commitId;
        }

        public AbbreviatedObjectId getRemoteCommitId() {
            return this.remoteCommitId;
        }

        public AbbreviatedObjectId getObjectId() {
            return this.objectId;
        }

        public AbbreviatedObjectId getRemoteObjectId() {
            return this.remoteObjectId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.objectId == null ? 0 : this.objectId.hashCode());
            result = 31 * result + (this.remoteObjectId == null ? 0 : this.remoteObjectId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Change other = (Change)obj;
            if (this.objectId == null ? other.objectId != null : !this.objectId.equals((Object)other.objectId)) {
                return false;
            }
            return !(this.remoteObjectId == null ? other.remoteObjectId != null : !this.remoteObjectId.equals((Object)other.remoteObjectId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Commit {
        private int direction;
        private String shortMessage;
        private AbbreviatedObjectId commitId;
        private Date commitDate;
        private String authorName;
        private String committerName;
        private Map<String, Change> children;

        private Commit() {
        }

        public int getDirection() {
            return this.direction;
        }

        public AbbreviatedObjectId getId() {
            return this.commitId;
        }

        public String getAuthorName() {
            return this.authorName;
        }

        public String getCommitterName() {
            return this.committerName;
        }

        public Date getCommitDate() {
            return this.commitDate;
        }

        public String getShortMessage() {
            return this.shortMessage;
        }

        public Map<String, Change> getChildren() {
            return this.children;
        }
    }
}

