/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.GitSyncObjectCache;
import org.eclipse.egit.core.synchronize.ThreeWayDiffEntry;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GitSyncCache {
    private final Map<File, GitSyncObjectCache> cache = new HashMap<File, GitSyncObjectCache>();

    public static GitSyncCache getAllData(GitSynchronizeDataSet gsds, IProgressMonitor monitor) {
        HashMap<GitSynchronizeData, Collection<String>> updateRequests = new HashMap<GitSynchronizeData, Collection<String>>();
        for (GitSynchronizeData data : gsds) {
            updateRequests.put(data, Collections.emptyList());
        }
        return GitSyncCache.getAllData(updateRequests, monitor);
    }

    public static GitSyncCache getAllData(Map<GitSynchronizeData, Collection<String>> updateRequests, IProgressMonitor monitor) {
        GitSyncCache cache = new GitSyncCache();
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)updateRequests.size());
        for (Map.Entry<GitSynchronizeData, Collection<String>> entry : updateRequests.entrySet()) {
            cache.merge(GitSyncCache.getAllData(entry.getKey(), entry.getValue()));
            m.worked(1);
        }
        m.done();
        return cache;
    }

    private static GitSyncCache getAllData(GitSynchronizeData gsd, Collection<String> paths) {
        GitSyncCache cache = new GitSyncCache();
        TreeFilter filter = paths.isEmpty() ? null : GitSyncCache.createPathFilter(paths);
        Repository repo = gsd.getRepository();
        ObjectId baseTree = GitSyncCache.getTree(gsd.getSrcRevCommit());
        ObjectId remoteTree = GitSyncCache.getTree(gsd.getDstRevCommit());
        GitSyncObjectCache repoCache = cache.put(repo, baseTree, remoteTree);
        TreeFilter gsdFilter = gsd.getPathFilter();
        if (filter == null) {
            GitSyncCache.loadDataFromGit(gsd, gsdFilter, repoCache);
        } else if (gsdFilter == null) {
            GitSyncCache.loadDataFromGit(gsd, filter, repoCache);
        } else {
            GitSyncCache.loadDataFromGit(gsd, AndTreeFilter.create((TreeFilter)filter, (TreeFilter)gsdFilter), repoCache);
        }
        return cache;
    }

    private static TreeFilter createPathFilter(Collection<String> paths) {
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>(paths.size());
        for (String path : paths) {
            if (path.length() == 0) {
                return null;
            }
            filters.add(PathFilter.create((String)path));
        }
        if (filters.size() == 1) {
            return (TreeFilter)filters.get(0);
        }
        return OrTreeFilter.create(filters);
    }

    private static void loadDataFromGit(GitSynchronizeData gsd, TreeFilter filter, GitSyncObjectCache repoCache) {
        Repository repo = gsd.getRepository();
        TreeWalk tw = new TreeWalk(repo);
        if (filter != null) {
            tw.setFilter(filter);
        }
        try {
            if (gsd.shouldIncludeLocal()) {
                tw.addTree((AbstractTreeIterator)new FileTreeIterator(repo));
                if (filter != null) {
                    tw.setFilter(AndTreeFilter.create((TreeFilter)filter, (TreeFilter)new NotIgnoredFilter(0)));
                } else {
                    tw.setFilter((TreeFilter)new NotIgnoredFilter(0));
                }
            } else if (gsd.getSrcRevCommit() != null) {
                tw.addTree((AnyObjectId)gsd.getSrcRevCommit().getTree());
            } else {
                tw.addTree((AbstractTreeIterator)new EmptyTreeIterator());
            }
            if (gsd.getCommonAncestorRev() != null) {
                tw.addTree((AnyObjectId)gsd.getCommonAncestorRev().getTree());
            } else {
                tw.addTree((AbstractTreeIterator)new EmptyTreeIterator());
            }
            if (gsd.getDstRevCommit() != null) {
                tw.addTree((AnyObjectId)gsd.getDstRevCommit().getTree());
            } else {
                tw.addTree((AbstractTreeIterator)new EmptyTreeIterator());
            }
            List<ThreeWayDiffEntry> diffEntrys = ThreeWayDiffEntry.scan(tw);
            tw.release();
            for (ThreeWayDiffEntry diffEntry : diffEntrys) {
                repoCache.addMember(diffEntry);
            }
        }
        catch (Exception e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    private static ObjectId getTree(RevCommit commit) {
        if (commit != null) {
            return commit.getTree();
        }
        return ObjectId.zeroId();
    }

    private GitSyncCache() {
    }

    public GitSyncObjectCache get(Repository repo) {
        return this.cache.get(repo.getDirectory());
    }

    public void merge(GitSyncCache newCache) {
        for (Map.Entry<File, GitSyncObjectCache> entry : newCache.cache.entrySet()) {
            File key = entry.getKey();
            if (this.cache.containsKey(key)) {
                this.cache.get(key).merge(entry.getValue());
                continue;
            }
            this.cache.put(key, entry.getValue());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<File, GitSyncObjectCache> entry : this.cache.entrySet()) {
            builder.append(entry.getKey().getPath()).append(": ").append(entry.getValue());
        }
        return builder.toString();
    }

    private GitSyncObjectCache put(Repository repo, ObjectId baseTree, ObjectId remoteTree) {
        ThreeWayDiffEntry entry = new ThreeWayDiffEntry();
        entry.baseId = AbbreviatedObjectId.fromObjectId((AnyObjectId)baseTree);
        entry.remoteId = AbbreviatedObjectId.fromObjectId((AnyObjectId)remoteTree);
        GitSyncObjectCache objectCache = new GitSyncObjectCache("", entry);
        this.cache.put(repo.getDirectory(), objectCache);
        return objectCache;
    }
}

