/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.MessageWriter;
import org.eclipse.jgit.util.io.StreamCopyThread;

public class TransportGitSsh
extends SshTransport
implements PackTransport {
    static final TransportProtocol PROTO_SSH = new TransportProtocol(){
        private final String[] schemeNames = new String[]{"ssh", "ssh+git", "git+ssh"};
        private final Set<String> schemeSet = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(this.schemeNames)));

        @Override
        public String getName() {
            return JGitText.get().transportProtoSSH;
        }

        @Override
        public Set<String> getSchemes() {
            return this.schemeSet;
        }

        @Override
        public Set<TransportProtocol.URIishField> getRequiredFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH));
        }

        @Override
        public Set<TransportProtocol.URIishField> getOptionalFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.USER, TransportProtocol.URIishField.PASS, TransportProtocol.URIishField.PORT));
        }

        @Override
        public int getDefaultPort() {
            return 22;
        }

        @Override
        public boolean canHandle(URIish uri, Repository local, String remoteName) {
            if (uri.getScheme() == null) {
                return uri.getHost() != null && uri.getPath() != null && uri.getHost().length() != 0 && uri.getPath().length() != 0;
            }
            return super.canHandle(uri, local, remoteName);
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NotSupportedException {
            return new TransportGitSsh(local, uri);
        }
    };

    TransportGitSsh(Repository local, URIish uri) {
        super(local, uri);
        if (TransportGitSsh.useExtSession()) {
            this.setSshSessionFactory(new SshSessionFactory(){

                public RemoteSession getSession(URIish uri2, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
                    return new ExtSession();
                }
            });
        }
    }

    public FetchConnection openFetch() throws TransportException {
        return new SshFetchConnection();
    }

    public PushConnection openPush() throws TransportException {
        return new SshPushConnection();
    }

    String commandFor(String exe) {
        String path = this.uri.getPath();
        if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
            path = this.uri.getPath().substring(1);
        }
        StringBuilder cmd = new StringBuilder();
        cmd.append(exe);
        cmd.append(' ');
        cmd.append(QuotedString.BOURNE.quote(path));
        return cmd.toString();
    }

    void checkExecFailure(int status, String exe, String why) throws TransportException {
        if (status == 127) {
            IOException cause = null;
            if (why != null && why.length() > 0) {
                cause = new IOException(why);
            }
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotExecute, this.commandFor(exe)), cause);
        }
    }

    NoRemoteRepositoryException cleanNotFound(NoRemoteRepositoryException nf, String why) {
        if (why == null || why.length() == 0) {
            return nf;
        }
        String path = this.uri.getPath();
        if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
            path = this.uri.getPath().substring(1);
        }
        StringBuilder pfx = new StringBuilder();
        pfx.append("fatal: ");
        pfx.append(QuotedString.BOURNE.quote(path));
        pfx.append(": ");
        if (why.startsWith(pfx.toString())) {
            why = why.substring(pfx.length());
        }
        return new NoRemoteRepositoryException(this.uri, why);
    }

    private static boolean useExtSession() {
        return SystemReader.getInstance().getenv("GIT_SSH") != null;
    }

    private class ExtSession
    implements RemoteSession {
        private ExtSession() {
        }

        public Process exec(String command, int timeout) throws TransportException {
            String ssh = SystemReader.getInstance().getenv("GIT_SSH");
            boolean putty = ssh.toLowerCase().contains("plink");
            ArrayList<String> args = new ArrayList<String>();
            args.add(ssh);
            if (putty && !ssh.toLowerCase().contains("tortoiseplink")) {
                args.add("-batch");
            }
            if (0 < TransportGitSsh.this.getURI().getPort()) {
                args.add(putty ? "-P" : "-p");
                args.add(String.valueOf(TransportGitSsh.this.getURI().getPort()));
            }
            if (TransportGitSsh.this.getURI().getUser() != null) {
                args.add(TransportGitSsh.this.getURI().getUser() + "@" + TransportGitSsh.this.getURI().getHost());
            } else {
                args.add(TransportGitSsh.this.getURI().getHost());
            }
            args.add(command);
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(args);
            if (TransportGitSsh.this.local.getDirectory() != null) {
                pb.environment().put("GIT_DIR", TransportGitSsh.this.local.getDirectory().getPath());
            }
            try {
                return pb.start();
            }
            catch (IOException err) {
                throw new TransportException(err.getMessage(), err);
            }
        }

        public void disconnect() {
        }
    }

    class SshFetchConnection
    extends BasePackFetchConnection {
        private final Process process;
        private StreamCopyThread errorThread;

        SshFetchConnection() throws TransportException {
            super(TransportGitSsh.this);
            try {
                this.process = TransportGitSsh.this.getSession().exec(TransportGitSsh.this.commandFor(TransportGitSsh.this.getOptionUploadPack()), TransportGitSsh.this.getTimeout());
                MessageWriter msg = new MessageWriter();
                this.setMessageWriter(msg);
                InputStream upErr = this.process.getErrorStream();
                this.errorThread = new StreamCopyThread(upErr, msg.getRawStream());
                this.errorThread.start();
                this.init(this.process.getInputStream(), this.process.getOutputStream());
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, err);
            }
            try {
                this.readAdvertisedRefs();
            }
            catch (NoRemoteRepositoryException notFound) {
                String msgs = this.getMessages();
                TransportGitSsh.this.checkExecFailure(this.process.exitValue(), TransportGitSsh.this.getOptionUploadPack(), msgs);
                throw TransportGitSsh.this.cleanNotFound(notFound, msgs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.endOut();
            if (this.errorThread != null) {
                try {
                    try {
                        this.errorThread.halt();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        this.errorThread = null;
                    }
                    Object var3_1 = null;
                    this.errorThread = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.errorThread = null;
                    throw throwable;
                }
            }
            super.close();
            if (this.process != null) {
                this.process.destroy();
            }
        }
    }

    class SshPushConnection
    extends BasePackPushConnection {
        private final Process process;
        private StreamCopyThread errorThread;

        SshPushConnection() throws TransportException {
            super(TransportGitSsh.this);
            try {
                this.process = TransportGitSsh.this.getSession().exec(TransportGitSsh.this.commandFor(TransportGitSsh.this.getOptionReceivePack()), TransportGitSsh.this.getTimeout());
                MessageWriter msg = new MessageWriter();
                this.setMessageWriter(msg);
                InputStream rpErr = this.process.getErrorStream();
                this.errorThread = new StreamCopyThread(rpErr, msg.getRawStream());
                this.errorThread.start();
                this.init(this.process.getInputStream(), this.process.getOutputStream());
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, err);
            }
            try {
                this.readAdvertisedRefs();
            }
            catch (NoRemoteRepositoryException notFound) {
                String msgs = this.getMessages();
                TransportGitSsh.this.checkExecFailure(this.process.exitValue(), TransportGitSsh.this.getOptionReceivePack(), msgs);
                throw TransportGitSsh.this.cleanNotFound(notFound, msgs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.endOut();
            if (this.errorThread != null) {
                try {
                    try {
                        this.errorThread.halt();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        this.errorThread = null;
                    }
                    Object var3_1 = null;
                    this.errorThread = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.errorThread = null;
                    throw throwable;
                }
            }
            super.close();
            if (this.process != null) {
                this.process.destroy();
            }
        }
    }
}

