/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.ISessionListener;
import com.mountainminds.eclemma.core.ISessionManager;
import com.mountainminds.eclemma.core.analysis.IJavaCoverageListener;
import com.mountainminds.eclemma.core.analysis.IJavaModelCoverage;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.analysis.SessionAnalyzer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class JavaCoverageLoader {
    private final ISessionManager sessionManager;
    private ICoverageSession activeSession;
    private IJavaModelCoverage coverage;
    private final List listeners = new ArrayList();
    private ISessionListener sessionListener = new ISessionListener(){

        public void sessionActivated(ICoverageSession session) {
            JavaCoverageLoader.this.activeSession = session;
            Platform.getJobManager().cancel(LOADJOB);
            if (session == null) {
                JavaCoverageLoader.this.coverage = null;
                JavaCoverageLoader.this.fireCoverageChanged();
            } else {
                JavaCoverageLoader.this.coverage = IJavaModelCoverage.LOADING;
                JavaCoverageLoader.this.fireCoverageChanged();
                new LoadSessionJob(JavaCoverageLoader.this.activeSession).schedule();
            }
        }

        public void sessionAdded(ICoverageSession addedSession) {
        }

        public void sessionRemoved(ICoverageSession removedSession) {
        }
    };
    private static final Object LOADJOB = new Object();

    public JavaCoverageLoader(ISessionManager sessionManager) {
        this.sessionManager = sessionManager;
        sessionManager.addSessionListener(this.sessionListener);
    }

    public void addJavaCoverageListener(IJavaCoverageListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeJavaCoverageListener(IJavaCoverageListener l) {
        this.listeners.remove(l);
    }

    protected void fireCoverageChanged() {
        Iterator i = new ArrayList(this.listeners).iterator();
        while (i.hasNext()) {
            ((IJavaCoverageListener)i.next()).coverageChanged();
        }
    }

    public IJavaModelCoverage getJavaModelCoverage() {
        return this.coverage;
    }

    public void dispose() {
        this.sessionManager.removeSessionListener(this.sessionListener);
    }

    private class LoadSessionJob
    extends Job {
        private final ICoverageSession session;

        public LoadSessionJob(ICoverageSession session) {
            super(NLS.bind((String)CoreMessages.AnalyzingCoverageSession_task, (Object)session.getDescription()));
            this.session = session;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IJavaModelCoverage c;
            try {
                c = new SessionAnalyzer().processSession(this.session, monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            JavaCoverageLoader.this.coverage = monitor.isCanceled() ? null : c;
            JavaCoverageLoader.this.fireCoverageChanged();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == LOADJOB;
        }
    }
}

