/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.ISessionListener;
import com.mountainminds.eclemma.core.ISessionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SessionManager
implements ISessionManager {
    private List sessions = new ArrayList();
    private Map keymap = new HashMap();
    private ICoverageSession activeSession = null;
    private List listeners = new ArrayList();

    public void addSession(ICoverageSession session, boolean activate, Object key) {
        if (session == null) {
            throw new NullPointerException();
        }
        if (!this.sessions.contains(session)) {
            this.sessions.add(session);
            if (key != null) {
                this.keymap.put(key, session);
            }
            this.fireSessionAdded(session);
            if (activate) {
                this.activeSession = session;
                this.fireSessionActivated(session);
            }
        }
    }

    public void removeSession(ICoverageSession session) {
        if (this.sessions.contains(session)) {
            boolean sessionActivated = false;
            if (session.equals(this.activeSession)) {
                this.activeSession = null;
                int i = this.sessions.size();
                while (--i >= 0) {
                    if (session.equals(this.sessions.get(i))) continue;
                    this.activeSession = (ICoverageSession)this.sessions.get(i);
                    break;
                }
                sessionActivated = true;
            }
            this.sessions.remove(session);
            this.keymap.values().remove(session);
            this.fireSessionRemoved(session);
            if (sessionActivated) {
                this.fireSessionActivated(this.activeSession);
            }
        }
    }

    public void removeSession(Object key) {
        this.removeSession(this.getSession(key));
    }

    public void removeAllSessions() {
        while (!this.sessions.isEmpty()) {
            ICoverageSession session = (ICoverageSession)this.sessions.remove(0);
            this.keymap.values().remove(session);
            this.fireSessionRemoved(session);
        }
        if (this.activeSession != null) {
            this.activeSession = null;
            this.fireSessionActivated(null);
        }
    }

    public ICoverageSession[] getSessions() {
        return this.sessions.toArray(new ICoverageSession[this.sessions.size()]);
    }

    public ICoverageSession getSession(Object key) {
        return (ICoverageSession)this.keymap.get(key);
    }

    public void activateSession(ICoverageSession session) {
        if (this.sessions.contains(session) && !session.equals(this.activeSession)) {
            this.activeSession = session;
            this.fireSessionActivated(session);
        }
    }

    public void activateSession(Object key) {
        this.activateSession(this.getSession(key));
    }

    public ICoverageSession getActiveSession() {
        return this.activeSession;
    }

    public void refreshActiveSession() {
        if (this.activeSession != null) {
            this.fireSessionActivated(this.activeSession);
        }
    }

    public void addSessionListener(ISessionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSessionListener(ISessionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSessionAdded(ICoverageSession session) {
        Iterator i = new ArrayList(this.listeners).iterator();
        while (i.hasNext()) {
            ((ISessionListener)i.next()).sessionAdded(session);
        }
    }

    protected void fireSessionRemoved(ICoverageSession session) {
        Iterator i = new ArrayList(this.listeners).iterator();
        while (i.hasNext()) {
            ((ISessionListener)i.next()).sessionRemoved(session);
        }
    }

    private void fireSessionActivated(ICoverageSession session) {
        Iterator i = new ArrayList(this.listeners).iterator();
        while (i.hasNext()) {
            ((ISessionListener)i.next()).sessionActivated(session);
        }
    }
}

