/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.core.analysis.ICounter;

public abstract class Counter
implements ICounter {
    private static final int SINGLETON_LIMIT = 10;
    private static final Counter[][] SINGLETONS = new Counter[11][];
    public static final Counter COUNTER_0_0;
    protected long total;
    protected long covered;

    static {
        int i = 0;
        while (i <= 10) {
            Counter.SINGLETONS[i] = new Counter[i + 1];
            int j = 0;
            while (j <= i) {
                Counter.SINGLETONS[i][j] = new Fix(i, j);
                ++j;
            }
            ++i;
        }
        COUNTER_0_0 = SINGLETONS[0][0];
    }

    public static Counter getInstance(long total, long covered) {
        if (total <= 10L && covered <= total) {
            return SINGLETONS[(int)total][(int)covered];
        }
        return new Var(total, covered);
    }

    protected Counter(long total, long covered) {
        this.total = total;
        this.covered = covered;
    }

    public abstract Counter increment(int var1, int var2);

    public long getTotalCount() {
        return this.total;
    }

    public long getCoveredCount() {
        return this.covered;
    }

    public double getRatio() {
        return (double)this.covered / (double)this.total;
    }

    public int compareTo(Object obj) {
        ICounter counter = (ICounter)obj;
        return Double.compare(this.getRatio(), counter.getRatio());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ICounter) {
            ICounter counter = (ICounter)obj;
            return this.getTotalCount() == counter.getTotalCount() && this.getCoveredCount() == counter.getCoveredCount();
        }
        return false;
    }

    public int hashCode() {
        long t = this.getTotalCount();
        long c = 17L * this.getCoveredCount();
        return (int)(t ^ t >>> 32 ^ c ^ c >>> 32);
    }

    public String toString() {
        StringBuffer b = new StringBuffer("Counter[");
        b.append(this.getCoveredCount());
        b.append('/').append(this.getTotalCount());
        b.append(']');
        return b.toString();
    }

    private static class Fix
    extends Counter {
        public Fix(long total, long covered) {
            super(total, covered);
        }

        public Counter increment(int total, int covered) {
            return Fix.getInstance(this.total + (long)total, this.covered + (long)covered);
        }
    }

    private static class Var
    extends Counter {
        public Var(long total, long covered) {
            super(total, covered);
        }

        public Counter increment(int total, int covered) {
            this.total += (long)total;
            this.covered += (long)covered;
            return this;
        }
    }
}

