/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public final class SignatureResolver {
    private static final String EMPTY = "";
    private static final String OBJECT = "Ljava/lang/Object;";
    private static final char SLASH = '/';

    public static String getParameters(String signature) {
        int pos = signature.lastIndexOf(41);
        return pos == 1 ? EMPTY : signature.substring(1, pos);
    }

    public static String getParameters(IMethod method) throws JavaModelException {
        if (method.isBinary()) {
            return SignatureResolver.getParameters(method.getSignature());
        }
        StringBuffer buffer = new StringBuffer();
        String[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            SignatureResolver.resolveArrayParameterType(method, parameterTypes[i], buffer);
            ++i;
        }
        return buffer.toString();
    }

    private static final void resolveArrayParameterType(IMethod method, String parameterType, StringBuffer result) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)parameterType);
        int i = 0;
        while (i < arrayCount) {
            result.append('[');
            ++i;
        }
        SignatureResolver.resolveParameterType(method, parameterType.substring(arrayCount), result);
    }

    private static final void resolveParameterType(IMethod method, String parameterType, StringBuffer result) throws JavaModelException {
        char kind = parameterType.charAt(0);
        switch (kind) {
            case 'Q': {
                String identifier = parameterType.substring(1, parameterType.length() - 1);
                if (SignatureResolver.resolveType(method.getDeclaringType(), identifier, result)) {
                    return;
                }
                if (!SignatureResolver.resolveTypeParameter(method, identifier, result)) break;
                return;
            }
        }
        result.append(parameterType);
    }

    private static final boolean resolveType(IType scope, String identifier, StringBuffer result) throws JavaModelException {
        String[][] types = scope.resolveType(Signature.getTypeErasure((String)identifier));
        if (types == null || types.length != 1) {
            return false;
        }
        result.append('L');
        String qualifier = types[0][0];
        if (qualifier.length() > 0) {
            SignatureResolver.replace(qualifier, '.', '/', result);
            result.append('/');
        }
        SignatureResolver.replace(types[0][1], '.', '$', result);
        result.append(';');
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean resolveTypeParameter(IMethod method, String identifier, StringBuffer result) throws JavaModelException {
        type = method.getDeclaringType();
        if (!SignatureResolver.resolveTypeParameter(type, method.getTypeParameters(), identifier, result)) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            if (SignatureResolver.resolveTypeParameter(type, type.getTypeParameters(), identifier, result)) {
                return true;
            }
            type = type.getDeclaringType();
lbl7:
            // 2 sources

            ** while (type != null)
        }
lbl8:
        // 1 sources

        return false;
    }

    private static final boolean resolveTypeParameter(IType context, ITypeParameter[] typeParameters, String identifier, StringBuffer result) throws JavaModelException {
        int i = 0;
        while (i < typeParameters.length) {
            ITypeParameter p = typeParameters[i];
            if (identifier.equals(p.getElementName())) {
                String[] bounds = p.getBounds();
                if (bounds.length == 0) {
                    result.append(OBJECT);
                    return true;
                }
                return SignatureResolver.resolveType(context, bounds[0], result);
            }
            ++i;
        }
        return false;
    }

    private static final void replace(String source, char oldChar, char newChar, StringBuffer result) {
        int len = source.length();
        int i = 0;
        while (i < len) {
            char c = source.charAt(i);
            result.append(c == oldChar ? newChar : c);
            ++i;
        }
    }
}

