/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.materializer.AbstractMaterializer;
import org.eclipse.buckminster.core.materializer.FileFolderMismatchException;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemMaterializer
extends AbstractMaterializer {
    @Override
    public String getMaterializerRootDir() {
        return "downloads";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Materialization> materialize(List<Resolution> resolutions, MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        adjustedMinfos = new ArrayList<Materialization>(resolutions.size());
        resolutionPerID = new HashMap<ComponentIdentifier, Resolution>();
        logger = CorePlugin.getLogger();
        sm = StorageManager.getDefault();
        updateCandidates = new HashSet<ComponentIdentifier>();
        statistics = context.getMaterializationStatistics();
        monitor.beginTask(null, 1000);
        try {
            perReader = new TreeMap<String, ArrayList<Materialization>>();
            mspec = context.getMaterializationSpec();
            filesRoot = mspec.getInstallLocation();
            workspaceRoot = mspec.getWorkspaceLocation();
            if (workspaceRoot == null) {
                workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            }
            userTemp = Path.fromOSString((String)System.getProperty("java.io.tmpdir"));
            userHome = Path.fromOSString((String)System.getProperty("user.home"));
            prepMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100);
            prepMon.beginTask(null, resolutions.size() * 10);
            for (Resolution cr : resolutions) {
                ci = null;
                try {
                    cr.store(sm);
                    ci = cr.getComponentIdentifier();
                    conflictRes = mspec.getConflictResolution(cr);
                    artifactLocation = this.getArtifactLocation(context, cr);
                    var23_24 = syncLock = artifactLocation.toOSString().intern();
                    synchronized (var23_24) {
                        mat = WorkspaceInfo.getMaterialization(cr);
                        if (mat != null) {
                            if (mat.getComponentLocation().equals((Object)artifactLocation) && conflictRes == ConflictResolution.KEEP) {
                                statistics.addKept(ci);
                                adjustedMinfos.add(mat);
                                continue;
                            }
                            mat.remove(sm);
                        }
                        mat = new Materialization(artifactLocation, ci);
                        resolutionPerID.put(ci, cr);
                        file = artifactLocation.toFile().getAbsoluteFile();
                        fileExists = file.exists();
                        if (fileExists && conflictRes == ConflictResolution.KEEP) {
                            v0 = artifactLocation.hasTrailingSeparator() != false ? file.isDirectory() : (pathTypeOK = file.isDirectory() == false);
                            if (!pathTypeOK) {
                                throw new FileFolderMismatchException(ci, artifactLocation);
                            }
                            statistics.addKept(ci);
                            logger.info(NLS.bind((String)Messages.Skipping_materialization_of_0_Instead_reusing_1, (Object)ci, (Object)artifactLocation), new Object[0]);
                            mat.store(sm);
                            adjustedMinfos.add(mat);
                            MonitorUtils.worked((IProgressMonitor)prepMon, (int)10);
                            continue;
                        }
                        if (artifactLocation.hasTrailingSeparator()) {
                            node = mspec.getMatchingNode(cr);
                            if (node != null && node.isUnpack() && node.getLeafArtifact() == null) {
                                conflictRes = ConflictResolution.UPDATE;
                            }
                            if (conflictRes.equals((Object)ConflictResolution.REPLACE)) {
                                alCount = artifactLocation.segmentCount();
                                if (!(userHome.isPrefixOf(artifactLocation) && userHome.segmentCount() < alCount || userTemp.isPrefixOf(artifactLocation) && userTemp.segmentCount() < alCount || workspaceRoot.isPrefixOf(artifactLocation) && workspaceRoot.segmentCount() < alCount || filesRoot != null && filesRoot.isPrefixOf(artifactLocation) && filesRoot.segmentCount() < alCount)) {
                                    conflictRes = ConflictResolution.UPDATE;
                                }
                            }
                            FileUtils.prepareDestination(file, conflictRes, MonitorUtils.subMonitor((IProgressMonitor)prepMon, (int)10));
                            if (file.list().length == 0) {
                                mtFile = new File(file, ".mtlock");
                                try {
                                    mtFile.createNewFile();
                                }
                                catch (IOException e) {
                                    throw BuckminsterException.wrap((Throwable)e);
                                }
                            }
                        } else if (fileExists) {
                            if (conflictRes == ConflictResolution.FAIL) {
                                throw new FileUtils.DestinationNotEmptyException(file);
                            }
                            if (!file.delete() && file.exists()) {
                                throw new FileUtils.DeleteException(file);
                            }
                        }
                        if (fileExists && conflictRes == ConflictResolution.UPDATE) {
                            updateCandidates.add(ci);
                        }
                        if ((readerGroup = (ArrayList<Materialization>)perReader.get((readerType = this.getMaterializationReaderType(cr)).getId())) == null) {
                            readerGroup = new ArrayList<Materialization>();
                            perReader.put(readerType.getId(), readerGroup);
                        }
                        readerGroup.add(mat);
                    }
                }
                catch (CoreException e) {
                    if (ci != null) {
                        statistics.addFailed(ci);
                    }
                    if (!context.isContinueOnError()) {
                        throw e;
                    }
                    context.addRequestStatus(cr.getRequest(), e.getStatus());
                }
            }
            prepMon.done();
            plugin = CorePlugin.getDefault();
            matMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900);
            matMon.beginTask(null, perReader.keySet().size() * 2 + perReader.entrySet().size() * 100);
            for (Map.Entry<K, V> entry : perReader.entrySet()) {
                rg = (List)entry.getValue();
                readerType = plugin.getReaderType((String)entry.getKey());
                matMon.subTask(NLS.bind((String)Messages.Preparing_type_0, (Object)readerType.getId()));
                readerType.prepareMaterialization(rg, context, MonitorUtils.subMonitor((IProgressMonitor)matMon, (int)8));
                for (Materialization mi : rg) {
                    ci = mi.getComponentIdentifier();
                    cr = (Resolution)resolutionPerID.get(ci);
                    matMon.subTask(ci.getName());
                    success = false;
                    reader = readerType.getReader(cr, context, MonitorUtils.subMonitor((IProgressMonitor)matMon, (int)20));
                    try {
                        try {
                            location = mi.getComponentLocation();
                            matSubMon = MonitorUtils.subMonitor((IProgressMonitor)matMon, (int)80);
                            if (!location.hasTrailingSeparator() && location.toFile().isDirectory()) {
                                mi = new Materialization(location.addTrailingSeparator(), ci);
                            }
                            mi.store(sm);
                            reader.materialize(location, cr, context, matSubMon);
                            adjustedMinfos.add(mi);
                            success = true;
                        }
                        catch (CoreException e) {
                            if (!context.isContinueOnError()) {
                                throw e;
                            }
                            context.addRequestStatus(cr.getRequest(), e.getStatus());
                            IOUtils.close((Closeable)reader);
                            location = mi.getComponentLocation();
                            if (location.hasTrailingSeparator()) {
                                location.append(".mtlock").toFile().delete();
                            }
                            if (success) {
                                if (updateCandidates.contains(ci)) {
                                    statistics.addUpdated(ci);
                                    continue;
                                }
                                statistics.addReplaced(ci);
                                continue;
                            }
                            statistics.addFailed(ci);
                            mi.remove(sm);
                            continue;
                        }
                    }
                    catch (Throwable var31_40) {
                        IOUtils.close((Closeable)reader);
                        location = mi.getComponentLocation();
                        if (location.hasTrailingSeparator()) {
                            location.append(".mtlock").toFile().delete();
                        }
                        if (!success) {
                            statistics.addFailed(ci);
                            mi.remove(sm);
                            throw var31_40;
                        }
                        if (updateCandidates.contains(ci)) {
                            statistics.addUpdated(ci);
                            throw var31_40;
                        }
                        statistics.addReplaced(ci);
                        throw var31_40;
                    }
                    IOUtils.close((Closeable)reader);
                    location = mi.getComponentLocation();
                    if (location.hasTrailingSeparator()) {
                        location.append(".mtlock").toFile().delete();
                    }
                    if (success) {
                        if (updateCandidates.contains(ci)) {
                            statistics.addUpdated(ci);
                            continue;
                        }
                        statistics.addReplaced(ci);
                        continue;
                    }
                    statistics.addFailed(ci);
                    mi.remove(sm);
                }
            }
            matMon.done();
            var34_41 = adjustedMinfos;
            return var34_41;
        }
        finally {
            ** for (res : resolutions)
        }
lbl-1000:
        // 1 sources

        {
            ci = res.getComponentIdentifier();
            if (statistics.isIncluded(ci)) continue;
            statistics.addFailed(ci);
            continue;
        }
lbl180:
        // 1 sources

        monitor.done();
        return var34_41;
    }

    protected IPath getArtifactLocation(MaterializationContext context, Resolution resolution) throws CoreException {
        return context.getArtifactLocation(resolution);
    }
}

