/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.emma;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.ISessionExporter;
import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.emma.internal.Messages;
import org.eclipse.buckminster.junit.JUnitCommand;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Emma
extends JUnitCommand {
    private static final OptionDescriptor MERGE_DESCRIPTOR = new OptionDescriptor('m', "merge", 1);
    private static final OptionDescriptor EMMA_DESCRIPTOR = new OptionDescriptor(null, "emma", 3);
    private static final OptionDescriptor TXT_DESCRIPTOR = new OptionDescriptor(null, "txt", 3);
    private static final OptionDescriptor HTML_DESCRIPTOR = new OptionDescriptor(null, "html", 3);
    private static final OptionDescriptor XML_DESCRIPTOR = new OptionDescriptor(null, "xml", 3);
    private boolean merge;
    private String emma;
    private String xml;
    private String txt;
    private String html;

    protected String getLaunchMode() {
        return "coverage";
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        super.getOptionDescriptors(appendHere);
        appendHere.add(MERGE_DESCRIPTOR);
        appendHere.add(EMMA_DESCRIPTOR);
        appendHere.add(HTML_DESCRIPTOR);
        appendHere.add(TXT_DESCRIPTOR);
        appendHere.add(XML_DESCRIPTOR);
    }

    protected void handleOption(Option option) throws Exception {
        super.handleOption(option);
        if (option.is(MERGE_DESCRIPTOR)) {
            this.merge = true;
        } else if (option.is(EMMA_DESCRIPTOR)) {
            this.emma = option.getValue();
        } else if (option.is(HTML_DESCRIPTOR)) {
            this.html = option.getValue();
        } else if (option.is(TXT_DESCRIPTOR)) {
            this.txt = option.getValue();
        } else if (option.is(XML_DESCRIPTOR)) {
            this.xml = option.getValue();
        }
    }

    protected int internalRun(IProgressMonitor monitor) throws Exception {
        ICoverageSession[] oldSessions = CoverageTools.getSessionManager().getSessions();
        int result = super.internalRun(monitor);
        ICoverageSession[] sessions = CoverageTools.getSessionManager().getSessions();
        if (sessions == null || sessions.length == 0 || oldSessions != null && oldSessions.length == sessions.length) {
            throw BuckminsterException.fromMessage((String)Messages.Emma_No_coverage_sessions, (Object[])new Object[0]);
        }
        ICoverageSession session = sessions[sessions.length - 1];
        if (this.merge) {
            int i = sessions.length - 2;
            while (i >= 0) {
                session = session.merge(sessions[i], String.valueOf(session.getDescription()) + " + " + sessions[i].getDescription());
                --i;
            }
        }
        if (this.emma != null) {
            this.export(session, 3, this.emma, monitor);
        }
        if (this.html != null) {
            this.export(session, 0, this.html, monitor);
        }
        if (this.txt != null) {
            this.export(session, 2, this.txt, monitor);
        }
        if (this.xml != null) {
            this.export(session, 1, this.xml, monitor);
        }
        return result;
    }

    private void export(ICoverageSession coverageSession, int format, String destinationFile, IProgressMonitor monitor) throws CoreException {
        ISessionExporter exporter = CoverageTools.getExporter((ICoverageSession)coverageSession);
        exporter.setDestination(destinationFile);
        exporter.setFormat(format);
        exporter.export(monitor);
    }
}

