/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ProgressUtils {
    public static void checkIfCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static void noop(IProgressMonitor monitor) {
        ProgressUtils.checkIfCancelled(monitor);
        monitor.beginTask(null, 1);
        monitor.done();
    }

    public static IProgressMonitor submon(IProgressMonitor monitor, int ticks) {
        ProgressUtils.checkIfCancelled(monitor);
        return new SubProgressMonitor(monitor, ticks);
    }

    public static void worked(IProgressMonitor monitor, int work) {
        ProgressUtils.checkIfCancelled(monitor);
        monitor.worked(work);
    }
}

