/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.eclipse.buckminster.model.common.CommonFactory;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.ComponentIdentifier;
import org.eclipse.buckminster.model.common.ComponentName;
import org.eclipse.buckminster.model.common.ComponentRequest;
import org.eclipse.buckminster.model.common.ConflictResolution;
import org.eclipse.buckminster.model.common.Constant;
import org.eclipse.buckminster.model.common.Documentation;
import org.eclipse.buckminster.model.common.Format;
import org.eclipse.buckminster.model.common.Match;
import org.eclipse.buckminster.model.common.PropertyRef;
import org.eclipse.buckminster.model.common.Replace;
import org.eclipse.buckminster.model.common.RxAssembly;
import org.eclipse.buckminster.model.common.RxGroup;
import org.eclipse.buckminster.model.common.RxPattern;
import org.eclipse.buckminster.model.common.Split;
import org.eclipse.buckminster.model.common.SplitType;
import org.eclipse.buckminster.model.common.ToLower;
import org.eclipse.buckminster.model.common.ToUpper;
import org.eclipse.buckminster.model.common.Value;
import org.eclipse.buckminster.model.common.impl.ComponentIdentifierImpl;
import org.eclipse.buckminster.model.common.impl.ComponentNameImpl;
import org.eclipse.buckminster.model.common.impl.ComponentRequestImpl;
import org.eclipse.buckminster.model.common.impl.ConstantImpl;
import org.eclipse.buckminster.model.common.impl.DocumentationImpl;
import org.eclipse.buckminster.model.common.impl.FormatImpl;
import org.eclipse.buckminster.model.common.impl.MatchImpl;
import org.eclipse.buckminster.model.common.impl.PropertyConstantImpl;
import org.eclipse.buckminster.model.common.impl.PropertyElementImpl;
import org.eclipse.buckminster.model.common.impl.PropertyRefImpl;
import org.eclipse.buckminster.model.common.impl.ReplaceImpl;
import org.eclipse.buckminster.model.common.impl.RxAssemblyImpl;
import org.eclipse.buckminster.model.common.impl.RxGroupImpl;
import org.eclipse.buckminster.model.common.impl.RxPatternImpl;
import org.eclipse.buckminster.model.common.impl.SplitImpl;
import org.eclipse.buckminster.model.common.impl.ToLowerImpl;
import org.eclipse.buckminster.model.common.impl.ToUpperImpl;
import org.eclipse.buckminster.model.common.util.VersionHelper;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionFormatException;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.osgi.framework.InvalidSyntaxException;

public class CommonFactoryImpl
extends EFactoryImpl
implements CommonFactory {
    @Deprecated
    public static CommonPackage getPackage() {
        return CommonPackage.eINSTANCE;
    }

    public static CommonFactory init() {
        try {
            CommonFactory theCommonFactory = (CommonFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/buckminster/Common-1.0");
            if (theCommonFactory != null) {
                return theCommonFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CommonFactoryImpl();
    }

    public String convertCharSequenceToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String convertConflictResolutionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertCoreExceptionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String convertFilterToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertIPathToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : ((IPath)instanceValue).toPortableString();
    }

    public String convertIStatusArrayToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(instanceValue);
    }

    public String convertIVersionFormatToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        String fmtString = instanceValue.toString();
        return fmtString.substring(7, fmtString.length() - 1);
    }

    public String convertListToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(instanceValue);
    }

    public String convertPatternToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertPropertyKeyToString(EDataType eDataType, Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
    }

    public String convertSplitTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertStringBuilderToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String convertThrowableToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 26: {
                return this.convertConflictResolutionToString(eDataType, instanceValue);
            }
            case 27: {
                return this.convertSplitTypeToString(eDataType, instanceValue);
            }
            case 28: {
                return this.convertCharSequenceToString(eDataType, instanceValue);
            }
            case 29: {
                return this.convertCoreExceptionToString(eDataType, instanceValue);
            }
            case 30: {
                return this.convertFilterToString(eDataType, instanceValue);
            }
            case 31: {
                return this.convertIPathToString(eDataType, instanceValue);
            }
            case 32: {
                return this.convertIStatusArrayToString(eDataType, instanceValue);
            }
            case 33: {
                return this.convertIVersionFormatToString(eDataType, instanceValue);
            }
            case 34: {
                return this.convertListToString(eDataType, instanceValue);
            }
            case 35: {
                return this.convertPatternToString(eDataType, instanceValue);
            }
            case 36: {
                return this.convertPropertyKeyToString(eDataType, instanceValue);
            }
            case 37: {
                return this.convertStringBuilderToString(eDataType, instanceValue);
            }
            case 38: {
                return this.convertThrowableToString(eDataType, instanceValue);
            }
            case 39: {
                return this.convertURLToString(eDataType, instanceValue);
            }
            case 40: {
                return this.convertUuidToString(eDataType, instanceValue);
            }
            case 41: {
                return this.convertVersionRangeToString(eDataType, instanceValue);
            }
            case 42: {
                return this.convertVersionToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertURLToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertUuidToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertVersionRangeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertVersionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 2: {
                return this.createComponentIdentifier();
            }
            case 3: {
                return this.createComponentName();
            }
            case 4: {
                return this.createComponentRequest();
            }
            case 5: {
                return this.createConstant();
            }
            case 6: {
                return this.createDocumentation();
            }
            case 7: {
                return this.createFormat();
            }
            case 11: {
                return this.createMatch();
            }
            case 13: {
                return (EObject)this.createPropertyConstant();
            }
            case 14: {
                return (EObject)this.createPropertyElement();
            }
            case 15: {
                return this.createPropertyRef();
            }
            case 16: {
                return this.createReplace();
            }
            case 17: {
                return this.createRxAssembly();
            }
            case 18: {
                return this.createRxGroup();
            }
            case 20: {
                return this.createRxPattern();
            }
            case 21: {
                return this.createSplit();
            }
            case 22: {
                return this.createToLower();
            }
            case 23: {
                return this.createToUpper();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public CharSequence createCharSequenceFromString(EDataType eDataType, String initialValue) {
        return (CharSequence)super.createFromString(eDataType, initialValue);
    }

    @Override
    public ComponentIdentifier createComponentIdentifier() {
        ComponentIdentifierImpl componentIdentifier = new ComponentIdentifierImpl();
        return componentIdentifier;
    }

    @Override
    public ComponentIdentifier createComponentIdentifier(String componentIdentifierStr) {
        Version version = null;
        int verIdx = componentIdentifierStr.indexOf(36);
        if (verIdx >= 0) {
            String versionStr = componentIdentifierStr.substring(verIdx + 1);
            componentIdentifierStr = componentIdentifierStr.substring(0, verIdx);
            String versionType = null;
            int typeIdx = versionStr.indexOf(35);
            if (typeIdx > 0) {
                versionType = versionStr.substring(typeIdx + 1);
                versionStr = versionStr.substring(0, typeIdx);
                version = VersionHelper.createVersion(versionType, versionStr);
            } else {
                version = VersionHelper.parseVersion(versionStr);
            }
        }
        String componentType = null;
        int catIdx = componentIdentifierStr.indexOf(58);
        if (catIdx >= 0) {
            componentType = componentIdentifierStr.substring(catIdx + 1);
            componentIdentifierStr = componentIdentifierStr.substring(0, catIdx);
        }
        ComponentIdentifier result = this.createComponentIdentifier();
        result.setId(componentIdentifierStr);
        result.setType(componentType);
        result.setVersion(version);
        return result;
    }

    @Override
    public ComponentName createComponentName() {
        ComponentNameImpl componentName = new ComponentNameImpl();
        return componentName;
    }

    @Override
    public ComponentRequest createComponentRequest() {
        ComponentRequestImpl componentRequest = new ComponentRequestImpl();
        return componentRequest;
    }

    public ConflictResolution createConflictResolutionFromString(EDataType eDataType, String initialValue) {
        ConflictResolution result = ConflictResolution.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public Constant createConstant() {
        ConstantImpl constant = new ConstantImpl();
        return constant;
    }

    public CoreException createCoreExceptionFromString(EDataType eDataType, String initialValue) {
        return (CoreException)super.createFromString(eDataType, initialValue);
    }

    @Override
    public Documentation createDocumentation() {
        DocumentationImpl documentation = new DocumentationImpl();
        return documentation;
    }

    public Filter createFilterFromString(EDataType eDataType, String initialValue) {
        if (initialValue != null && (initialValue = initialValue.trim()).length() == 0) {
            initialValue = null;
        }
        if (initialValue == null) {
            return null;
        }
        try {
            return FilterFactory.newInstance((String)initialValue);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Format createFormat() {
        FormatImpl format = new FormatImpl();
        return format;
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 26: {
                return this.createConflictResolutionFromString(eDataType, initialValue);
            }
            case 27: {
                return this.createSplitTypeFromString(eDataType, initialValue);
            }
            case 28: {
                return this.createCharSequenceFromString(eDataType, initialValue);
            }
            case 29: {
                return this.createCoreExceptionFromString(eDataType, initialValue);
            }
            case 30: {
                return this.createFilterFromString(eDataType, initialValue);
            }
            case 31: {
                return this.createIPathFromString(eDataType, initialValue);
            }
            case 32: {
                return this.createIStatusArrayFromString(eDataType, initialValue);
            }
            case 33: {
                return this.createIVersionFormatFromString(eDataType, initialValue);
            }
            case 34: {
                return this.createListFromString(eDataType, initialValue);
            }
            case 35: {
                return this.createPatternFromString(eDataType, initialValue);
            }
            case 36: {
                return this.createPropertyKeyFromString(eDataType, initialValue);
            }
            case 37: {
                return this.createStringBuilderFromString(eDataType, initialValue);
            }
            case 38: {
                return this.createThrowableFromString(eDataType, initialValue);
            }
            case 39: {
                return this.createURLFromString(eDataType, initialValue);
            }
            case 40: {
                return this.createUuidFromString(eDataType, initialValue);
            }
            case 41: {
                return this.createVersionRangeFromString(eDataType, initialValue);
            }
            case 42: {
                return this.createVersionFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public IPath createIPathFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : Path.fromPortableString((String)initialValue);
    }

    public IStatus[] createIStatusArrayFromString(EDataType eDataType, String initialValue) {
        return (IStatus[])super.createFromString(initialValue);
    }

    public IVersionFormat createIVersionFormatFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        try {
            return Version.compile((String)initialValue);
        }
        catch (VersionFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public List<?> createListFromString(EDataType eDataType, String initialValue) {
        return (List)super.createFromString(initialValue);
    }

    @Override
    public Match createMatch() {
        MatchImpl match = new MatchImpl();
        return match;
    }

    public Pattern createPatternFromString(EDataType eDataType, String initialValue) {
        if (initialValue != null && (initialValue = initialValue.trim()).length() == 0) {
            initialValue = null;
        }
        if (initialValue == null) {
            return null;
        }
        return Pattern.compile(initialValue);
    }

    public Map.Entry<String, Value> createPropertyConstant() {
        PropertyConstantImpl propertyConstant = new PropertyConstantImpl();
        return propertyConstant;
    }

    public Map.Entry<String, Value> createPropertyElement() {
        PropertyElementImpl propertyElement = new PropertyElementImpl();
        return propertyElement;
    }

    public String createPropertyKeyFromString(EDataType eDataType, String initialValue) {
        return (String)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
    }

    @Override
    public PropertyRef createPropertyRef() {
        PropertyRefImpl propertyRef = new PropertyRefImpl();
        return propertyRef;
    }

    @Override
    public Replace createReplace() {
        ReplaceImpl replace = new ReplaceImpl();
        return replace;
    }

    @Override
    public RxAssembly createRxAssembly() {
        RxAssemblyImpl rxAssembly = new RxAssemblyImpl();
        return rxAssembly;
    }

    @Override
    public RxGroup createRxGroup() {
        RxGroupImpl rxGroup = new RxGroupImpl();
        return rxGroup;
    }

    @Override
    public RxPattern createRxPattern() {
        RxPatternImpl rxPattern = new RxPatternImpl();
        return rxPattern;
    }

    @Override
    public Split createSplit() {
        SplitImpl split = new SplitImpl();
        return split;
    }

    public SplitType createSplitTypeFromString(EDataType eDataType, String initialValue) {
        SplitType result = SplitType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public StringBuilder createStringBuilderFromString(EDataType eDataType, String initialValue) {
        return (StringBuilder)super.createFromString(eDataType, initialValue);
    }

    public Throwable createThrowableFromString(EDataType eDataType, String initialValue) {
        return (Throwable)super.createFromString(eDataType, initialValue);
    }

    @Override
    public ToLower createToLower() {
        ToLowerImpl toLower = new ToLowerImpl();
        return toLower;
    }

    @Override
    public ToUpper createToUpper() {
        ToUpperImpl toUpper = new ToUpperImpl();
        return toUpper;
    }

    public URL createURLFromString(EDataType eDataType, String initialValue) {
        if (initialValue != null && (initialValue = initialValue.trim()).length() == 0) {
            initialValue = null;
        }
        if (initialValue == null) {
            return null;
        }
        try {
            return new URL(initialValue);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public UUID createUuidFromString(EDataType eDataType, String initialValue) {
        if (initialValue != null && (initialValue = initialValue.trim()).length() == 0) {
            initialValue = null;
        }
        return initialValue == null ? null : UUID.fromString(initialValue);
    }

    public Version createVersionFromString(EDataType eDataType, String initialValue) {
        return Version.create((String)initialValue);
    }

    public VersionRange createVersionRangeFromString(EDataType eDataType, String initialValue) {
        if (initialValue != null && (initialValue = initialValue.trim()).length() == 0) {
            initialValue = null;
        }
        return initialValue == null ? null : new VersionRange(initialValue);
    }

    @Override
    public CommonPackage getCommonPackage() {
        return (CommonPackage)this.getEPackage();
    }
}

