/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.GitBaseResourceVariantTree;
import org.eclipse.egit.core.synchronize.GitRemoteResourceVariantTree;
import org.eclipse.egit.core.synchronize.GitResourceVariantComparator;
import org.eclipse.egit.core.synchronize.GitSyncCache;
import org.eclipse.egit.core.synchronize.GitSyncInfo;
import org.eclipse.egit.core.synchronize.GitSyncObjectCache;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.IResourceVariantTree;
import org.eclipse.team.core.variants.ResourceVariantTreeSubscriber;

public class GitResourceVariantTreeSubscriber
extends ResourceVariantTreeSubscriber {
    private GitRemoteResourceVariantTree remoteTree;
    private GitBaseResourceVariantTree baseTree;
    private GitSynchronizeDataSet gsds;
    private IResource[] roots;
    private GitSyncCache cache;

    public GitResourceVariantTreeSubscriber(GitSynchronizeDataSet data) {
        this.gsds = data;
    }

    public void init(IProgressMonitor monitor) {
        monitor.beginTask(CoreText.GitResourceVariantTreeSubscriber_fetchTaskName, this.gsds.size());
        try {
            this.cache = GitSyncCache.getAllData(this.gsds, monitor);
        }
        finally {
            monitor.done();
        }
    }

    public boolean isSupervised(IResource res) throws TeamException {
        return 1 == res.getType() && this.gsds.contains(res.getProject()) && !Team.isIgnoredHint((IResource)res) && this.shouldBeIncluded(res);
    }

    public IResource[] members(IResource res) throws TeamException {
        Collection<GitSyncObjectCache> members;
        if (res.getType() == 1 || !this.shouldBeIncluded(res)) {
            return new IResource[0];
        }
        GitSynchronizeData gsd = this.gsds.getData(res.getProject());
        Repository repo = gsd.getRepository();
        GitSyncObjectCache repoCache = this.cache.get(repo);
        HashSet<IResource> gitMembers = new HashSet<IResource>();
        HashMap<String, IResource> allMembers = new HashMap<String, IResource>();
        HashSet<GitSyncObjectCache> gitCachedMembers = new HashSet<GitSyncObjectCache>();
        String path = Repository.stripWorkDir((File)repo.getWorkTree(), (File)res.getLocation().toFile());
        GitSyncObjectCache cachedMembers = repoCache.get(path);
        if (cachedMembers != null && (members = cachedMembers.members()) != null) {
            gitCachedMembers.addAll(members);
        }
        try {
            IResource[] iResourceArray = ((IContainer)res).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                allMembers.put(member.getName(), member);
                ++n2;
            }
            for (GitSyncObjectCache gitMember : gitCachedMembers) {
                IResource member = (IResource)allMembers.get(gitMember.getName());
                if (member == null) continue;
                gitMembers.add(member);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
        return gitMembers.toArray(new IResource[gitMembers.size()]);
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 8) {
                GitSyncCache newCache = GitSyncCache.getAllData(this.gsds, monitor);
                this.cache.merge(newCache);
                super.refresh(resources, depth, monitor);
                return;
            }
            ++n2;
        }
        HashMap<GitSynchronizeData, Collection<String>> updateRequests = new HashMap<GitSynchronizeData, Collection<String>>();
        IResource[] iResourceArray2 = resources;
        int n3 = resources.length;
        n = 0;
        while (n < n3) {
            RepositoryMapping mapping;
            IResource resource = iResourceArray2[n];
            IProject project = resource.getProject();
            GitSynchronizeData data = this.gsds.getData(project.getName());
            if (data != null && (mapping = RepositoryMapping.getMapping((IResource)project)) != null) {
                String path;
                ArrayList<String> paths = (ArrayList<String>)updateRequests.get(data);
                if (paths == null) {
                    paths = new ArrayList<String>();
                    updateRequests.put(data, paths);
                }
                if ((path = mapping.getRepoRelativePath(resource)) == null) {
                    path = "";
                }
                paths.add(path);
            }
            ++n;
        }
        if (!updateRequests.isEmpty()) {
            GitSyncCache newCache = GitSyncCache.getAllData(updateRequests, monitor);
            this.cache.merge(newCache);
        }
        super.refresh(resources, depth, monitor);
    }

    public IResource[] roots() {
        if (this.roots == null) {
            this.roots = this.gsds.getAllProjects();
        }
        IResource[] result = new IResource[this.roots.length];
        System.arraycopy(this.roots, 0, result, 0, this.roots.length);
        return result;
    }

    public void reset(GitSynchronizeDataSet data) {
        this.gsds = data;
        this.roots = null;
        this.baseTree = null;
        this.remoteTree = null;
    }

    public void dispose() {
        if (this.baseTree != null) {
            this.baseTree.dispose();
        }
        if (this.remoteTree != null) {
            this.remoteTree.dispose();
        }
        this.gsds.dispose();
    }

    public String getName() {
        return CoreText.GitBranchResourceVariantTreeSubscriber_gitRepository;
    }

    public IResourceVariantComparator getResourceComparator() {
        return new GitResourceVariantComparator(this.gsds);
    }

    protected IResourceVariantTree getBaseTree() {
        if (this.baseTree == null) {
            this.baseTree = new GitBaseResourceVariantTree(this.cache, this.gsds);
        }
        return this.baseTree;
    }

    protected IResourceVariantTree getRemoteTree() {
        if (this.remoteTree == null) {
            this.remoteTree = new GitRemoteResourceVariantTree(this.cache, this.gsds);
        }
        return this.remoteTree;
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        Repository repo = this.gsds.getData(local.getProject()).getRepository();
        GitSyncInfo info = new GitSyncInfo(local, base, remote, this.getResourceComparator(), this.cache.get(repo), repo);
        info.init();
        return info;
    }

    private boolean shouldBeIncluded(IResource res) {
        if (res == null) {
            return false;
        }
        IProject proj = res.getProject();
        if (proj == null) {
            return false;
        }
        GitSynchronizeData d = this.gsds.getData(proj);
        if (d == null) {
            return false;
        }
        Set<IContainer> includedPaths = d.getIncludedPaths();
        if (includedPaths == null) {
            return true;
        }
        IPath path = res.getLocation();
        for (IContainer container : includedPaths) {
            if (!container.getLocation().isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }
}

