/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.core;

import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.IExecutionDataSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;

public class URLExecutionDataSource
implements IExecutionDataSource {
    private final URL url;

    public URLExecutionDataSource(URL url) {
        this.url = url;
    }

    public void accept(IExecutionDataVisitor executionDataVisitor, ISessionInfoVisitor sessionInfoVisitor) throws CoreException {
        try {
            BufferedInputStream in = new BufferedInputStream(this.url.openStream());
            ExecutionDataReader reader = new ExecutionDataReader((InputStream)in);
            reader.setExecutionDataVisitor(executionDataVisitor);
            reader.setSessionInfoVisitor(sessionInfoVisitor);
            reader.read();
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw new CoreException(EclEmmaStatus.EXEC_FILE_READ_ERROR.getStatus(this.url, e));
        }
    }
}

