/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.core.analysis.IJavaModelCoverage;
import com.mountainminds.eclemma.internal.core.DebugOptions;
import com.mountainminds.eclemma.internal.core.analysis.MethodLocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jacoco.core.analysis.CoverageNodeImpl;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.IMethodCoverage;

public class JavaModelCoverage
extends CoverageNodeImpl
implements IJavaModelCoverage {
    private static final DebugOptions.ITracer TRACER = DebugOptions.ANALYSISTRACER;
    private final Map<IJavaElement, ICoverageNode> coveragemap = new HashMap<IJavaElement, ICoverageNode>();
    private final List<IJavaProject> projects = new ArrayList<IJavaProject>();
    private final List<IPackageFragmentRoot> fragmentroots = new ArrayList<IPackageFragmentRoot>();
    private final List<IPackageFragment> fragments = new ArrayList<IPackageFragment>();
    private final List<IType> types = new ArrayList<IType>();

    public JavaModelCoverage() {
        super(ICoverageNode.ElementType.GROUP, "JavaModel");
    }

    public void putFragmentRoot(IPackageFragmentRoot fragmentroot, IBundleCoverage coverage) {
        this.coveragemap.put((IJavaElement)fragmentroot, (ICoverageNode)coverage);
        this.fragmentroots.add(fragmentroot);
        this.getProjectCoverage(fragmentroot.getJavaProject()).increment((ICoverageNode)coverage);
    }

    private CoverageNodeImpl getProjectCoverage(IJavaProject project) {
        CoverageNodeImpl coverage = (CoverageNodeImpl)this.coveragemap.get(project);
        if (coverage == null) {
            coverage = new CoverageNodeImpl(ICoverageNode.ElementType.GROUP, project.getElementName());
            this.coveragemap.put((IJavaElement)project, (ICoverageNode)coverage);
            this.projects.add(project);
        }
        return coverage;
    }

    public void putFragment(IPackageFragment element, ICoverageNode coverage) {
        this.coveragemap.put((IJavaElement)element, coverage);
        this.fragments.add(element);
    }

    public void putType(IType element, ICoverageNode coverage) {
        this.coveragemap.put((IJavaElement)element, coverage);
        this.types.add(element);
    }

    public void putClassFile(IClassFile element, ICoverageNode coverage) {
        this.coveragemap.put((IJavaElement)element, coverage);
    }

    public void putCompilationUnit(ICompilationUnit element, ICoverageNode coverage) {
        this.coveragemap.put((IJavaElement)element, coverage);
    }

    public IJavaProject[] getProjects() {
        IJavaProject[] arr = new IJavaProject[this.projects.size()];
        return this.projects.toArray(arr);
    }

    public IPackageFragmentRoot[] getPackageFragmentRoots() {
        IPackageFragmentRoot[] arr = new IPackageFragmentRoot[this.fragmentroots.size()];
        return this.fragmentroots.toArray(arr);
    }

    public IPackageFragment[] getPackageFragments() {
        IPackageFragment[] arr = new IPackageFragment[this.fragments.size()];
        return this.fragments.toArray(arr);
    }

    public IType[] getTypes() {
        IType[] arr = new IType[this.types.size()];
        return this.types.toArray(arr);
    }

    public ICoverageNode getCoverageFor(IJavaElement element) {
        ICoverageNode coverage = this.coveragemap.get(element);
        if (coverage != null) {
            return coverage;
        }
        if (9 == element.getElementType()) {
            this.resolveMethods((IType)element.getParent());
            return this.coveragemap.get(element);
        }
        return null;
    }

    private void resolveMethods(IType type) {
        IClassCoverage classCoverage = (IClassCoverage)this.getCoverageFor((IJavaElement)type);
        if (classCoverage == null) {
            return;
        }
        try {
            MethodLocator locator = new MethodLocator(type);
            for (IMethodCoverage methodCoverage : classCoverage.getMethods()) {
                IMethod method = locator.findMethod(methodCoverage.getName(), methodCoverage.getDesc());
                if (method != null) {
                    this.coveragemap.put((IJavaElement)method, (ICoverageNode)methodCoverage);
                    continue;
                }
                TRACER.trace("Method not found in Java model: {0}.{1}{2}", type.getFullyQualifiedName(), methodCoverage.getName(), methodCoverage.getDesc());
            }
        }
        catch (JavaModelException e) {
            TRACER.trace("Error while creating method locator for {0}: {1}", type.getFullyQualifiedName(), (Object)e);
        }
    }
}

