/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.analysis.IJavaModelCoverage;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.DebugOptions;
import com.mountainminds.eclemma.internal.core.analysis.AnalyzedNodes;
import com.mountainminds.eclemma.internal.core.analysis.ITypeVisitor;
import com.mountainminds.eclemma.internal.core.analysis.JavaModelCoverage;
import com.mountainminds.eclemma.internal.core.analysis.PackageFragementRootAnalyzer;
import com.mountainminds.eclemma.internal.core.analysis.TypeTraverser;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.internal.analysis.BundleCoverageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAnalyzer {
    private static final DebugOptions.ITracer PERFORMANCE = DebugOptions.PERFORMANCETRACER;
    private JavaModelCoverage modelcoverage;
    private ExecutionDataStore executiondatastore;
    private SessionInfoStore sessioninfostore;

    public IJavaModelCoverage processSession(ICoverageSession session, IProgressMonitor monitor) throws CoreException {
        PERFORMANCE.startTimer();
        PERFORMANCE.startMemoryUsage();
        this.modelcoverage = new JavaModelCoverage();
        Set<IPackageFragmentRoot> roots = session.getScope();
        monitor.beginTask(NLS.bind((String)CoreMessages.AnalyzingCoverageSession_task, (Object)session.getDescription()), 1 + roots.size());
        this.executiondatastore = new ExecutionDataStore();
        this.sessioninfostore = new SessionInfoStore();
        session.accept((IExecutionDataVisitor)this.executiondatastore, (ISessionInfoVisitor)this.sessioninfostore);
        monitor.worked(1);
        PackageFragementRootAnalyzer analyzer = new PackageFragementRootAnalyzer(this.executiondatastore);
        for (IPackageFragmentRoot root : roots) {
            if (monitor.isCanceled()) break;
            this.processPackageFragmentRoot(root, analyzer, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
        PERFORMANCE.stopTimer("loading " + session.getDescription());
        PERFORMANCE.stopMemoryUsage("loading " + session.getDescription());
        return this.modelcoverage;
    }

    public List<SessionInfo> getSessionInfos() {
        return this.sessioninfostore.getInfos();
    }

    public Collection<ExecutionData> getExecutionData() {
        return this.executiondatastore.getContents();
    }

    private void processPackageFragmentRoot(IPackageFragmentRoot root, PackageFragementRootAnalyzer analyzer, IProgressMonitor monitor) throws CoreException {
        TypeVisitor visitor = new TypeVisitor(analyzer.analyze(root));
        new TypeTraverser(root).process(visitor, monitor);
        BundleCoverageImpl bundle = new BundleCoverageImpl(this.getName(root), visitor.getClasses(), visitor.getSources());
        this.modelcoverage.putFragmentRoot(root, (IBundleCoverage)bundle);
        this.putPackages(bundle.getPackages(), root);
    }

    String getName(IPackageFragmentRoot root) {
        IPath path = root.getPath();
        if (!root.isExternal() && path.segmentCount() > 1) {
            return path.removeFirstSegments(1).toString();
        }
        return path.lastSegment();
    }

    private void putPackages(Collection<IPackageCoverage> packages, IPackageFragmentRoot root) {
        for (IPackageCoverage c : packages) {
            String name = c.getName().replace('/', '.');
            IPackageFragment fragment = root.getPackageFragment(name);
            this.modelcoverage.putFragment(fragment, (ICoverageNode)c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeVisitor
    implements ITypeVisitor {
        private final AnalyzedNodes nodes;
        private final Set<IClassCoverage> classes;
        private final Set<ISourceFileCoverage> sources;

        TypeVisitor(AnalyzedNodes nodes) {
            this.nodes = nodes;
            this.classes = new HashSet<IClassCoverage>();
            this.sources = new HashSet<ISourceFileCoverage>();
        }

        Collection<IClassCoverage> getClasses() {
            return this.classes;
        }

        Collection<ISourceFileCoverage> getSources() {
            return this.sources;
        }

        @Override
        public void visit(IType type, String vmname) {
            IClassCoverage coverage = this.nodes.getClassCoverage(vmname);
            if (coverage != null) {
                this.classes.add(coverage);
                SessionAnalyzer.this.modelcoverage.putType(type, (ICoverageNode)coverage);
            }
        }

        @Override
        public void visit(IClassFile classfile) throws JavaModelException {
            String vmname = classfile.getType().getFullyQualifiedName().replace('.', '/');
            IClassCoverage coverage = this.nodes.getClassCoverage(vmname);
            if (coverage != null) {
                SessionAnalyzer.this.modelcoverage.putClassFile(classfile, (ICoverageNode)coverage);
                ISourceFileCoverage source = this.nodes.getSourceFileCoverage(coverage.getPackageName(), coverage.getSourceFileName());
                if (source != null) {
                    this.sources.add(source);
                }
            }
        }

        @Override
        public void visit(ICompilationUnit unit) throws JavaModelException {
            String vmpackagename = unit.getParent().getElementName().replace('.', '/');
            ISourceFileCoverage coverage = this.nodes.getSourceFileCoverage(vmpackagename, unit.getElementName());
            if (coverage != null) {
                this.sources.add(coverage);
                SessionAnalyzer.this.modelcoverage.putCompilationUnit(unit, (ICoverageNode)coverage);
            }
        }
    }
}

