/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.launching;

import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.ICorePreferences;
import com.mountainminds.eclemma.internal.core.EclEmmaCorePlugin;
import com.mountainminds.eclemma.internal.core.launching.AdjustedLaunchConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.jacoco.agent.AgentJar;
import org.jacoco.core.runtime.AgentOptions;

public class AgentArgumentSupport {
    private final ICorePreferences preferences;

    protected AgentArgumentSupport(ICorePreferences preferences) {
        this.preferences = preferences;
    }

    public AgentArgumentSupport() {
        this(EclEmmaCorePlugin.getInstance().getPreferences());
    }

    public ILaunchConfiguration addArgument(int serverPort, ILaunchConfiguration config) throws CoreException {
        return new AdjustedLaunchConfiguration(this.getArgument(serverPort), config);
    }

    protected String getArgument(int serverPort) throws CoreException {
        AgentOptions options = new AgentOptions();
        options.setIncludes(this.preferences.getAgentIncludes());
        options.setExcludes(this.preferences.getAgentExcludes());
        options.setExclClassloader(this.preferences.getAgentExclClassloader());
        options.setOutput(AgentOptions.OutputMode.tcpclient);
        options.setPort(serverPort);
        return this.quote(options.getVMArgument(this.getAgentFile()));
    }

    protected File getAgentFile() throws CoreException {
        try {
            URL agentfileurl = FileLocator.toFileURL((URL)AgentJar.getResource());
            return new Path(agentfileurl.getPath()).toFile();
        }
        catch (IOException e) {
            throw new CoreException(EclEmmaStatus.NO_LOCAL_AGENTJAR_ERROR.getStatus(e));
        }
    }

    protected String quote(String arg) {
        if (arg.indexOf(32) == -1) {
            return arg;
        }
        return String.valueOf('\"') + arg + '\"';
    }
}

