/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.CommandInfo;
import org.eclipse.buckminster.cmdline.Messages;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.OptionValueType;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.cmdline.parser.CommandLineParser;
import org.eclipse.buckminster.cmdline.parser.InvalidOptionValueException;
import org.eclipse.buckminster.cmdline.parser.ParseResult;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

public class Headless
implements IApplication,
OptionValueType {
    public static final String PLUGIN_ID = "org.eclipse.buckminster.cmdline";
    public static final int EXIT_FORCED = 2;
    public static final int EXIT_FAIL = 1;
    public static final int EXIT_OK = 0;
    private static final OptionDescriptor DISPLAY_STACKTRACE = new OptionDescriptor(null, "displaystacktrace", 1);
    private static final OptionDescriptor HELP = new OptionDescriptor('?', "help", 1);
    private static final OptionDescriptor LOG_LEVEL = new OptionDescriptor('L', "loglevel", 3);
    private static final OptionDescriptor FILE = new OptionDescriptor('S', "scriptfile", 3);
    static final OptionDescriptor DEFINE_DESCRIPTOR = new OptionDescriptor('D', "define", 3);
    static final OptionDescriptor PROPERTIES_DESCRIPTOR = new OptionDescriptor('P', "properties", 3);
    static final Pattern DEFINE_PATTERN = Pattern.compile("^([^=]+)(?:=(.+))?$");
    private final ArrayList<Invocation> invocations = new ArrayList();
    private Properties props;
    private boolean displayStackTrace = false;
    private boolean help = false;
    private boolean usingScript = false;
    private int logLevel = 1;
    private int antLogLevel = -1;
    private static final Pattern commaSplit = Pattern.compile(",");

    public void addProperty(String key, String value) {
        if (this.props == null) {
            this.props = new Properties(System.getProperties());
        }
        this.props.put(key, value);
    }

    public Object run(Object objArgs) throws Exception {
        Buckminster.setHeadless();
        int exitValue = 1;
        try {
            exitValue = this.run((String[])objArgs);
        }
        catch (OperationCanceledException e) {
            System.err.println(Messages.Headless_Command_canceled);
        }
        catch (InterruptedException e) {
            System.err.println(Messages.Headless_Command_was_interrupted);
        }
        catch (SimpleErrorExitException e) {
            System.err.println(e.getMessage());
            exitValue = e.getExitValue();
        }
        catch (UsageException e) {
            System.err.println(e.getMessage());
            if (e.isEmitHelp()) {
                this.help(System.out);
            }
        }
        catch (Throwable e) {
            BuckminsterException.deeplyPrint((Throwable)e, (PrintStream)System.err, (boolean)this.displayStackTrace);
        }
        return new Integer(exitValue);
    }

    public Object start(IApplicationContext context) throws Exception {
        return this.run(context.getArguments().get("application.args"));
    }

    public void stop() {
    }

    protected void help(PrintStream ps) throws Exception {
        PrintStream out = System.out;
        InputStream is = this.getClass().getResourceAsStream("Headless.help");
        if (is == null) {
            out.println(Messages.Headless_Help_is_not_available);
        } else {
            out.println(Messages.Headless_Help_text_for_buckminster);
            try {
                IOUtils.copy((InputStream)is, (OutputStream)out, null);
                out.flush();
            }
            finally {
                IOUtils.close((Closeable)is);
            }
        }
    }

    protected void parse(String[] args) throws Exception {
        String[] unparsed;
        ArrayList<OptionDescriptor> optionArr = new ArrayList<OptionDescriptor>();
        optionArr.add(DISPLAY_STACKTRACE);
        optionArr.add(FILE);
        optionArr.add(HELP);
        optionArr.add(LOG_LEVEL);
        optionArr.add(DEFINE_DESCRIPTOR);
        optionArr.add(PROPERTIES_DESCRIPTOR);
        ParseResult pr = ParseResult.parse(args, optionArr);
        String scriptFile = null;
        Option[] options = pr.getOptions();
        int top = options.length;
        int idx = 0;
        while (idx < top) {
            Option option = options[idx];
            if (option.is(HELP)) {
                this.help = true;
            } else if (option.is(DISPLAY_STACKTRACE)) {
                this.displayStackTrace = true;
            } else if (option.is(FILE)) {
                scriptFile = option.getValue();
            } else if (option.is(LOG_LEVEL)) {
                String[] stringArray = commaSplit.split(option.getValue());
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int level;
                    String levelDecl = stringArray[n2];
                    LogType logType = LogType.console;
                    int eqIdx = levelDecl.indexOf(61);
                    if (eqIdx > 0) {
                        String logTypeName = levelDecl.substring(0, eqIdx);
                        if ("console".equalsIgnoreCase(logTypeName)) {
                            logType = LogType.console;
                        } else if ("ant".equalsIgnoreCase(logTypeName)) {
                            logType = LogType.ant;
                        } else {
                            throw new InvalidOptionValueException(option.getName(), option.getValue());
                        }
                        levelDecl = levelDecl.substring(eqIdx + 1);
                    }
                    if ("info".equalsIgnoreCase(levelDecl)) {
                        level = 1;
                    } else if ("warning".equalsIgnoreCase(levelDecl)) {
                        level = 2;
                    } else if ("error".equalsIgnoreCase(levelDecl)) {
                        level = 4;
                    } else if ("debug".equalsIgnoreCase(levelDecl)) {
                        level = 0;
                    } else {
                        throw new InvalidOptionValueException(option.getName(), option.getValue());
                    }
                    switch (logType) {
                        case console: {
                            this.logLevel = level;
                            break;
                        }
                        case ant: {
                            this.antLogLevel = level;
                        }
                    }
                    ++n2;
                }
            } else if (option.is(DEFINE_DESCRIPTOR)) {
                String v = option.getValue();
                Matcher m = DEFINE_PATTERN.matcher(v);
                if (!m.matches()) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.Not_a_key_value_string_0, (Object)v));
                }
                String key = m.group(1);
                String value = m.group(2) == null ? "" : m.group(2);
                this.addProperty(key, value);
            } else if (option.is(PROPERTIES_DESCRIPTOR)) {
                String v = option.getValue();
                BufferedInputStream input = null;
                try {
                    try {
                        URL propsURL = URLUtils.normalizeToURL((String)v);
                        input = new BufferedInputStream(propsURL.openStream());
                        if (this.props == null) {
                            this.props = new Properties(System.getProperties());
                        }
                        this.props.load(input);
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.Invalid_URL_or_Path_0, (Object)v));
                    }
                }
                catch (Throwable value) {
                    IOUtils.close(input);
                    throw value;
                }
                IOUtils.close((Closeable)input);
            } else {
                throw new InternalError(Messages.Headless_Unexpected_option);
            }
            ++idx;
        }
        if (this.props != null) {
            System.setProperties(this.props);
        }
        if ((unparsed = pr.getUnparsed()).length > 0) {
            if (scriptFile != null) {
                throw new UsageException(Messages.Headless_The_scriptfile_option_cannot_be_combined_with_a_command, true);
            }
            String[] commandArgs = new String[unparsed.length - 1];
            System.arraycopy(unparsed, 1, commandArgs, 0, commandArgs.length);
            this.invocations.add(new Invocation(unparsed[0], commandArgs));
        } else if (scriptFile != null) {
            InputStream lines = null;
            try {
                String line;
                lines = scriptFile.equals("-") ? System.in : new FileInputStream(scriptFile);
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(lines));
                while ((line = reader.readLine()) != null) {
                    CommandLineParser tokenParser = new CommandLineParser(line);
                    if (!tokenParser.hasNext()) continue;
                    String command = tokenParser.next();
                    ArrayList<String> tokens = new ArrayList<String>();
                    while (tokenParser.hasNext()) {
                        tokens.add(tokenParser.next());
                    }
                    this.invocations.add(new Invocation(command, tokens.toArray(new String[tokens.size()])));
                    this.usingScript = true;
                }
            }
            finally {
                if (lines != System.in) {
                    IOUtils.close((Closeable)lines);
                }
            }
        }
    }

    protected int run(String[] args) throws Exception {
        int currentAntLogLevel = BuckminsterPreferences.getLogLevelAntLogger();
        Properties sysProps = System.getProperties();
        try {
            this.parse(args);
            Logger.setConsoleLevelThreshold((int)this.logLevel);
            Logger.setEclipseLoggerLevelThreshold((int)this.logLevel);
            Logger.setEclipseLoggerToConsole((boolean)true);
            if (this.antLogLevel != -1) {
                BuckminsterPreferences.setLogLevelAntLogger((int)this.antLogLevel);
            }
            if (this.help) {
                this.help(System.out);
                return 0;
            }
            IJobManager jobMgr = Job.getJobManager();
            int top = this.invocations.size();
            if (top == 0) {
                System.out.println(Messages.Headless_No_command_provided_Try_one_of);
                System.out.println(Messages.Headless_buckminster__help);
                System.out.println(Messages.Headless_buckminster_listcommands);
                System.out.println(Messages.Headless_buckminster_command__help);
                return 1;
            }
            Logger logger = Buckminster.getLogger();
            int idx = 0;
            while (idx < top) {
                Invocation invocation = this.invocations.get(idx);
                String commandName = invocation.getName();
                CommandInfo ci = CommandInfo.getCommand(commandName);
                AbstractCommand cmd = ci.createInstance();
                jobMgr.setProgressProvider(cmd.getProgressProvider());
                if (logger.isDebugEnabled()) {
                    logger.debug(invocation.toString(), new Object[0]);
                } else if (this.usingScript) {
                    logger.info(invocation.toString(), new Object[0]);
                }
                int exitValue = cmd.basicRun(commandName, ci, invocation.getArgs());
                if (exitValue != 0) {
                    int n = exitValue;
                    return n;
                }
                ++idx;
            }
        }
        finally {
            if (this.props != null) {
                System.setProperties(sysProps);
            }
            if (this.antLogLevel != -1) {
                BuckminsterPreferences.setLogLevelAntLogger((int)currentAntLogLevel);
            }
        }
        return 0;
    }

    public static class Invocation {
        private final String name;
        private final String[] args;

        public Invocation(String name, String[] args) {
            this.name = name;
            this.args = args == null ? Trivial.EMPTY_STRING_ARRAY : args;
        }

        public String[] getArgs() {
            return this.args;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            int nargs = this.args.length;
            if (nargs == 0) {
                return this.name;
            }
            StringBuffer bld = new StringBuffer();
            bld.append(this.name);
            int idx = 0;
            while (idx < nargs) {
                bld.append(" '");
                bld.append(this.args[idx]);
                bld.append('\'');
                ++idx;
            }
            return bld.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LogType {
        console,
        ant,
        eclipse;

    }
}

