/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;

public class UUIDUtil {
    public static UUID fromRawBytes(byte[] data) {
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16);
        int i = 0;
        while (i < 8) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
            ++i;
        }
        i = 8;
        while (i < 16) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
            ++i;
        }
        return new UUID(msb, lsb);
    }

    public static UUID nameUUIDFromBytes(byte[] name, int offset, int len) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError(Messages.MD5_not_supported);
        }
        md.update(name, offset, len);
        byte[] md5Bytes = md.digest();
        md5Bytes[6] = (byte)(md5Bytes[6] & 0xF);
        md5Bytes[6] = (byte)(md5Bytes[6] | 0x30);
        md5Bytes[8] = (byte)(md5Bytes[8] & 0x3F);
        md5Bytes[8] = (byte)(md5Bytes[8] | 0x80);
        return UUIDUtil.fromRawBytes(md5Bytes);
    }
}

