/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.reader.AbstractReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.reader.URLFileReader;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLReaderType
extends AbstractReaderType {
    public static IComponentReader getReader(URL externalFile, IProgressMonitor monitor) throws CoreException {
        return URLReaderType.getDirectReader(externalFile, "url", monitor);
    }

    static IComponentReader getDirectReader(URL url, String readerType, IProgressMonitor monitor) throws CoreException {
        String urlString = url.toString();
        ComponentRequest rq = new ComponentRequest(urlString, null, null);
        ComponentQueryBuilder queryBld = new ComponentQueryBuilder();
        queryBld.setRootRequest(rq);
        queryBld.setPlatformAgnostic(true);
        ResolutionContext context = new ResolutionContext(queryBld.createComponentQuery());
        NodeQuery nq = new NodeQuery(context, rq, null);
        IComponentType ctype = CorePlugin.getDefault().getComponentType("unknown");
        Provider provider = Provider.immutableProvider(readerType, ctype.getId(), urlString);
        ProviderMatch pm = new ProviderMatch(provider, ctype, VersionMatch.DEFAULT, ProviderScore.GOOD, nq);
        return pm.getReader(monitor);
    }

    @Override
    public String convertFetchFactoryLocator(Map<String, String> fetchFactoryLocator, String componentName) throws CoreException {
        return fetchFactoryLocator.get("src");
    }

    @Override
    public URL convertToURL(String repositoryLocator, VersionMatch versionSelector) throws CoreException {
        try {
            return URLUtils.normalizeToURL((String)repositoryLocator);
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        try {
            return new URI(resolution.getRepository());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public Map<String, String> getFetchFactoryProviderProps(Map<String, String> properties, Provider delegee) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("buckminster.source", Boolean.FALSE.toString());
        props.put("buckminster.mutable", Boolean.FALSE.toString());
        return props;
    }

    @Override
    public IPath getLeafArtifact(Resolution resolution, MaterializationContext context) throws CoreException {
        IPath path;
        int segCount;
        String name = resolution.getRemoteName();
        if (name != null) {
            return Path.fromPortableString((String)name);
        }
        URI uri = this.getURI(resolution.getRepository());
        Map params = URLUtils.queryAsParameters((String)uri.getQuery());
        String pathStr = (String)params.get("file");
        if (pathStr == null) {
            pathStr = uri.getPath();
        }
        if ((segCount = (path = Path.fromPortableString((String)pathStr)).segmentCount()) > 1) {
            path = path.removeFirstSegments(segCount - 1);
        }
        return path;
    }

    public IReaderType getLocalReaderType() {
        return this;
    }

    @Override
    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new URLFileReader(this, providerMatch, this.getURI(providerMatch));
    }

    @Override
    public IComponentReader getReader(Resolution resolution, RMContext context, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new URLFileReader(this, resolution.getProviderMatch(context), this.getURI(resolution.getRepository()));
    }

    @Override
    public String getRemotePath(String repositoryLocation) throws CoreException {
        return this.getURI(repositoryLocation).getPath();
    }

    public URI getURI(ProviderMatch providerMatch) throws CoreException {
        return this.getURI(providerMatch.getRepositoryURI());
    }

    public URI getURI(String repository) throws CoreException {
        return URLUtils.normalizeToURI((String)repository, (boolean)false);
    }

    @Override
    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery query, IProgressMonitor monitor) throws CoreException {
        return new AbstractReaderType.DefaultVersionFinder(provider, ctype, query);
    }

    @Override
    public boolean isFileReader() {
        return true;
    }
}

