/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import java.net.URL;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.parser.DocumentationHandler;
import org.eclipse.buckminster.core.common.parser.PropertyManagerHandler;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.parser.MatcherHandler;
import org.eclipse.buckminster.core.rmap.parser.ResourceMapParser;
import org.eclipse.buckminster.core.rmap.parser.SearchPathHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMapHandler
extends PropertyManagerHandler {
    private URL contextURL;
    private SearchPathHandler searchPathHandler;
    private MatcherHandler.LocatorHandler locatorHandler;
    private MatcherHandler.RedirectHandler redirectHandler;
    private DocumentationHandler documentationHandler;
    private ResourceMap resourceMap;

    public ResourceMapHandler(AbstractHandler parent) {
        super(parent, "rmap");
    }

    @Override
    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.documentationHandler) {
            this.getResourceMap().setDocumentation(this.documentationHandler.createDocumentation());
        } else {
            super.childPopped(child);
        }
    }

    @Override
    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ChildHandler ch;
        if ("searchPath".equals(localName)) {
            if (this.searchPathHandler == null) {
                this.searchPathHandler = new SearchPathHandler((AbstractHandler)this);
            }
            ch = this.searchPathHandler;
        } else if ("locator".equals(localName)) {
            if (this.locatorHandler == null) {
                this.locatorHandler = new MatcherHandler.LocatorHandler((AbstractHandler)this);
            }
            ch = this.locatorHandler;
        } else if ("redirect".equals(localName)) {
            if (this.redirectHandler == null) {
                this.redirectHandler = new MatcherHandler.RedirectHandler((AbstractHandler)this);
            }
            ch = this.redirectHandler;
        } else if ("documentation".equals(localName)) {
            if (this.documentationHandler == null) {
                this.documentationHandler = new DocumentationHandler((AbstractHandler)this);
            }
            ch = this.documentationHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        ((ResourceMapParser)this.getTopHandler()).setResourceMap(this.getResourceMap());
    }

    public ExpandingProperties<String> getProperties() {
        return (ExpandingProperties)this.getResourceMap().getProperties();
    }

    public ResourceMap getResourceMap() {
        if (this.resourceMap == null) {
            this.resourceMap = new ResourceMap(this.contextURL);
        }
        return this.resourceMap;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.resourceMap = null;
    }

    void setContextURL(URL contextURL) {
        this.contextURL = contextURL;
    }
}

