/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.git.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractSCCSVersionFinder;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.git.internal.RepositoryAccess;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionFinder
extends AbstractSCCSVersionFinder {
    private RepositoryAccess repoAccess;

    public VersionFinder(Provider provider, IComponentType ctype, NodeQuery query) throws CoreException {
        super(provider, ctype, query);
        Map props = provider.getProperties(query.getProperties());
        this.repoAccess = new RepositoryAccess(this.getProvider().getURI(props), props);
    }

    public synchronized void close() {
        if (this.repoAccess != null) {
            this.repoAccess.close();
            this.repoAccess = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkComponentExistence(VersionMatch versionMatch, IProgressMonitor monitor) throws CoreException {
        String string = this.repoAccess.getRepositoryPath();
        synchronized (string) {
            TreeWalk walk = this.repoAccess.getTreeWalk(versionMatch, null, monitor);
            try {
                boolean bl = walk.next();
                return bl;
            }
            catch (Exception e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
            finally {
                walk.release();
            }
        }
    }

    protected List<AbstractSCCSVersionFinder.RevisionEntry> getBranchesOrTags(boolean branches, IProgressMonitor monitor) throws CoreException {
        Repository repo = this.repoAccess.getRepository();
        String string = this.repoAccess.getRepositoryPath();
        synchronized (string) {
            ArrayList<AbstractSCCSVersionFinder.RevisionEntry> arrayList;
            RevWalk revWalk = new RevWalk(repo);
            try {
                ArrayList<AbstractSCCSVersionFinder.RevisionEntry> branchesOrTags = new ArrayList<AbstractSCCSVersionFinder.RevisionEntry>();
                String component = this.repoAccess.getComponent();
                for (Ref ref : repo.getAllRefs().values()) {
                    String name = ref.getName();
                    int lastSlash = name.lastIndexOf(47);
                    if (lastSlash < 0) continue;
                    RevObject obj = revWalk.parseAny((AnyObjectId)ref.getObjectId());
                    if (branches) {
                        String branch;
                        if (!(obj instanceof RevCommit) || "master".equals(branch = VersionFinder.getBranchName(name))) continue;
                        RevCommit c = (RevCommit)obj;
                        if (component != null && TreeWalk.forPath((Repository)repo, (String)component, (RevTree)c.getTree()) == null) continue;
                        branchesOrTags.add(new AbstractSCCSVersionFinder.RevisionEntry(branch, c.getAuthorIdent().getWhen(), 0L));
                        continue;
                    }
                    if (!(obj instanceof RevTag)) continue;
                    RevTag tag = (RevTag)obj;
                    if (component != null) {
                        while ((obj = ((RevTag)obj).getObject()) instanceof RevTag) {
                        }
                        if (!(obj instanceof RevCommit) || TreeWalk.forPath((Repository)repo, (String)component, (RevTree)((RevCommit)obj).getTree()) == null) continue;
                    }
                    branchesOrTags.add(new AbstractSCCSVersionFinder.RevisionEntry(tag.getTagName(), tag.getTaggerIdent().getWhen(), 0L));
                }
                arrayList = branchesOrTags;
            }
            catch (Throwable throwable) {
                try {
                    revWalk.release();
                    throw throwable;
                }
                catch (IOException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            revWalk.release();
            return arrayList;
        }
    }

    private static String getBranchName(String name) {
        int slash;
        boolean remote = name.startsWith("refs/remotes/");
        if (remote && (slash = name.indexOf(47, "refs/remotes/".length())) > -1) {
            return name.substring(slash + 1);
        }
        return Repository.shortenRefName((String)name);
    }

    protected AbstractSCCSVersionFinder.RevisionEntry getTrunk(IProgressMonitor monitor) throws CoreException {
        Repository repo = this.repoAccess.getRepository(null, monitor);
        RevWalk revWalk = new RevWalk(repo);
        try {
            String component = this.repoAccess.getComponent();
            Ref head = repo.getRef("HEAD");
            if (head == null) {
                return null;
            }
            RevCommit c = revWalk.parseCommit((AnyObjectId)head.getObjectId());
            if (component != null && TreeWalk.forPath((Repository)repo, (String)component, (RevTree)c.getTree()) == null) {
                return null;
            }
            AbstractSCCSVersionFinder.RevisionEntry revisionEntry = new AbstractSCCSVersionFinder.RevisionEntry(component, c.getAuthorIdent().getWhen(), 0L);
            return revisionEntry;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            revWalk.release();
        }
    }
}

