/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class AttachableProgressMonitor {
    private ProgressMonitor monitor;
    private List<IProgressMonitor> attachedMonitors = new ArrayList<IProgressMonitor>();

    public void attachProgressMonitor(IProgressMonitor toAttach) {
        if (toAttach == null) {
            throw new IllegalArgumentException("The given IProgressMonitor must not be null");
        }
        if (this.monitor != null) {
            this.monitor.attachProgressMonitor(this.monitor);
        }
        this.attachedMonitors.add(toAttach);
    }

    public IProgressMonitor wrap(IProgressMonitor mainProgressMonitor) {
        if (mainProgressMonitor == null) {
            throw new IllegalArgumentException("The given IProgressMonitor must not be null");
        }
        if (this.monitor != null) {
            throw new RuntimeException("Only one ProgressMonitor can be wrapped at a time");
        }
        this.monitor = new ProgressMonitor(mainProgressMonitor);
        for (IProgressMonitor attachedMonitor : this.attachedMonitors) {
            this.monitor.attachProgressMonitor(attachedMonitor);
        }
        return this.monitor;
    }

    private class ProgressMonitor
    implements IProgressMonitor {
        private int totalWork;
        private int ticks;
        private String task;
        private String subTask;
        private IProgressMonitor mainProgressMonitor;

        public ProgressMonitor(IProgressMonitor mainprogressMonitor) {
            this.mainProgressMonitor = mainprogressMonitor;
        }

        public void beginTask(String name, int work) {
            this.totalWork = work;
            this.task = name;
            this.mainProgressMonitor.beginTask(name, work);
            for (IProgressMonitor attachedMonitor : AttachableProgressMonitor.this.attachedMonitors) {
                attachedMonitor.beginTask(name, work);
            }
        }

        public void done() {
            this.mainProgressMonitor.done();
            for (IProgressMonitor attachedMonitor : AttachableProgressMonitor.this.attachedMonitors) {
                attachedMonitor.done();
            }
        }

        public void internalWorked(double work) {
            this.mainProgressMonitor.internalWorked(work);
            for (IProgressMonitor attachedMonitor : AttachableProgressMonitor.this.attachedMonitors) {
                attachedMonitor.internalWorked(work);
            }
        }

        public boolean isCanceled() {
            return this.mainProgressMonitor.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.mainProgressMonitor.setCanceled(value);
            for (IProgressMonitor attachedMonitor : AttachableProgressMonitor.this.attachedMonitors) {
                attachedMonitor.setCanceled(value);
            }
        }

        public void setTaskName(String name) {
            this.mainProgressMonitor.setTaskName(name);
            for (IProgressMonitor attachedMonitor : AttachableProgressMonitor.this.attachedMonitors) {
                attachedMonitor.setTaskName(name);
            }
        }

        public void subTask(String name) {
            this.subTask = name;
            this.mainProgressMonitor.subTask(name);
            for (IProgressMonitor attachedMonitor : AttachableProgressMonitor.this.attachedMonitors) {
                attachedMonitor.subTask(name);
            }
        }

        public void worked(int work) {
            this.ticks += work;
            this.mainProgressMonitor.worked(work);
            for (IProgressMonitor attachedMonitor : AttachableProgressMonitor.this.attachedMonitors) {
                attachedMonitor.worked(work);
            }
        }

        void attachProgressMonitor(IProgressMonitor toAttach) {
            if (this.task != null) {
                toAttach.beginTask(this.task, this.totalWork);
                toAttach.worked(this.ticks);
            }
            if (this.subTask != null) {
                toAttach.subTask(this.subTask);
            }
        }
    }
}

