/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.GitURI;
import org.eclipse.egit.core.internal.ProjectReferenceImporter;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.TeamException;

public final class GitProjectSetCapability
extends ProjectSetCapability {
    private static final String VERSION = "1.0";

    public String[] asReference(IProject[] projects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        String[] references = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            references[i] = this.asReference(projects[i]);
            ++i;
        }
        return references;
    }

    private String asReference(IProject project) throws TeamException {
        String branch;
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
        try {
            branch = mapping.getRepository().getBranch();
        }
        catch (IOException iOException) {
            throw new TeamException(NLS.bind((String)CoreText.GitProjectSetCapability_ExportCouldNotGetBranch, (Object)project.getName()));
        }
        StoredConfig config = mapping.getRepository().getConfig();
        String remote = config.getString("branch", branch, "remote");
        String url = config.getString("remote", remote, "url");
        if (url == null) {
            throw new TeamException(NLS.bind((String)CoreText.GitProjectSetCapability_ExportNoRemote, (Object)project.getName()));
        }
        String projectPath = mapping.getRepoRelativePath((IResource)project);
        if (projectPath.equals("")) {
            projectPath = ".";
        }
        return this.asReference(url, branch, projectPath);
    }

    private String asReference(String url, String branch, String projectPath) {
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION);
        sb.append(",");
        sb.append(url);
        sb.append(",");
        sb.append(branch);
        sb.append(",");
        sb.append(projectPath);
        return sb.toString();
    }

    public IProject[] addToWorkspace(final String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        final ArrayList importedProjects = new ArrayList();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor wsOpMonitor) throws CoreException {
                    ProjectReferenceImporter importer = new ProjectReferenceImporter(referenceStrings);
                    List<IProject> p = importer.run(wsOpMonitor);
                    importedProjects.addAll(p);
                }
            }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, monitor);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
        IProject[] result = importedProjects.toArray(new IProject[importedProjects.size()]);
        return result;
    }

    public String asReference(URI uri, String projectName) {
        GitURI gitURI = new GitURI(uri);
        return this.asReference(gitURI.getRepository().toString(), gitURI.getTag(), gitURI.getPath().toString());
    }
}

