/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize.dto;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSynchronizeDataSet
implements Iterable<GitSynchronizeData> {
    private boolean containsFolderLevelSynchronizationRequest = false;
    private final Set<GitSynchronizeData> gsdSet;
    private final Map<String, GitSynchronizeData> projectMapping;
    private final boolean forceFetch;

    public GitSynchronizeDataSet() {
        this(false);
    }

    public GitSynchronizeDataSet(boolean forceFetch) {
        this.forceFetch = forceFetch;
        this.gsdSet = new HashSet<GitSynchronizeData>();
        this.projectMapping = new HashMap<String, GitSynchronizeData>();
    }

    public GitSynchronizeDataSet(GitSynchronizeData data) {
        this();
        this.add(data);
    }

    public void add(GitSynchronizeData data) {
        this.gsdSet.add(data);
        if (data.getIncludedPaths() != null && data.getIncludedPaths().size() > 0) {
            this.containsFolderLevelSynchronizationRequest = true;
        }
        for (IProject proj : data.getProjects()) {
            this.projectMapping.put(proj.getName(), data);
        }
    }

    public boolean contains(IProject project) {
        return this.projectMapping.containsKey(project.getName());
    }

    public boolean containsFolderLevelSynchronizationRequest() {
        return this.containsFolderLevelSynchronizationRequest;
    }

    public int size() {
        return this.gsdSet.size();
    }

    public GitSynchronizeData getData(String projectName) {
        return this.projectMapping.get(projectName);
    }

    public GitSynchronizeData getData(IProject project) {
        return this.projectMapping.get(project.getName());
    }

    @Override
    public Iterator<GitSynchronizeData> iterator() {
        return this.gsdSet.iterator();
    }

    public IProject[] getAllProjects() {
        HashSet<IProject> resource = new HashSet<IProject>();
        for (GitSynchronizeData data : this.gsdSet) {
            resource.addAll(data.getProjects());
        }
        return resource.toArray(new IProject[resource.size()]);
    }

    public boolean forceFetch() {
        return this.forceFetch;
    }

    public void dispose() {
        if (this.projectMapping != null) {
            this.projectMapping.clear();
        }
        if (this.gsdSet != null) {
            for (GitSynchronizeData gsd : this.gsdSet) {
                gsd.dispose();
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (GitSynchronizeData data : this.gsdSet) {
            builder.append(data.getRepository().getWorkTree());
            builder.append(" ");
        }
        return builder.toString();
    }
}

