/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.StringUtils;

public final class RawParseUtils {
    private static final byte[] digits10;
    private static final byte[] digits16;
    private static final byte[] footerLineKeyChars;
    private static final Map<String, Charset> encodingAliases;
    private static final byte[] base10byte;

    public static final int match(byte[] b, int ptr, byte[] src) {
        if (ptr + src.length > b.length) {
            return -1;
        }
        int i = 0;
        while (i < src.length) {
            if (b[ptr] != src[i]) {
                return -1;
            }
            ++i;
            ++ptr;
        }
        return ptr;
    }

    public static int formatBase10(byte[] b, int o, int value) {
        boolean isneg;
        if (value == 0) {
            b[--o] = 48;
            return o;
        }
        boolean bl = isneg = value < 0;
        if (isneg) {
            value = -value;
        }
        while (value != 0) {
            b[--o] = base10byte[value % 10];
            value /= 10;
        }
        if (isneg) {
            b[--o] = 45;
        }
        return o;
    }

    public static final int parseBase10(byte[] b, int ptr, MutableInteger ptrResult) {
        int r = 0;
        int sign = 0;
        try {
            byte v;
            int sz = b.length;
            while (ptr < sz && b[ptr] == 32) {
                ++ptr;
            }
            if (ptr >= sz) {
                return 0;
            }
            switch (b[ptr]) {
                case 45: {
                    sign = -1;
                    ++ptr;
                    break;
                }
                case 43: {
                    ++ptr;
                }
            }
            while (ptr < sz && (v = digits10[b[ptr]]) >= 0) {
                r = r * 10 + v;
                ++ptr;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (ptrResult != null) {
            ptrResult.value = ptr;
        }
        return sign < 0 ? -r : r;
    }

    public static final long parseLongBase10(byte[] b, int ptr, MutableInteger ptrResult) {
        long r = 0L;
        int sign = 0;
        try {
            byte v;
            int sz = b.length;
            while (ptr < sz && b[ptr] == 32) {
                ++ptr;
            }
            if (ptr >= sz) {
                return 0L;
            }
            switch (b[ptr]) {
                case 45: {
                    sign = -1;
                    ++ptr;
                    break;
                }
                case 43: {
                    ++ptr;
                }
            }
            while (ptr < sz && (v = digits10[b[ptr]]) >= 0) {
                r = r * 10L + (long)v;
                ++ptr;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (ptrResult != null) {
            ptrResult.value = ptr;
        }
        return sign < 0 ? -r : r;
    }

    public static final int parseHexInt16(byte[] bs, int p) {
        int r = digits16[bs[p]] << 4;
        r |= digits16[bs[p + 1]];
        r <<= 4;
        r |= digits16[bs[p + 2]];
        r <<= 4;
        if ((r |= digits16[bs[p + 3]]) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r;
    }

    public static final int parseHexInt32(byte[] bs, int p) {
        int r = digits16[bs[p]] << 4;
        r |= digits16[bs[p + 1]];
        r <<= 4;
        r |= digits16[bs[p + 2]];
        r <<= 4;
        r |= digits16[bs[p + 3]];
        r <<= 4;
        r |= digits16[bs[p + 4]];
        r <<= 4;
        r |= digits16[bs[p + 5]];
        r <<= 4;
        byte last = digits16[bs[p + 7]];
        if ((r |= digits16[bs[p + 6]]) < 0 || last < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r << 4 | last;
    }

    public static final int parseHexInt4(byte digit) {
        byte r = digits16[digit];
        if (r < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r;
    }

    public static final int parseTimeZoneOffset(byte[] b, int ptr) {
        int v = RawParseUtils.parseBase10(b, ptr, null);
        int tzMins = v % 100;
        int tzHours = v / 100;
        return tzHours * 60 + tzMins;
    }

    public static final int next(byte[] b, int ptr, char chrA) {
        int sz = b.length;
        while (ptr < sz) {
            if (b[ptr++] != chrA) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int nextLF(byte[] b, int ptr) {
        return RawParseUtils.next(b, ptr, '\n');
    }

    public static final int nextLF(byte[] b, int ptr, char chrA) {
        int sz = b.length;
        while (ptr < sz) {
            byte c;
            if ((c = b[ptr++]) != chrA && c != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int prev(byte[] b, int ptr, char chrA) {
        if (ptr == b.length) {
            --ptr;
        }
        while (ptr >= 0) {
            if (b[ptr--] != chrA) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int prevLF(byte[] b, int ptr) {
        return RawParseUtils.prev(b, ptr, '\n');
    }

    public static final int prevLF(byte[] b, int ptr, char chrA) {
        if (ptr == b.length) {
            --ptr;
        }
        while (ptr >= 0) {
            byte c;
            if ((c = b[ptr--]) != chrA && c != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static final IntList lineMap(byte[] buf, int ptr, int end) {
        IntList map = new IntList((end - ptr) / 36);
        map.fillTo(1, Integer.MIN_VALUE);
        while (ptr < end) {
            map.add(ptr);
            ptr = RawParseUtils.nextLF(buf, ptr);
        }
        map.add(end);
        return map;
    }

    public static final int author(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.match(b, ptr, ObjectChecker.author);
    }

    public static final int committer(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        if (ptr < sz && b[ptr] == 97) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        return RawParseUtils.match(b, ptr, ObjectChecker.committer);
    }

    public static final int tagger(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 48;
        }
        while (ptr < sz) {
            if (b[ptr] == 10) {
                return -1;
            }
            int m = RawParseUtils.match(b, ptr, ObjectChecker.tagger);
            if (m >= 0) {
                return m;
            }
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        return -1;
    }

    public static final int encoding(byte[] b, int ptr) {
        int sz = b.length;
        while (ptr < sz) {
            if (b[ptr] == 10) {
                return -1;
            }
            if (b[ptr] == 101) break;
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        return RawParseUtils.match(b, ptr, ObjectChecker.encoding);
    }

    public static Charset parseEncoding(byte[] b) {
        int enc = RawParseUtils.encoding(b, 0);
        if (enc < 0) {
            return Constants.CHARSET;
        }
        int lf = RawParseUtils.nextLF(b, enc);
        String decoded = RawParseUtils.decode(Constants.CHARSET, b, enc, lf - 1);
        try {
            return Charset.forName(decoded);
        }
        catch (IllegalCharsetNameException badName) {
            Charset aliased = RawParseUtils.charsetForAlias(decoded);
            if (aliased != null) {
                return aliased;
            }
            throw badName;
        }
        catch (UnsupportedCharsetException badName) {
            Charset aliased = RawParseUtils.charsetForAlias(decoded);
            if (aliased != null) {
                return aliased;
            }
            throw badName;
        }
    }

    public static PersonIdent parsePersonIdent(String in) {
        return RawParseUtils.parsePersonIdent(Constants.encode(in), 0);
    }

    public static PersonIdent parsePersonIdent(byte[] raw, int nameB) {
        Charset cs = RawParseUtils.parseEncoding(raw);
        int emailB = RawParseUtils.nextLF(raw, nameB, '<');
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        if (emailB >= raw.length || raw[emailB] == 10 || emailE >= raw.length - 1 && raw[emailE - 1] != 62) {
            return null;
        }
        int nameEnd = emailB - 2 >= nameB && raw[emailB - 2] == 32 ? emailB - 2 : emailB - 1;
        String name = RawParseUtils.decode(cs, raw, nameB, nameEnd);
        String email = RawParseUtils.decode(cs, raw, emailB, emailE - 1);
        int tzBegin = RawParseUtils.lastIndexOfTrim(raw, ' ', RawParseUtils.nextLF(raw, emailE - 1) - 2) + 1;
        if (tzBegin <= emailE) {
            return new PersonIdent(name, email, 0L, 0);
        }
        int whenBegin = Math.max(emailE, RawParseUtils.lastIndexOfTrim(raw, ' ', tzBegin - 1) + 1);
        if (whenBegin >= tzBegin - 1) {
            return new PersonIdent(name, email, 0L, 0);
        }
        long when = RawParseUtils.parseLongBase10(raw, whenBegin, null);
        int tz = RawParseUtils.parseTimeZoneOffset(raw, tzBegin);
        return new PersonIdent(name, email, when * 1000L, tz);
    }

    public static PersonIdent parsePersonIdentOnly(byte[] raw, int nameB) {
        int tz;
        long when;
        int stop = RawParseUtils.nextLF(raw, nameB);
        int emailB = RawParseUtils.nextLF(raw, nameB, '<');
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        String email = emailE < stop ? RawParseUtils.decode(raw, emailB, emailE - 1) : "invalid";
        String name = emailB < stop ? RawParseUtils.decode(raw, nameB, emailB - 2) : RawParseUtils.decode(raw, nameB, stop);
        MutableInteger ptrout = new MutableInteger();
        if (emailE < stop) {
            when = RawParseUtils.parseLongBase10(raw, emailE + 1, ptrout);
            tz = RawParseUtils.parseTimeZoneOffset(raw, ptrout.value);
        } else {
            when = 0L;
            tz = 0;
        }
        return new PersonIdent(name, email, when * 1000L, tz);
    }

    public static int endOfFooterLineKey(byte[] raw, int ptr) {
        try {
            while (true) {
                byte c;
                if (footerLineKeyChars[c = raw[ptr]] == 0) {
                    if (c == 58) {
                        return ptr;
                    }
                    return -1;
                }
                ++ptr;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    public static String decode(byte[] buffer) {
        return RawParseUtils.decode(buffer, 0, buffer.length);
    }

    public static String decode(byte[] buffer, int start, int end) {
        return RawParseUtils.decode(Constants.CHARSET, buffer, start, end);
    }

    public static String decode(Charset cs, byte[] buffer) {
        return RawParseUtils.decode(cs, buffer, 0, buffer.length);
    }

    public static String decode(Charset cs, byte[] buffer, int start, int end) {
        try {
            return RawParseUtils.decodeNoFallback(cs, buffer, start, end);
        }
        catch (CharacterCodingException e) {
            return RawParseUtils.extractBinaryString(buffer, start, end);
        }
    }

    public static String decodeNoFallback(Charset cs, byte[] buffer, int start, int end) throws CharacterCodingException {
        ByteBuffer b = ByteBuffer.wrap(buffer, start, end - start);
        b.mark();
        try {
            return RawParseUtils.decode(b, Constants.CHARSET);
        }
        catch (CharacterCodingException e) {
            Charset defcs;
            b.reset();
            if (!cs.equals(Constants.CHARSET)) {
                try {
                    return RawParseUtils.decode(b, cs);
                }
                catch (CharacterCodingException e2) {
                    b.reset();
                }
            }
            if (!(defcs = Charset.defaultCharset()).equals(cs) && !defcs.equals(Constants.CHARSET)) {
                try {
                    return RawParseUtils.decode(b, defcs);
                }
                catch (CharacterCodingException e3) {
                    b.reset();
                }
            }
            throw new CharacterCodingException();
        }
    }

    public static String extractBinaryString(byte[] buffer, int start, int end) {
        StringBuilder r = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            r.append((char)(buffer[i] & 0xFF));
        }
        return r.toString();
    }

    private static String decode(ByteBuffer b, Charset charset) throws CharacterCodingException {
        CharsetDecoder d = charset.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPORT);
        d.onUnmappableCharacter(CodingErrorAction.REPORT);
        return d.decode(b).toString();
    }

    public static final int commitMessage(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.tagMessage(b, ptr);
    }

    public static final int tagMessage(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 48;
        }
        while (ptr < sz && b[ptr] != 10) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        if (ptr < sz && b[ptr] == 10) {
            return ptr + 1;
        }
        return -1;
    }

    public static final int endOfParagraph(byte[] b, int start) {
        int ptr = start;
        int sz = b.length;
        while (ptr < sz && b[ptr] != 10) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        while (0 < ptr && start < ptr && b[ptr - 1] == 10) {
            --ptr;
        }
        return ptr;
    }

    private static int lastIndexOfTrim(byte[] raw, char ch, int pos) {
        while (pos >= 0 && raw[pos] == 32) {
            --pos;
        }
        while (pos >= 0 && raw[pos] != ch) {
            --pos;
        }
        return pos;
    }

    private static Charset charsetForAlias(String name) {
        return encodingAliases.get(StringUtils.toLowerCase(name));
    }

    private RawParseUtils() {
    }

    static {
        int i;
        encodingAliases = new HashMap<String, Charset>();
        encodingAliases.put("latin-1", Charset.forName("ISO-8859-1"));
        digits10 = new byte[58];
        Arrays.fill(digits10, (byte)-1);
        for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
            RawParseUtils.digits10[i] = (byte)(i - 48);
        }
        digits16 = new byte[103];
        Arrays.fill(digits16, (byte)-1);
        for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
            RawParseUtils.digits16[i] = (byte)(i - 48);
        }
        for (i = 97; i <= 102; i = (int)((char)(i + 1))) {
            RawParseUtils.digits16[i] = (byte)(i - 97 + 10);
        }
        for (i = 65; i <= 70; i = (int)((char)(i + 1))) {
            RawParseUtils.digits16[i] = (byte)(i - 65 + 10);
        }
        footerLineKeyChars = new byte[123];
        RawParseUtils.footerLineKeyChars[45] = 1;
        for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
            RawParseUtils.footerLineKeyChars[i] = 1;
        }
        for (i = 65; i <= 90; i = (int)((char)(i + 1))) {
            RawParseUtils.footerLineKeyChars[i] = 1;
        }
        for (i = 97; i <= 122; i = (int)((char)(i + 1))) {
            RawParseUtils.footerLineKeyChars[i] = 1;
        }
        base10byte = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    }
}

