/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import com.mountainminds.eclemma.core.ICorePreferences;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScopeFilter {
    private final ICorePreferences preferences;

    public DefaultScopeFilter(ICorePreferences preferences) {
        this.preferences = preferences;
    }

    public Set<IPackageFragmentRoot> filter(Set<IPackageFragmentRoot> scope, ILaunchConfiguration configuration) throws CoreException {
        String filter;
        HashSet<IPackageFragmentRoot> filtered = new HashSet<IPackageFragmentRoot>(scope);
        if (this.preferences.getDefaultScopeSourceFoldersOnly()) {
            this.sourceFoldersOnly(filtered);
        }
        if (this.preferences.getDefaultScopeSameProjectOnly()) {
            this.sameProjectOnly(filtered, configuration);
        }
        if ((filter = this.preferences.getDefaultScopeFilter()) != null && filter.length() > 0) {
            this.matchingPathsOnly(filtered, filter);
        }
        return filtered;
    }

    private void sourceFoldersOnly(Collection<IPackageFragmentRoot> filtered) throws JavaModelException {
        Iterator<IPackageFragmentRoot> i = filtered.iterator();
        while (i.hasNext()) {
            if (i.next().getKind() == 1) continue;
            i.remove();
        }
    }

    private void sameProjectOnly(Collection<IPackageFragmentRoot> filtered, ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        if (javaProject != null) {
            Iterator<IPackageFragmentRoot> i = filtered.iterator();
            while (i.hasNext()) {
                if (javaProject.equals(i.next().getJavaProject())) continue;
                i.remove();
            }
        }
    }

    private void matchingPathsOnly(Collection<IPackageFragmentRoot> filtered, String filter) {
        String[] matchStrings = filter.split(",");
        Iterator<IPackageFragmentRoot> i = filtered.iterator();
        while (i.hasNext()) {
            if (this.isPathMatch(i.next(), matchStrings)) continue;
            i.remove();
        }
    }

    private boolean isPathMatch(IPackageFragmentRoot root, String[] matchStrings) {
        String path = root.getPath().toString();
        String[] stringArray = matchStrings;
        int n = matchStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String match = stringArray[n2];
            if (path.indexOf(match) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

