/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.TargetPlatform;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Build
extends WorkspaceCommand {
    private static final OptionDescriptor cleanDescriptor = new OptionDescriptor('c', "clean", 1);
    private static final OptionDescriptor thoroughDescriptor = new OptionDescriptor('t', "thorough", 1);
    private static final OptionDescriptor logfileDescriptor = new OptionDescriptor('l', "logfile", 3);
    private static final OptionDescriptor continueOnErrorDescriptor = new OptionDescriptor('C', "continueonerror", 1);
    private static final int MAX_INCREMENTAL_RETRY_COUNT = 3;
    private static final int SUCCEEDED = 0;
    private static final int FAILED = 1;
    private boolean clean = false;
    private boolean thorough = false;
    private File logFile = null;
    private boolean continueOnError = false;

    public static IMarker[] build(IProgressMonitor monitor, boolean clean) throws Exception {
        return Build.build(monitor, clean, false);
    }

    public static IMarker[] build(IProgressMonitor monitor, boolean clean, boolean thorough) throws Exception {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsRoot = ws.getRoot();
        IProject[] projs = wsRoot.getProjects();
        try {
            IMarker[] markers;
            int top;
            monitor.beginTask(null, projs.length * (clean ? 9 : 7));
            wsRoot.refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)projs.length));
            if (clean || thorough) {
                ws.build(15, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)(projs.length * 2)));
            }
            if (thorough) {
                TargetPlatform.getInstance().refresh();
            }
            ws.build(6, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)(projs.length * 5)));
            for (int retries = 0; (top = (markers = wsRoot.findMarkers("org.eclipse.core.resources.problemmarker", true, 2)).length) != 0 && retries < 3; ++retries) {
                boolean retryNeeded = false;
                int idx = 0;
                while (idx < top) {
                    if (markers[idx].getAttribute("severity", 0) == 2) {
                        retryNeeded = true;
                        break;
                    }
                    ++idx;
                }
                if (!retryNeeded) break;
                int buildType = thorough && retries == 0 ? 6 : 10;
                ws.build(buildType, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)projs.length));
            }
            Arrays.sort(markers, new Comparator<IMarker>(){

                @Override
                public int compare(IMarker a, IMarker b) {
                    try {
                        long diff = a.getCreationTime() - b.getCreationTime();
                        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
                    }
                    catch (CoreException e) {
                        return 0;
                    }
                }
            });
            try {
                WorkspaceInfo.forceRefreshOnAll(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)projs.length));
            }
            catch (Exception exception) {
                // empty catch block
            }
            IMarker[] iMarkerArray = markers;
            return iMarkerArray;
        }
        finally {
            monitor.done();
        }
    }

    public static String formatMarkerMessage(String type, IMarker problem) {
        StringBuilder bld = new StringBuilder();
        bld.append(type);
        bld.append(": file ");
        bld.append(problem.getResource().getLocation().toOSString());
        int line = problem.getAttribute("lineNumber", -1);
        if (line > 0) {
            bld.append(", line ");
            bld.append(line);
        }
        bld.append(": ");
        bld.append(problem.getAttribute("message", ""));
        return bld.toString();
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(cleanDescriptor);
        appendHere.add(thoroughDescriptor);
        appendHere.add(continueOnErrorDescriptor);
        appendHere.add(logfileDescriptor);
        super.getOptionDescriptors(appendHere);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(cleanDescriptor)) {
            this.clean = true;
        } else if (option.is(thoroughDescriptor)) {
            this.thorough = true;
        } else if (option.is(continueOnErrorDescriptor)) {
            this.continueOnError = true;
        } else if (option.is(logfileDescriptor)) {
            this.logFile = new File(option.getValue());
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length > 0) {
            throw new UsageException(Messages.Too_many_arguments);
        }
    }

    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        long start = System.currentTimeMillis();
        IMarker[] problems = Build.build(monitor, this.clean, this.thorough);
        long seconds = (System.currentTimeMillis() - start) / 1000L;
        PrintStream log = null;
        if (this.logFile != null) {
            log = new PrintStream(this.logFile);
        }
        try {
            int errors = 0;
            int warnings = 0;
            int infos = 0;
            IMarker[] iMarkerArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker problem = iMarkerArray[n2];
                PrintStream console = null;
                String message = null;
                switch (problem.getAttribute("severity", 0)) {
                    case 2: {
                        ++errors;
                        console = System.err;
                        message = Build.formatMarkerMessage("Error", problem);
                        break;
                    }
                    case 1: {
                        ++warnings;
                        console = System.err;
                        message = Build.formatMarkerMessage("Warning", problem);
                        break;
                    }
                    case 0: {
                        ++infos;
                        console = System.out;
                        message = Build.formatMarkerMessage("Info", problem);
                    }
                }
                if (message != null) {
                    if (console != null) {
                        console.println(message);
                    }
                    if (log != null) {
                        log.println(message);
                    }
                }
                ++n2;
            }
            System.out.println("Errors: " + errors);
            System.out.println("Warnings: " + warnings);
            System.out.println("Infos: " + infos);
            int exitValue = errors == 0 ? 0 : 1;
            System.out.println("Build " + (exitValue == 1 ? "failed" : "succeeded") + " after " + seconds + " seconds.");
            if (exitValue == 1 && this.continueOnError) {
                System.out.println("Build continues anyway...");
            }
            int n3 = this.continueOnError ? 0 : exitValue;
            return n3;
        }
        finally {
            if (log != null) {
                log.close();
            }
        }
    }
}

