/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.cspecext.builder.AlterAttributeBuilder;
import org.eclipse.buckminster.core.cspecext.builder.AlterDependencyBuilder;
import org.eclipse.buckminster.core.cspecext.model.AlterAttribute;
import org.eclipse.buckminster.core.cspecext.model.AlterDependency;
import org.eclipse.buckminster.core.cspecext.model.CSpecExtension;
import org.eclipse.core.runtime.CoreException;

public class AlterCSpecBuilder {
    private final CSpecBuilder baseBuilder;
    private final HashSet<String> removedDependencies = new HashSet();
    private final HashSet<String> removedAttributes = new HashSet();
    private final Map<String, String> renamedAttributes = new HashMap<String, String>();
    private final Map<String, AlterAttributeBuilder> alteredAttributes = new HashMap<String, AlterAttributeBuilder>();
    private final Map<String, AlterDependencyBuilder> alteredDependencies = new HashMap<String, AlterDependencyBuilder>();
    private String name;

    public AlterCSpecBuilder(CSpecBuilder baseBuilder) {
        this.baseBuilder = baseBuilder;
    }

    public void addAlterAttribute(AlterAttributeBuilder value) {
        this.alteredAttributes.put(value.getName(), value);
    }

    public void addAlterDependency(AlterDependencyBuilder value) {
        this.alteredDependencies.put(value.getName(), value);
    }

    public void addRemoveAttribute(String key) {
        this.removedAttributes.add(key);
    }

    public void addRemoveDependency(String key) {
        this.removedDependencies.add(key);
    }

    public void addRenameAttribute(String oldName, String newName) {
        this.renamedAttributes.put(oldName, newName);
    }

    public void clear() {
        this.removedAttributes.clear();
        this.renamedAttributes.clear();
        this.alteredAttributes.clear();
        this.removedDependencies.clear();
        this.alteredDependencies.clear();
        this.baseBuilder.clear();
        this.name = null;
    }

    public CSpecExtension createAlteredCSpec() throws CoreException {
        HashMap<String, AlterAttribute<? extends TopLevelAttribute>> alterAttributes = new HashMap<String, AlterAttribute<? extends TopLevelAttribute>>(this.alteredAttributes.size());
        for (Map.Entry<String, AlterAttributeBuilder> entry : this.alteredAttributes.entrySet()) {
            alterAttributes.put(entry.getKey(), entry.getValue().createAlterAttribute());
        }
        HashMap<String, AlterDependency> alterDependencies = new HashMap<String, AlterDependency>(this.alteredDependencies.size());
        for (Map.Entry<String, AlterDependencyBuilder> entry : this.alteredDependencies.entrySet()) {
            alterDependencies.put(entry.getKey(), entry.getValue().createAlterDependency());
        }
        return new CSpecExtension(this.baseBuilder.createCSpec(), this.removedDependencies, alterDependencies, this.removedAttributes, this.renamedAttributes, alterAttributes);
    }

    public CSpecBuilder getBaseBuilder() {
        return this.baseBuilder;
    }

    public final String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

