/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalizedException
extends CoreException {
    private final String defaultMessageFormat;
    private final Object[] arguments;

    private static String getLocalizedFormat(Class<?> c, String defaultMessageFormat) {
        CorePlugin core = CorePlugin.getDefault();
        if (core == null) {
            return defaultMessageFormat;
        }
        ResourceBundle bundle = core.getResourceBundle();
        if (bundle == null) {
            return defaultMessageFormat;
        }
        int pkgLen = 0;
        Package p = c.getPackage();
        if (p != null && (pkgLen = p.getName().length()) > 0) {
            ++pkgLen;
        }
        String name = c.getName();
        if (pkgLen > 0) {
            name = name.substring(pkgLen);
        }
        try {
            return bundle.getString(name);
        }
        catch (MissingResourceException e) {
            return defaultMessageFormat;
        }
    }

    protected LocalizedException(String defaultMessageFormat, Object ... args) {
        this(null, defaultMessageFormat, args);
    }

    protected LocalizedException(Throwable cause, String defaultMessageFormat, Object ... args) {
        super(BuckminsterException.createStatus((String)defaultMessageFormat, (Object[])args));
        this.defaultMessageFormat = defaultMessageFormat;
        this.arguments = args;
    }

    public String getLocalizedMessage() {
        return String.format(LocalizedException.getLocalizedFormat(((Object)((Object)this)).getClass(), this.defaultMessageFormat), this.arguments);
    }
}

