/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.actor;

import java.io.PrintStream;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SimulationActor
extends AbstractActor {
    public static final String ID = "simulation";
    public static final String TICKS_PROPERTY = "ticks";
    public static final int TICKS_MIN = 0;
    public static final int TICKS_MAX = 60000;
    public static final int TICKS_DEFAULT = 3000;
    private int ticks = 3000;

    protected void internalInit() throws CoreException {
        String sTicks = this.getActorProperty(TICKS_PROPERTY);
        if (sTicks != null) {
            int tcks = Integer.parseInt(sTicks);
            if (tcks < 0) {
                tcks = 0;
            } else if (tcks > 60000) {
                tcks = 60000;
            }
            this.ticks = tcks;
        }
    }

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        int tcks = this.ticks;
        try {
            monitor.beginTask(null, tcks);
            PrintStream ps = ctx.getOutputStream();
            ps.print(NLS.bind((String)Messages.Simulation_0_working_for_1_ticks, (Object)ctx.getAction().getName(), (Object)tcks));
            int i = 0;
            while (i < this.ticks) {
                Thread.sleep(1L);
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                ++i;
            }
            ps.println(Messages.Finished_working);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            monitor.done();
        }
    }
}

