/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.ITargetPlatform;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.TargetPlatform;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.materializer.AbstractMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.IMaterializationNode;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.P2ReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2Materializer
extends AbstractMaterializer {
    private static final String CLASSIFIER_OSGI_BUNDLE = "osgi.bundle";
    private static final String CLASSIFIER_ORG_ECLIPSE_UPDATE_FEATURE = "org.eclipse.update.feature";
    private static final String PROP_ARTIFACT_FOLDER = "artifact.folder";
    private static final String PROP_BUNDLE_POOL = "org.eclipse.buckminster.core.bundle.pool";

    public static URI cleanURIFromImportType(URI repoLocation) {
        Map props = URLUtils.queryAsParameters((String)repoLocation.getQuery());
        if (props.remove("importType") != null) {
            try {
                repoLocation = new URI(repoLocation.getScheme(), repoLocation.getAuthority(), repoLocation.getPath(), URLUtils.encodeFromQueryPairs((Map)props), repoLocation.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return repoLocation;
    }

    static IArtifactRepository getArtifactRepository(IArtifactRepositoryManager manager, URI repoLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        try {
            return manager.loadRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
        }
        catch (ProvisionException e) {
            return manager.refreshRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
        }
    }

    static IMetadataRepository getMetadataRepository(IMetadataRepositoryManager manager, URI repoLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        try {
            return manager.loadRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
        }
        catch (ProvisionException e) {
            return manager.refreshRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
        }
    }

    @Override
    public boolean canWorkInParallel() {
        return false;
    }

    @Override
    public String getMaterializerRootDir() throws CoreException {
        ITargetPlatform tp = TargetPlatform.getInstance();
        File location = tp.getLocation();
        if (location == null && (location = tp.getDefaultPlatformLocation(true)) == null) {
            throw BuckminsterException.fromMessage((String)Messages.Unable_to_determine_platform_install_location, (Object[])new Object[0]);
        }
        return location.getAbsolutePath();
    }

    protected File getRuntimeRepository() {
        File folder;
        String bundlePool = System.getProperty(PROP_BUNDLE_POOL);
        if (bundlePool != null) {
            return new File(bundlePool);
        }
        String sysPath = System.getProperty("osgi.syspath");
        if (sysPath != null && (folder = new File(sysPath).getParentFile()).isDirectory()) {
            return folder;
        }
        return FileUtils.getFile(Platform.getInstallLocation().getURL());
    }

    @Override
    public List<Materialization> materialize(List<Resolution> resolutions, MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        HashMap<File, ArrayList<Resolution>> resPerLocation = new HashMap<File, ArrayList<Resolution>>();
        MaterializationSpec mspec = context.getMaterializationSpec();
        IPath installRoot = mspec.getInstallLocation();
        installRoot = installRoot == null ? Path.fromOSString((String)this.getMaterializerRootDir()) : Path.fromOSString((String)ExpandingProperties.expand(context, installRoot.toOSString(), 0));
        for (Resolution res : resolutions) {
            File locationKey;
            ArrayList<Resolution> rss;
            IMaterializationNode node = mspec.getMatchingNode(res);
            IPath installLocation = null;
            Map<String, ? extends Object> props = context.getProperties(res);
            if (node != null && (installLocation = node.getInstallLocation()) != null && !(installLocation = Path.fromOSString((String)ExpandingProperties.expand(props, installLocation.toOSString(), 0))).isAbsolute()) {
                installLocation = installRoot.append(installLocation);
            }
            if (installLocation == null) {
                installLocation = installRoot;
            }
            if ((rss = (ArrayList<Resolution>)resPerLocation.get(locationKey = installLocation.toFile())) == null) {
                rss = new ArrayList<Resolution>();
                resPerLocation.put(locationKey, rss);
            }
            rss.add(res);
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + resPerLocation.size() * 1000));
        IProvisioningAgent p2Agent = CorePlugin.getDefault().getResolverAgent();
        IMetadataRepositoryManager mdrManager = (IMetadataRepositoryManager)p2Agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IArtifactRepositoryManager arManager = (IArtifactRepositoryManager)p2Agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        IEngine engine = (IEngine)p2Agent.getService(IEngine.SERVICE_NAME);
        IProfileRegistry registry = (IProfileRegistry)p2Agent.getService(IProfileRegistry.SERVICE_NAME);
        HashMap<URI, IMetadataRepository> knownMDRs = new HashMap<URI, IMetadataRepository>();
        HashMap<URI, Object> knownARs = new HashMap<URI, Object>();
        try {
            File file = this.getRuntimeRepository();
            URI runtimeAR = file.toURI();
            knownARs.put(runtimeAR, arManager.loadRepository(runtimeAR, (IProgressMonitor)subMon.newChild(100)));
        }
        catch (Exception e) {
            CorePlugin.getLogger().warning((Throwable)e, "Unable to load runtime repository: " + e.getMessage(), new Object[0]);
        }
        for (Map.Entry entry : resPerLocation.entrySet()) {
            IArtifactRepository destAR;
            File destDir = (File)entry.getKey();
            try {
                destAR = arManager.createRepository(destDir.toURI(), "Runnable repository.", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            }
            catch (ProvisionException e) {
                destAR = arManager.loadRepository(destDir.toURI(), null);
            }
            List ress = (List)entry.getValue();
            ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>(ress.size());
            for (Resolution res : ress) {
                IQueryResult result;
                Iterator itor;
                SubMonitor subSubMon = subMon.newChild(800 / ress.size());
                subSubMon.setWorkRemaining(1000);
                ComponentIdentifier cid = res.getComponentIdentifier();
                Version version = Version.create((String)cid.getVersion().toString());
                URI repoURI = P2Materializer.cleanURIFromImportType(URI.create(res.getRepository()));
                String path = repoURI.getPath();
                if (path.endsWith(".jar")) {
                    this.fetchP2object(context, destDir, destAR, res, subSubMon, cid, version);
                    continue;
                }
                IMetadataRepository mdr = (IMetadataRepository)knownMDRs.get(repoURI);
                if (mdr == null) {
                    try {
                        mdr = P2Materializer.getMetadataRepository(mdrManager, repoURI, (IProgressMonitor)subSubMon.newChild(500));
                        knownMDRs.put(repoURI, mdr);
                    }
                    catch (ProvisionException pe) {
                        if (1000 != pe.getStatus().getCode()) {
                            throw pe;
                        }
                        this.fetchP2object(context, destDir, destAR, res, subSubMon, cid, version);
                        continue;
                    }
                }
                VersionRange range = new VersionRange(version, true, version, true);
                String name = cid.getName();
                boolean isFeature = "eclipse.feature".equals(cid.getComponentTypeID());
                if (isFeature) {
                    name = String.valueOf(name) + ".feature.jar";
                }
                if (!(itor = (result = mdr.query(QueryUtil.createIUQuery((String)name, (VersionRange)range), (IProgressMonitor)subSubMon.newChild(250))).iterator()).hasNext()) {
                    throw new ProvisionException(NLS.bind((String)Messages.Unable_to_resolve_0_1_in_MDR_2, (Object[])new Object[]{cid.getName(), version, res.getRepository()}));
                }
                IInstallableUnit iu = (IInstallableUnit)itor.next();
                ius.add(iu);
                if (iu.getArtifacts().size() > 0) {
                    IArtifactRepository ar = (IArtifactRepository)knownARs.get(repoURI);
                    if (ar != null) continue;
                    ar = P2Materializer.getArtifactRepository(arManager, repoURI, (IProgressMonitor)subSubMon.newChild(250));
                    knownARs.put(repoURI, ar);
                    continue;
                }
                subSubMon.worked(250);
            }
            IFileArtifactRepository tempAr = P2ReaderType.getTempAR(subMon.newChild(1));
            knownARs.put(tempAr.getLocation(), tempAr);
            InstallableUnitOperand[] operands = new InstallableUnitOperand[ius.size()];
            int i = 0;
            for (IInstallableUnit iu : ius) {
                operands[i++] = new InstallableUnitOperand(null, iu);
            }
            String destDirStr = destDir.toString();
            if (!registry.containsProfile(destDirStr)) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("org.eclipse.equinox.p2.cache.shared", Boolean.toString(false));
                properties.put("org.eclipse.update.install.features", Boolean.toString(true));
                properties.put("org.eclipse.equinox.p2.cache", destDirStr);
                properties.put("org.eclipse.equinox.p2.installFolder", destDirStr);
                registry.addProfile(destDirStr, properties);
            }
            IProfile profile = registry.getProfile(destDirStr);
            try {
                PhaseSet phaseSet = new PhaseSet(new Phase[]{new Collect(100)}){};
                Set mdrURIs = knownMDRs.keySet();
                Set arURIs = knownARs.keySet();
                ProvisioningContext pctx = new ProvisioningContext(p2Agent);
                pctx.setMetadataRepositories(mdrURIs.toArray(new URI[mdrURIs.size()]));
                pctx.setArtifactRepositories(arURIs.toArray(new URI[arURIs.size()]));
                ProvisioningPlan plan = new ProvisioningPlan(profile, (Operand[])operands, pctx);
                IStatus status = engine.perform((IProvisioningPlan)plan, (IPhaseSet)phaseSet, (IProgressMonitor)subMon.newChild(200));
                if (status.getSeverity() == 4) {
                    throw BuckminsterException.wrap((IStatus)status);
                }
            }
            finally {
                if (profile != null) {
                    registry.removeProfile(profile.getProfileId());
                }
            }
            IContainer[] destConts = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(destDir.toURI());
            if (destConts == null || destConts.length <= 0) continue;
            IContainer[] iContainerArray = destConts;
            int n = destConts.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer destCont = iContainerArray[n2];
                IProject project = destCont.getProject();
                if (project.isOpen()) {
                    project.refreshLocal(2, (IProgressMonitor)subMon.newChild(1));
                }
                ++n2;
            }
        }
        TargetPlatform.getInstance().locationsChanged(resPerLocation.keySet());
        return Collections.emptyList();
    }

    private void convertSourceJar(IComponentIdentifier cid, File bundleJar, Manifest mf) throws IOException {
        File tempRoot = bundleJar.getParentFile();
        File outFile = null;
        ZipOutputStream out = null;
        FileInputStream in = new FileInputStream(bundleJar);
        try {
            String name = cid.getName();
            String binName = name.substring(0, name.length() - 7);
            String strVer = cid.getVersion().toString();
            if (mf == null) {
                mf = new Manifest();
            }
            Attributes attrs = mf.getMainAttributes();
            attrs.putValue("Bundle-SymbolicName", name);
            attrs.putValue("Bundle-Name", "Source for " + binName);
            attrs.putValue("Bundle-Version", strVer);
            attrs.putValue("Bundle-ManifestVersion", "2");
            attrs.putValue("Eclipse-SourceBundle", String.valueOf(binName) + ";version=" + strVer);
            outFile = File.createTempFile("newbundle-", ".jar", tempRoot);
            out = new ZipOutputStream(new FileOutputStream(outFile));
            ZipEntry ze = new ZipEntry("META-INF/");
            out.putNextEntry(ze);
            ze = new ZipEntry("META-INF/MANIFEST.MF");
            out.putNextEntry(ze);
            mf.write(out);
            ZipInputStream zin = new ZipInputStream(in);
            while ((ze = zin.getNextEntry()) != null) {
                if ("META-INF/".equals(ze.getName()) || "META-INF/MANIFEST.MF".equals(ze.getName())) continue;
                out.putNextEntry(ze);
                if (ze.isDirectory()) continue;
                IOUtils.copy((InputStream)zin, (OutputStream)out, null);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable)in);
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close((Closeable)in);
        IOUtils.close((Closeable)out);
        File tmpRename = File.createTempFile("oldbundle-", ".jar", tempRoot);
        if (tmpRename.delete() && bundleJar.renameTo(tmpRename)) {
            if (!outFile.renameTo(bundleJar)) {
                tmpRename.renameTo(bundleJar);
                throw new IOException("Unable to rename " + outFile.getAbsolutePath() + " to " + bundleJar.getAbsolutePath());
            }
        } else {
            throw new IOException("Unable to rename " + bundleJar.getAbsolutePath() + " to " + tmpRename.getAbsolutePath());
        }
        tmpRename.delete();
    }

    private void fetchP2object(MaterializationContext context, File destDir, IArtifactRepository destAR, Resolution res, SubMonitor subSubMon, IComponentIdentifier cid, Version version) throws CoreException {
        Object convertSource;
        ArtifactKey aKey = "eclipse.feature".equals(cid.getComponentTypeID()) ? new ArtifactKey(CLASSIFIER_ORG_ECLIPSE_UPDATE_FEATURE, cid.getName(), version) : new ArtifactKey(CLASSIFIER_OSGI_BUNDLE, cid.getName(), version);
        if (destAR.contains((IArtifactKey)aKey)) {
            return;
        }
        IComponentType ctype = CorePlugin.getDefault().getComponentType(cid.getComponentTypeID());
        IPath location = Path.fromOSString((String)destDir.getAbsolutePath());
        IPath ctypeRelative = ctype.getRelativeLocation();
        if (ctypeRelative != null) {
            location = location.append(ctypeRelative);
        }
        location.toFile().mkdirs();
        String leafName = String.valueOf(cid.getName()) + '_' + cid.getVersion();
        if (res.isUnpack()) {
            location = location.append(leafName);
            location = location.addTrailingSeparator();
        } else {
            location = location.append(String.valueOf(leafName) + ".jar");
        }
        IReaderType readerType = CorePlugin.getDefault().getReaderType(res.getReaderTypeId());
        IComponentReader reader = readerType.getReader(res, context, (IProgressMonitor)subSubMon.newChild(10));
        try {
            reader.materialize(location, res, context, (IProgressMonitor)subSubMon.newChild(500));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        if (cid.getName().endsWith(".source") && CLASSIFIER_OSGI_BUNDLE.equals(cid.getComponentTypeID()) && !res.isUnpack() && (convertSource = context.get("buckminster.convert.source")) != null && "true".equalsIgnoreCase(convertSource.toString())) {
            try {
                File bundleJar = location.toFile();
                Manifest mf = null;
                JarFile jar = null;
                try {
                    jar = new JarFile(bundleJar);
                    mf = jar.getManifest();
                }
                finally {
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (mf == null || mf.getMainAttributes().getValue("Bundle-SymbolicName") == null) {
                    this.convertSourceJar(cid, bundleJar, mf);
                }
            }
            catch (Exception e) {
                CorePlugin.getLogger().warning(e.getMessage(), new Object[]{e});
            }
        }
        SimpleArtifactDescriptor desc = new SimpleArtifactDescriptor((IArtifactKey)aKey);
        if ("eclipse.feature".equals(cid.getComponentTypeID()) || res.isUnpack()) {
            desc.addRepositoryProperties(Collections.singletonMap(PROP_ARTIFACT_FOLDER, Boolean.toString(true)));
        }
        destAR.addDescriptor((IArtifactDescriptor)desc, (IProgressMonitor)subSubMon.newChild(10));
    }
}

